/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.api.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public abstract class FileChecksumCalculator {
    public static final String SHA256_ALGORITHM = "SHA-256";
    public static final String SHA1_ALGORITHM = "SHA1";
    public static final String MD5_ALGORITHM = "MD5";
    private static final int BUFFER_SIZE = 32768;

    public static Map<String, String> calculateChecksums(File fileToCalculate, String ... algorithms) throws NoSuchAlgorithmException, IOException {
        if (fileToCalculate == null) {
            throw new IllegalArgumentException("Cannot read checksums of null file.");
        }
        if (!fileToCalculate.exists()) {
            throw new IllegalArgumentException("Cannot read checksums of non-existent file: " + fileToCalculate.getAbsolutePath());
        }
        if (!fileToCalculate.isFile()) {
            throw new IllegalArgumentException("Cannot read checksums of a folder: " + fileToCalculate.getAbsolutePath());
        }
        if (algorithms == null) {
            throw new IllegalArgumentException("Checksum algorithms cannot be null.");
        }
        if (algorithms.length == 0) {
            return new HashMap<String, String>();
        }
        return FileChecksumCalculator.calculate(fileToCalculate, algorithms);
    }

    private static Map<String, String> calculate(File fileToCalculate, String ... algorithms) throws NoSuchAlgorithmException, IOException {
        HashMap<String, MessageDigest> digestMap = new HashMap<String, MessageDigest>();
        HashMap<String, String> checksumMap = new HashMap<String, String>();
        for (String algorithm : algorithms) {
            digestMap.put(algorithm, MessageDigest.getInstance(algorithm));
        }
        try (FileInputStream inputStream = new FileInputStream(fileToCalculate);){
            byte[] buffer = new byte[32768];
            int size = inputStream.read(buffer, 0, 32768);
            while (size >= 0) {
                for (String algorithm : algorithms) {
                    ((MessageDigest)digestMap.get(algorithm)).update(buffer, 0, size);
                }
                size = inputStream.read(buffer, 0, 32768);
            }
        }
        for (String algorithm : algorithms) {
            byte[] bytes = ((MessageDigest)digestMap.get(algorithm)).digest();
            StringBuilder sb = new StringBuilder();
            for (byte aBinaryData : bytes) {
                String t2 = Integer.toHexString(aBinaryData & 0xFF);
                if (t2.length() == 1) {
                    sb.append("0");
                }
                sb.append(t2);
            }
            checksumMap.put(algorithm, sb.toString().trim());
        }
        return checksumMap;
    }
}

