/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.client.distribution.services;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.JFrogHttpClient;
import org.jfrog.build.extractor.clientConfiguration.client.JFrogService;
import org.jfrog.build.extractor.clientConfiguration.client.distribution.response.GetReleaseBundleStatusResponse;

public class GetReleaseBundleVersion
extends JFrogService<GetReleaseBundleStatusResponse> {
    private static final String CREAT_RELEASE_BUNDLE_ENDPOINT = "api/v1/release_bundle";
    private final String version;
    private final String name;

    public GetReleaseBundleVersion(String name, String version, Log logger) {
        super(logger);
        this.name = name;
        this.version = version;
    }

    @Override
    public HttpRequestBase createRequest() throws IOException {
        return new HttpGet(this.createUrl());
    }

    @Override
    protected void ensureRequirements(JFrogHttpClient client) throws IOException {
        if (StringUtils.isBlank((CharSequence)this.name)) {
            throw new IOException("Release bundle name is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)this.version)) {
            throw new IOException("Release bundle version is mandatory");
        }
    }

    @Override
    protected void setResponse(InputStream stream) throws IOException {
        this.result = this.getMapper().readValue(stream, GetReleaseBundleStatusResponse.class);
    }

    @Override
    protected void handleUnsuccessfulResponse(HttpEntity entity) throws IOException {
        if (this.getStatusCode() == 404) {
            return;
        }
        super.handleUnsuccessfulResponse(entity);
    }

    private String createUrl() {
        return String.format("%s/%s/%s", CREAT_RELEASE_BUNDLE_ENDPOINT, this.name, this.version);
    }
}

