/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.util.generic;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.dependency.DownloadableArtifact;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.ci.Dependency;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.clientConfiguration.util.DependenciesDownloader;
import org.jfrog.build.extractor.clientConfiguration.util.DependenciesDownloaderHelper;

public class DependenciesDownloaderImpl
implements DependenciesDownloader {
    private final ArtifactoryManager artifactoryManager;
    private Log log;
    private File workingDirectory;
    private boolean flatDownload = false;

    public DependenciesDownloaderImpl(ArtifactoryManager artifactoryManager, File workingDirectory, Log log) {
        this.artifactoryManager = artifactoryManager;
        this.workingDirectory = workingDirectory;
        this.log = log;
    }

    @Override
    public ArtifactoryManager getArtifactoryManager() {
        return this.artifactoryManager;
    }

    @Override
    public List<Dependency> download(Set<DownloadableArtifact> downloadableArtifacts) throws IOException {
        DependenciesDownloaderHelper helper = new DependenciesDownloaderHelper(this, this.log);
        return helper.downloadDependencies(downloadableArtifacts);
    }

    @Override
    public String getTargetDir(String targetDir, String relativeDir) {
        return FilenameUtils.concat((String)this.workingDirectory.getPath(), (String)FilenameUtils.concat((String)targetDir, (String)relativeDir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> saveDownloadedFile(InputStream is, String filePath) throws IOException {
        try {
            File newFile = new File(filePath);
            com.atlassian.core.util.FileUtils.copyFile((InputStream)is, (File)newFile, (boolean)true);
            Map<String, String> map = FileChecksumCalculator.calculateChecksums(newFile, "md5", "sha1");
            return map;
        }
        catch (Exception e) {
            this.log.warn("Caught exception while saving dependency file" + e.getLocalizedMessage());
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return null;
    }

    @Override
    public boolean isFileExistsLocally(String filePath, String md5, String sha1) throws IOException {
        File localFile = new File(filePath);
        if (!localFile.exists()) {
            return false;
        }
        if (localFile.isDirectory()) {
            return true;
        }
        try {
            Map<String, String> checksumsMap = FileChecksumCalculator.calculateChecksums(localFile, "md5", "sha1");
            return checksumsMap != null && StringUtils.isNotBlank((String)md5) && StringUtils.equals((String)md5, (String)checksumsMap.get("md5")) && StringUtils.isNotBlank((String)sha1) && StringUtils.equals((String)sha1, (String)checksumsMap.get("sha1"));
        }
        catch (NoSuchAlgorithmException e) {
            this.log.warn("Could not find checksum algorithm: " + e.getLocalizedMessage());
            return false;
        }
    }

    @Override
    public void removeUnusedArtifactsFromLocal(Set<String> allResolvesFiles, Set<String> forDeletionFiles) throws IOException {
        try {
            for (String resolvedFile : forDeletionFiles) {
                File resolvedFileParent = FileUtils.getFile((String[])new String[]{resolvedFile}).getParentFile();
                File[] fileSiblings = resolvedFileParent.listFiles();
                if (fileSiblings == null || fileSiblings.length == 0) continue;
                for (File sibling : fileSiblings) {
                    if (this.isResolvedOrParentOfResolvedFile(allResolvesFiles, sibling.getPath())) continue;
                    this.log.info("Deleted unresolved file '" + sibling.getPath() + "'");
                    sibling.delete();
                }
            }
        }
        catch (Exception e) {
            this.log.warn("Caught interrupted exception: " + e.getLocalizedMessage());
        }
    }

    private boolean isResolvedOrParentOfResolvedFile(Set<String> resolvedFiles, final String path) {
        return Iterables.any(resolvedFiles, (Predicate)new Predicate<String>(){

            public boolean apply(String filePath) {
                return StringUtils.equals((String)filePath, (String)path) || StringUtils.startsWith((String)filePath, (String)path);
            }
        });
    }

    public boolean getFlatDownload() {
        return this.flatDownload;
    }

    @Override
    public void setFlatDownload(boolean flat) {
        this.flatDownload = flat;
    }
}

