/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.task;

import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.spring.container.ContainerManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.builder.BuildInfoHelper;
import org.jfrog.bamboo.configuration.BuildParamsOverrideManager;
import org.jfrog.bamboo.context.PublishBuildInfoContext;
import org.jfrog.bamboo.task.ArtifactoryTaskType;
import org.jfrog.bamboo.util.PublishedBuildDetails;
import org.jfrog.bamboo.util.PublishedBuilds;
import org.jfrog.bamboo.util.TaskUtils;
import org.jfrog.bamboo.util.generic.GenericData;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.ci.BuildInfo;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryManagerBuilder;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;

public class ArtifactoryPublishBuildInfoTask
extends ArtifactoryTaskType {
    public static final String TASK_NAME = "artifactoryPublishBuildInfoTask";
    private final EnvironmentVariableAccessor environmentVariableAccessor;
    private CustomVariableContext customVariableContext;
    private BuildInfoHelper buildInfoHelper;

    public ArtifactoryPublishBuildInfoTask(EnvironmentVariableAccessor environmentVariableAccessor) {
        this.environmentVariableAccessor = environmentVariableAccessor;
        ContainerManager.autowireComponent((Object)this);
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }

    @Override
    protected void initTask(@NotNull CommonTaskContext context) throws TaskException {
        super.initTask(context);
        PublishBuildInfoContext publishBuildInfoContext = new PublishBuildInfoContext((Map<String, String>)context.getConfigurationMap());
        BuildParamsOverrideManager buildParamsOverrideManager = new BuildParamsOverrideManager(this.customVariableContext);
        BuildContext buildContext = ((TaskContext)context).getBuildContext();
        Map runtimeContext = context.getRuntimeTaskContext();
        this.buildInfoHelper = BuildInfoHelper.createDeployBuildInfoHelper(publishBuildInfoContext.getBuildName(buildContext), publishBuildInfoContext.getBuildNumber(buildContext), context, buildContext, this.environmentVariableAccessor, publishBuildInfoContext.getArtifactoryServerId(), publishBuildInfoContext.getOverriddenUsername(runtimeContext, this.buildInfoLog, true), publishBuildInfoContext.getOverriddenPassword(runtimeContext, this.buildInfoLog, true), buildParamsOverrideManager);
    }

    @Override
    @NotNull
    public TaskResult runTask(@NotNull TaskContext taskContext) {
        Map customBuildData = taskContext.getBuildContext().getBuildResult().getCustomBuildData();
        ArtifactoryManagerBuilder clientBuilder = this.buildInfoHelper.getClientBuilder(this.logger, log);
        try (ArtifactoryManager client = clientBuilder.build();){
            String aggregatedBuildsJson = TaskUtils.getAndDeleteAggregatedBuildInfo(taskContext);
            BuildInfo build = this.buildInfoHelper.getBuilder(taskContext).build();
            if (StringUtils.isNotBlank((String)aggregatedBuildsJson)) {
                this.addBuildsToPublish(taskContext, build, aggregatedBuildsJson);
            }
            client.publishBuildInfo(build, "");
            this.addPublishedBuildDetailsToBuildData(client.getUrl(), build.getName(), build.getNumber(), taskContext, customBuildData);
        }
        catch (IOException e) {
            String message = "Exception occurred while executing task";
            this.logger.addErrorLogEntry(message, (Throwable)e);
            log.error(message, (Throwable)e);
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failedWithError().build();
        }
        if (!customBuildData.containsKey("org.jfrog.bamboo.buildInfo.activated")) {
            customBuildData.put("org.jfrog.bamboo.buildInfo.activated", "true");
        }
        return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).success().build();
    }

    private void addBuildsToPublish(TaskContext taskContext, BuildInfo build, String publishCandidatesJson) throws IOException {
        GenericData buildsGenericData = BuildInfoExtractorUtils.jsonStringToGeneric(publishCandidatesJson, GenericData.class);
        List<BuildInfo> allBuilds = buildsGenericData.getBuilds();
        ArrayList<BuildInfo> buildsToRemove = new ArrayList<BuildInfo>();
        for (BuildInfo buildFromContext : allBuilds) {
            if (!buildFromContext.getName().equals(build.getName()) || !buildFromContext.getNumber().equals(build.getNumber())) continue;
            build.append(buildFromContext);
            buildsToRemove.add(buildFromContext);
        }
        allBuilds.removeAll(buildsToRemove);
        buildsGenericData.setBuilds(allBuilds);
        if (buildsGenericData.getBuilds().isEmpty()) {
            return;
        }
        String aggregatedBuildInfo = BuildInfoExtractorUtils.buildInfoToJsonString(buildsGenericData);
        TaskUtils.addBuildInfoToContext(taskContext, aggregatedBuildInfo);
    }

    private void addPublishedBuildDetailsToBuildData(String artifactoryUrl, String buildName, String buildNumber, TaskContext taskContext, Map<String, String> customBuildData) throws IOException {
        PublishedBuilds pb = new PublishedBuilds();
        if (customBuildData.containsKey("org.jfrog.bamboo.buildInfo.published")) {
            pb = BuildInfoExtractorUtils.jsonStringToGeneric(customBuildData.get("org.jfrog.bamboo.buildInfo.published"), PublishedBuilds.class);
        }
        PublishedBuildDetails buildDetails = new PublishedBuildDetails(artifactoryUrl, buildName, buildNumber);
        pb.addBuild(buildDetails);
        String pbAsString = BuildInfoExtractorUtils.buildInfoToJsonString(pb);
        taskContext.getBuildContext().getBuildResult().getCustomBuildData().put("org.jfrog.bamboo.buildInfo.published", pbAsString);
    }

    @Override
    protected ServerConfig getUsageServerConfig() {
        return this.buildInfoHelper.getServerConfig();
    }

    @Override
    protected String getTaskUsageName() {
        return "publish_build_info";
    }

    @Override
    protected boolean shouldRemoveBuildInfoFromContext() {
        return false;
    }
}

