/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.task;

import com.atlassian.bamboo.build.ErrorLogEntry;
import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.LogInterceptor;
import com.atlassian.bamboo.build.logger.interceptors.ErrorMemorisingInterceptor;
import com.atlassian.bamboo.build.test.TestCollationService;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.utils.process.ExternalProcess;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.tools.ant.types.Commandline;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.builder.BuilderDependencyHelper;
import org.jfrog.bamboo.builder.MavenDataHelper;
import org.jfrog.bamboo.context.Maven3BuildContext;
import org.jfrog.bamboo.task.BaseJavaBuildTask;
import org.jfrog.bamboo.util.PluginProperties;
import org.jfrog.bamboo.util.TaskUtils;
import org.jfrog.bamboo.util.Utils;

public class ArtifactoryMaven3Task
extends BaseJavaBuildTask {
    public static final String TASK_NAME = "maven3Task";
    private final EnvironmentVariableAccessor environmentVariableAccessor;
    private final BuilderDependencyHelper dependencyHelper;
    private final CapabilityContext capabilityContext;
    private Maven3BuildContext mavenBuildContext;
    private MavenDataHelper mavenDataHelper;
    private String artifactoryPluginVersion;

    public ArtifactoryMaven3Task(ProcessService processService, EnvironmentVariableAccessor environmentVariableAccessor, CapabilityContext capabilityContext, TestCollationService testCollationService) {
        super(testCollationService, environmentVariableAccessor, processService);
        this.environmentVariableAccessor = environmentVariableAccessor;
        this.capabilityContext = capabilityContext;
        this.dependencyHelper = new BuilderDependencyHelper("artifactoryMaven3Builder");
        ContainerManager.autowireComponent((Object)this.dependencyHelper);
    }

    @Override
    protected void initTask(@NotNull CommonTaskContext taskContext) throws TaskException {
        super.initTask(taskContext);
        this.artifactoryPluginVersion = Utils.getPluginVersion(this.pluginAccessor);
        this.mavenBuildContext = this.createBuildContext(taskContext);
        this.initEnvironmentVariables(this.mavenBuildContext);
        this.aggregateBuildInfo = this.mavenBuildContext.shouldAggregateBuildInfo(taskContext);
        this.mavenDataHelper = new MavenDataHelper(this.buildParamsOverrideManager, (TaskContext)taskContext, this.mavenBuildContext, this.environmentVariableAccessor, this.artifactoryPluginVersion, this.aggregateBuildInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public TaskResult runTask(@NotNull TaskContext taskContext) throws TaskException {
        String mavenHome;
        String mavenDependenciesDir;
        this.logger.addBuildLogEntry("Bamboo Artifactory Plugin version: " + this.artifactoryPluginVersion);
        ErrorMemorisingInterceptor errorLines = new ErrorMemorisingInterceptor();
        this.logger.getInterceptorStack().add((LogInterceptor)errorLines);
        long serverId = this.mavenBuildContext.getResolutionArtifactoryServerId();
        if (serverId == -1L) {
            serverId = this.mavenBuildContext.getArtifactoryServerId();
        }
        File rootDirectory = taskContext.getRootDirectory();
        try {
            mavenDependenciesDir = this.extractMaven3Dependencies(serverId, this.mavenBuildContext);
        }
        catch (IOException e) {
            mavenDependenciesDir = null;
            this.logger.addBuildLogEntry((LogEntry)new ErrorLogEntry("Error occurred while preparing Artifactory Maven Runner dependencies. Build Info support is disabled: " + e.getMessage()));
            log.error("Error occurred while preparing Artifactory Maven Runner dependencies. Build Info support is disabled.", (Throwable)e);
        }
        ArrayList<String> systemProps = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)mavenDependenciesDir)) {
            this.createBuildInfoFiles(this.aggregateBuildInfo, this.mavenDataHelper);
            this.mavenDataHelper.addPasswordsSystemProps(systemProps, this.mavenBuildContext, taskContext);
        } else {
            this.aggregateBuildInfo = false;
        }
        String subDirectory = this.mavenBuildContext.getWorkingSubDirectory();
        if (StringUtils.isNotBlank((String)subDirectory)) {
            rootDirectory = new File(rootDirectory, subDirectory);
        }
        if (StringUtils.isBlank((String)(mavenHome = this.getMavenHome(this.mavenBuildContext)))) {
            log.error(this.logger.addErrorLogEntry("Maven home is not defined!"));
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failed().build();
        }
        this.environmentVariables.put("MAVEN_HOME", mavenHome);
        String jdkPath = this.getConfiguredJdkPath(this.buildParamsOverrideManager, this.mavenBuildContext, this.capabilityContext);
        if (jdkPath == null) {
            throw new RuntimeException("JDK path is not configured. Please make sure the agent has a well configured JDK capability.");
        }
        List<String> command = this.buildCommand(mavenHome, jdkPath, rootDirectory, systemProps, mavenDependenciesDir);
        this.environmentVariables.put("JAVA_HOME", jdkPath);
        ExternalProcess process = this.getExternalProcess(taskContext, rootDirectory, command, this.environmentVariables);
        try {
            this.executeExternalProcess(this.logger, process, log);
            if (this.aggregateBuildInfo) {
                this.convertGeneratedBuildInfoToBuild();
            }
            TaskResult taskResult = this.collectTestResults(this.mavenBuildContext, taskContext, process);
            return taskResult;
        }
        finally {
            taskContext.getBuildContext().getBuildResult().addBuildErrors(errorLines.getErrorStringList());
        }
    }

    @Override
    protected ServerConfig getUsageServerConfig() {
        ServerConfig config = this.mavenDataHelper.getDeployServer();
        if (config == null) {
            config = this.mavenDataHelper.getResolveServer();
        }
        return config;
    }

    @Override
    protected String getTaskUsageName() {
        return "maven";
    }

    public String getJavaExecutable(String jdkPath) {
        StringBuilder binPathBuilder = new StringBuilder(jdkPath);
        if (SystemUtils.IS_OS_WINDOWS && !this.containerized) {
            binPathBuilder.append("bin").append(this.fileSeparator).append("java.exe");
        } else {
            String aixJdkLocation = "jre" + this.fileSeparator + "sh" + File.separator + "java";
            File aixJdk = new File(binPathBuilder.toString() + aixJdkLocation);
            if (aixJdk.isFile()) {
                binPathBuilder.append(aixJdkLocation);
            } else {
                binPathBuilder.append("bin").append(this.fileSeparator).append("java");
            }
        }
        String binPath = binPathBuilder.toString();
        binPath = this.getCanonicalPath(binPath);
        return binPath;
    }

    private List<String> buildCommand(String mavenHome, String jdkPath, File rootDirectory, List<String> systemProps, String mavenDependenciesDir) {
        List<String> command = this.getCommand(jdkPath);
        this.appendClassPathArguments(command, mavenHome);
        this.addMavenHome(command, mavenHome);
        this.addMavenConf(command, mavenHome);
        this.addMavenPluginLib(command, mavenDependenciesDir);
        this.appendClassWorldsConfArgument(command, mavenHome);
        this.appendBuildInfoPropertiesArgument(command);
        this.appendMavenOpts(command, this.mavenBuildContext);
        this.addMavenMultiModuleProjectPath(command, rootDirectory);
        command.add("org.codehaus.plexus.classworlds.launcher.Launcher");
        this.appendGoals(command, this.mavenBuildContext);
        this.appendAdditionalMavenParameters(command, this.mavenBuildContext);
        log.debug("Running maven command: " + command.toString());
        command.addAll(systemProps);
        return command;
    }

    private Maven3BuildContext createBuildContext(CommonTaskContext context) {
        Map<String, String> combinedMap = this.getCombinedConfiguration(context);
        return new Maven3BuildContext(combinedMap);
    }

    private void addMavenHome(List<String> command, String mavenHome) {
        command.add(Commandline.quoteArgument((String)("-Dmaven.home=" + mavenHome)));
    }

    private void addMavenConf(List<String> command, String mavenHome) {
        command.add(Commandline.quoteArgument((String)("-Dmaven.conf=" + mavenHome + this.fileSeparator + "conf")));
    }

    private void addMavenMultiModuleProjectPath(List<String> command, File rootDirectory) {
        command.add(Commandline.quoteArgument((String)("-Dmaven.multiModuleProjectDirectory=" + rootDirectory.getPath())));
    }

    private List<String> getCommand(String jdkPath) {
        ArrayList command = Lists.newArrayList();
        String executable = this.getJavaExecutable(jdkPath);
        if (StringUtils.isBlank((String)executable)) {
            log.error("No Maven executable found");
            return command;
        }
        if (SystemUtils.IS_OS_WINDOWS && !this.containerized) {
            command.add("cmd.exe");
            command.add("/c");
            command.add("call");
        }
        command.add(Commandline.quoteArgument((String)executable));
        return command;
    }

    private void appendMavenOpts(List<String> arguments, Maven3BuildContext mavenBuildContext) {
        String mavenOpts = mavenBuildContext.getMavenOpts();
        if (StringUtils.isNotBlank((String)mavenOpts)) {
            String[] mavenOptsToken;
            for (String opt : mavenOptsToken = StringUtils.split((String)mavenOpts, (String)" ")) {
                if (!StringUtils.isNotBlank((String)opt)) continue;
                arguments.add(Commandline.quoteArgument((String)opt));
            }
        }
    }

    private void appendClassPathArguments(List<String> arguments, String mavenHomePath) {
        arguments.add("-cp");
        StringBuilder classPathBuilder = this.getPathBuilder(mavenHomePath).append("boot").append(this.fileSeparator).append("*");
        arguments.add(classPathBuilder.toString());
    }

    void appendDeployGoalIfNeeded(List<String> arguments) {
        if (arguments.contains("deploy")) {
            return;
        }
        File propertiesFile = this.findPropertiesFile();
        if (propertiesFile == null || !propertiesFile.exists()) {
            this.logger.addBuildLogEntry("appendDeployGoalIfNeeded: Properties file not found in agent or server home directory.");
            return;
        }
        Properties properties = new Properties();
        try (FileInputStream fis = new FileInputStream(propertiesFile);){
            properties.load(fis);
        }
        catch (IOException e) {
            this.logger.addBuildLogEntry("appendDeployGoalIfNeeded: Failed to read properties file: " + e.getMessage());
            return;
        }
        String deployAlwaysValue = properties.getProperty("artifactory.maven3.deploy.always");
        if ("true".equalsIgnoreCase(deployAlwaysValue)) {
            this.logger.addBuildLogEntry("appendDeployGoalIfNeeded: 'artifactory.maven3.deploy.always' is set to true. Appending deploy goal.");
            arguments.add("deploy");
        }
    }

    private File findPropertiesFile() {
        String[] possibleLocations;
        for (String location : possibleLocations = new String[]{System.getenv("BAMBOO_AGENT_HOME"), System.getProperty("bamboo.home"), System.getenv("BAMBOO_HOME")}) {
            File propertiesFile;
            if (location == null || location.isEmpty() || !(propertiesFile = new File(location, "artifactory.bamboo.plugin.properties")).exists()) continue;
            return propertiesFile;
        }
        return null;
    }

    private void appendGoals(List<String> arguments, Maven3BuildContext context) {
        String altTasks;
        String goals = context.getGoals();
        if (context.releaseManagementContext.isActivateReleaseManagement() && StringUtils.isNotBlank((String)(altTasks = context.releaseManagementContext.getAlternativeTasks()))) {
            goals = altTasks;
        }
        goals = this.getStringWithoutNewLines(goals);
        String[] goalArray = StringUtils.split((String)goals, (String)" ");
        arguments.addAll(Arrays.asList(goalArray));
        this.appendDeployGoalIfNeeded(arguments);
    }

    private void addMavenPluginLib(List<String> command, String mavenDependenciesDir) {
        if (!StringUtils.contains((String)this.mavenBuildContext.getMavenOpts(), (String)"-Dm3plugin.lib")) {
            command.add("-Dm3plugin.lib=" + mavenDependenciesDir);
        }
    }

    private void appendClassWorldsConfArgument(List<String> arguments, String mavenHomePath) {
        String classworldsConfPath;
        block10: {
            if (this.activateBuildInfoRecording) {
                try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("maven3/classworlds-freestyle.conf");){
                    if (is == null) {
                        throw new RuntimeException("Error occurred while writing Maven 3 customized m2.conf: 'maven3/classworlds-freestyle.conf' doesn't exist.");
                    }
                    File tempM2Conf = File.createTempFile("artifactoryM2", "conf", this.bambooTmp);
                    Files.copy(is, tempM2Conf.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    classworldsConfPath = tempM2Conf.toString();
                    break block10;
                }
                catch (IOException ioe) {
                    throw new RuntimeException("Error occurred while writing Maven 3 customized m2.conf", ioe);
                }
            }
            classworldsConfPath = this.getPathBuilder(mavenHomePath).append("bin").append(this.fileSeparator).append("m2.conf").toString();
        }
        arguments.add(Commandline.quoteArgument((String)("-Dclassworlds.conf=" + classworldsConfPath)));
    }

    private void appendBuildInfoPropertiesArgument(List<String> arguments) {
        if (this.activateBuildInfoRecording) {
            TaskUtils.appendBuildInfoPropertiesArgument(arguments, this.buildInfoPropertiesFile);
        }
    }

    private String extractMaven3Dependencies(long artifactoryServerId, Maven3BuildContext mavenBuildContext) throws IOException {
        if (artifactoryServerId == -1L && !this.aggregateBuildInfo) {
            return null;
        }
        return this.dependencyHelper.downloadDependenciesAndGetPath(this.bambooTmp, TaskUtils.getPlanKey(this.customVariableContext), mavenBuildContext, PluginProperties.getPluginProperty("maven3.dependency.file.name"));
    }

    private void appendAdditionalMavenParameters(List<String> arguments, Maven3BuildContext context) {
        String projectFile;
        String additionalParams = context.getAdditionalMavenParams();
        if (StringUtils.isNotBlank((String)additionalParams)) {
            String formattedParams = this.getStringWithoutNewLines(additionalParams);
            String[] paramArray = StringUtils.split((String)formattedParams, (String)" ");
            arguments.addAll(Arrays.asList(paramArray));
        }
        if (StringUtils.isNotBlank((String)(projectFile = context.getProjectFile()))) {
            arguments.addAll(Arrays.asList("-f", projectFile));
        }
    }

    private String getMavenHome(Maven3BuildContext context) {
        return this.capabilityContext.getCapabilityValue("system.builder.maven." + context.getExecutable());
    }

    private String getStringWithoutNewLines(String stringToModify) {
        return StringUtils.replaceChars((String)stringToModify, (String)"\r\n", (String)"  ");
    }
}

