/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.task;

import com.atlassian.bamboo.build.logger.LogInterceptor;
import com.atlassian.bamboo.build.logger.interceptors.ErrorMemorisingInterceptor;
import com.atlassian.bamboo.build.test.TestCollationService;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.utils.process.ExternalProcess;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.tools.ant.types.Commandline;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.builder.BuilderDependencyHelper;
import org.jfrog.bamboo.builder.GradleDataHelper;
import org.jfrog.bamboo.context.GradleBuildContext;
import org.jfrog.bamboo.context.PackageManagersContext;
import org.jfrog.bamboo.task.BaseJavaBuildTask;
import org.jfrog.bamboo.util.ConfigurationPathHolder;
import org.jfrog.bamboo.util.PluginProperties;
import org.jfrog.bamboo.util.TaskUtils;
import org.jfrog.bamboo.util.Utils;

public class ArtifactoryGradleTask
extends BaseJavaBuildTask {
    public static final String TASK_NAME = "artifactoryGradleTask";
    public static final String EXECUTABLE_WRAPPER_NAME = SystemUtils.IS_OS_WINDOWS ? "./gradlew.bat" : "./gradlew";
    public static final String EXECUTABLE_NAME = SystemUtils.IS_OS_WINDOWS ? "gradle.bat" : "gradle";
    private static final String GRADLE_KEY = "system.builder.gradle.";
    private AdministrationConfiguration administrationConfiguration;
    private final BuilderDependencyHelper dependencyHelper;
    private final CapabilityContext capabilityContext;
    private GradleBuildContext gradleBuildContext;
    private GradleDataHelper gradleDataHelper;
    private String artifactoryPluginVersion;
    private String gradleDependenciesDir;

    public ArtifactoryGradleTask(ProcessService processService, EnvironmentVariableAccessor environmentVariableAccessor, CapabilityContext capabilityContext, TestCollationService testCollationService) {
        super(testCollationService, environmentVariableAccessor, processService);
        this.capabilityContext = capabilityContext;
        this.dependencyHelper = new BuilderDependencyHelper("artifactoryGradleBuilder");
        ContainerManager.autowireComponent((Object)this.dependencyHelper);
    }

    @Override
    protected void initTask(@NotNull CommonTaskContext context) throws TaskException {
        super.initTask(context);
        this.artifactoryPluginVersion = Utils.getPluginVersion(this.pluginAccessor);
        this.gradleBuildContext = this.createBuildContext(context);
        this.initEnvironmentVariables(this.gradleBuildContext);
        this.aggregateBuildInfo = this.gradleBuildContext.shouldAggregateBuildInfo(context);
        this.gradleDataHelper = new GradleDataHelper(this.buildParamsOverrideManager, context, this.gradleBuildContext, this.administrationConfiguration, this.environmentVariableAccessor, this.artifactoryPluginVersion, this.aggregateBuildInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public TaskResult runTask(@NotNull TaskContext context) throws TaskException {
        ConfigurationPathHolder pathHolder;
        String altTasks;
        this.logger.addBuildLogEntry("Bamboo Artifactory Plugin version: " + this.artifactoryPluginVersion);
        ErrorMemorisingInterceptor errorLines = new ErrorMemorisingInterceptor();
        this.logger.getInterceptorStack().add((LogInterceptor)errorLines);
        File rootDirectory = context.getRootDirectory();
        try {
            this.gradleDependenciesDir = this.extractGradleDependencies(this.gradleBuildContext.getArtifactoryServerId(), this.gradleBuildContext);
        }
        catch (IOException e) {
            this.buildInfoLog.error("Error occurred while preparing Artifactory Gradle Runner dependencies. Build Info support is disabled: ", e);
        }
        String gradleCommandLine = this.getExecutable(this.gradleBuildContext);
        if (StringUtils.isBlank((String)gradleCommandLine)) {
            log.error(this.logger.addErrorLogEntry("Gradle executable is not defined!"));
            return TaskResultBuilder.newBuilder((CommonTaskContext)context).failed().build();
        }
        ArrayList command = Lists.newArrayList((Object[])new String[]{gradleCommandLine});
        String switches = this.gradleBuildContext.getSwitches();
        if (StringUtils.isNotBlank((String)switches)) {
            String[] switchTokens = StringUtils.split((String)switches, (char)' ');
            command.addAll(Arrays.asList(switchTokens));
        }
        String tasks = this.gradleBuildContext.getTasks();
        if (this.gradleBuildContext.releaseManagementContext.isActivateReleaseManagement() && StringUtils.isNotBlank((String)(altTasks = this.gradleBuildContext.releaseManagementContext.getAlternativeTasks()))) {
            tasks = altTasks;
        }
        if (StringUtils.isNotBlank((String)tasks)) {
            String[] taskTokens = StringUtils.split((String)tasks, (char)' ');
            command.addAll(Arrays.asList(taskTokens));
        }
        if ((pathHolder = this.getGradleInitScriptFile(this.gradleDataHelper, this.gradleBuildContext, this.aggregateBuildInfo)) != null) {
            if (!this.gradleBuildContext.useArtifactoryGradlePlugin()) {
                command.add("-I");
                command.add(Commandline.quoteArgument((String)pathHolder.getInitScriptPath()));
            }
            TaskUtils.appendBuildInfoPropertiesArgument(command, pathHolder.getClientConfPath());
            command.add("artifactoryPublish");
        } else {
            this.aggregateBuildInfo = false;
        }
        String subDirectory = this.gradleBuildContext.getBuildScript();
        if (StringUtils.isNotBlank((String)subDirectory)) {
            rootDirectory = new File(rootDirectory, subDirectory);
        }
        String jdkPath = this.getConfiguredJdkPath(this.buildParamsOverrideManager, this.gradleBuildContext, this.capabilityContext);
        this.environmentVariables.put("JAVA_HOME", jdkPath);
        this.gradleDataHelper.addPasswordsSystemProps(command, context);
        ExternalProcess process = this.getExternalProcess(context, rootDirectory, command, this.environmentVariables);
        try {
            this.executeExternalProcess(this.logger, process, log);
            if (this.aggregateBuildInfo) {
                this.convertGeneratedBuildInfoToBuild();
            }
            TaskResult taskResult = this.collectTestResults(this.gradleBuildContext, context, process);
            return taskResult;
        }
        finally {
            context.getBuildContext().getBuildResult().addBuildErrors(errorLines.getErrorStringList());
        }
    }

    @Override
    protected ServerConfig getUsageServerConfig() {
        return this.gradleDataHelper.getDeployServer();
    }

    @Override
    protected String getTaskUsageName() {
        return "gradle";
    }

    private GradleBuildContext createBuildContext(CommonTaskContext context) {
        Map<String, String> combinedMap = this.getCombinedConfiguration(context);
        return new GradleBuildContext(combinedMap);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private ConfigurationPathHolder getGradleInitScriptFile(GradleDataHelper initScriptHelper, GradleBuildContext buildContext, boolean aggregateBuildInfo) {
        File gradleJarFile = new File(this.gradleDependenciesDir, PluginProperties.getPluginProperty("gradle.dependency.file.name"));
        if (!gradleJarFile.exists()) {
            log.warn(this.logger.addBuildLogEntry("Unable to locate the Gradle extractor. Build-info task will not be added."));
            return null;
        }
        try (JarFile gradleJar = new JarFile(gradleJarFile);){
            ConfigurationPathHolder configurationPathHolder;
            block21: {
                InputStream initScriptStream;
                block19: {
                    ConfigurationPathHolder configurationPathHolder2;
                    block20: {
                        ZipEntry initScriptEntry = gradleJar.getEntry("initscripttemplate.gradle");
                        if (initScriptEntry == null) {
                            log.warn(this.logger.addBuildLogEntry("Unable to locate the Gradle init script. Build-info task will not be added."));
                            ConfigurationPathHolder configurationPathHolder3 = null;
                            return configurationPathHolder3;
                        }
                        initScriptStream = gradleJar.getInputStream(initScriptEntry);
                        try {
                            if (initScriptStream != null) break block19;
                            log.warn(this.logger.addBuildLogEntry("Unable to locate the gradle init script template. Build-info task will not be added."));
                            configurationPathHolder2 = null;
                            if (initScriptStream == null) break block20;
                        }
                        catch (Throwable throwable) {
                            if (initScriptStream != null) {
                                try {
                                    initScriptStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        initScriptStream.close();
                    }
                    return configurationPathHolder2;
                }
                String scriptTemplate = IOUtils.toString((InputStream)initScriptStream, (Charset)StandardCharsets.UTF_8);
                ConfigurationPathHolder configurationPathHolder4 = initScriptHelper.createAndGetGradleInitScriptPath(this.bambooTmp, this.gradleDependenciesDir, buildContext, scriptTemplate, this.environmentVariableAccessor.getEnvironment(), aggregateBuildInfo);
                if (aggregateBuildInfo) {
                    this.environmentVariables.put("generated.build.info", initScriptHelper.getBuildInfoTempFilePath().getAbsolutePath());
                }
                configurationPathHolder = configurationPathHolder4;
                if (initScriptStream == null) break block21;
                initScriptStream.close();
            }
            return configurationPathHolder;
        }
        catch (IOException e) {
            this.buildInfoLog.warn("Unable to read from the Gradle extractor jar. Build-info task will not be added: " + e.getMessage());
            return null;
        }
    }

    private String getExecutable(PackageManagersContext buildContext) throws TaskException {
        if (buildContext instanceof GradleBuildContext && ((GradleBuildContext)buildContext).isUseGradleWrapper()) {
            String gradleWrapperLocation = ((GradleBuildContext)buildContext).getGradleWrapperLocation();
            if (StringUtils.isNotBlank((String)gradleWrapperLocation)) {
                return gradleWrapperLocation;
            }
            return EXECUTABLE_WRAPPER_NAME;
        }
        return TaskUtils.getExecutablePath(buildContext, this.capabilityContext, GRADLE_KEY, EXECUTABLE_NAME, TASK_NAME, this.containerized);
    }

    private String extractGradleDependencies(long artifactoryServerId, GradleBuildContext context) throws IOException {
        if (artifactoryServerId == -1L && !this.aggregateBuildInfo) {
            return null;
        }
        return this.dependencyHelper.downloadDependenciesAndGetPath(this.bambooTmp, TaskUtils.getPlanKey(this.customVariableContext), context, PluginProperties.getPluginProperty("gradle.dependency.file.name"));
    }

    public void setAdministrationConfiguration(AdministrationConfiguration administrationConfiguration) {
        this.administrationConfiguration = administrationConfiguration;
    }
}

