/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.release.vcs.git;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CurrentBuildResult;
import com.atlassian.bamboo.variable.CustomVariableContext;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jfrog.bamboo.context.PackageManagersContext;
import org.jfrog.bamboo.release.vcs.AbstractVcsCoordinator;
import org.jfrog.bamboo.release.vcs.git.GitManager;

public class GitCoordinator
extends AbstractVcsCoordinator {
    private GitManager vcsManager;
    private String releaseBranch;
    private String checkoutBranch;
    private String baseCommitIsh;
    private State state = new State();
    private final Map<String, String> configuration;
    private final BuildLogger buildLogger;

    public GitCoordinator(BuildContext context, Map<String, String> configuration, BuildLogger buildLogger, CustomVariableContext customVariableContext, CredentialsAccessor credentialsAccessor) {
        super(context, buildLogger, customVariableContext, credentialsAccessor);
        this.configuration = configuration;
        this.buildLogger = buildLogger;
    }

    @Override
    public void prepare() throws IOException {
        this.releaseBranch = this.configuration.get("releaseBranch");
        this.vcsManager = new GitManager(this.context, this.buildLogger);
        this.baseCommitIsh = this.vcsManager.getCurrentCommitHash();
        this.checkoutBranch = this.vcsManager.getCurrentBranch();
    }

    @Override
    public void beforeReleaseVersionChange() throws IOException {
        if (Boolean.parseBoolean(this.configuration.get("useReleaseBranch"))) {
            this.vcsManager.checkoutBranch(this.releaseBranch, true);
            this.state.currentWorkingBranch = this.releaseBranch;
            this.state.releaseBranchCreated = true;
        } else {
            this.vcsManager.checkoutBranch(this.checkoutBranch, false);
            this.state.currentWorkingBranch = this.checkoutBranch;
        }
    }

    @Override
    public void afterSuccessfulReleaseVersionBuild() throws IOException, InterruptedException {
        if (this.modifiedFilesForReleaseVersion) {
            this.log(String.format("Committing release version on branch '%s'", this.checkoutBranch));
            String comment = this.configuration.get("tagComment");
            if (StringUtils.isBlank((String)comment)) {
                comment = "";
            }
            this.vcsManager.commitWorkingCopy(comment);
        }
        if (Boolean.parseBoolean(this.configuration.get("createVcsTag"))) {
            this.vcsManager.createTag(this.configuration.get("tagUrl"), this.configuration.get("tagComment"));
            this.state.tagCreated = true;
        }
        if (this.state.releaseBranchCreated) {
            this.vcsManager.push(this.vcsManager.getRemoteUrl(), this.state.currentWorkingBranch);
            this.state.releaseBranchPushed = true;
        }
        if (Boolean.parseBoolean(this.configuration.get("createVcsTag"))) {
            this.vcsManager.pushTag(this.vcsManager.getRemoteUrl(), this.configuration.get("tagUrl"));
            this.state.tagPushed = true;
        }
    }

    @Override
    public void beforeDevelopmentVersionChange() throws IOException {
        if (Boolean.parseBoolean(this.configuration.get("useReleaseBranch"))) {
            this.vcsManager.checkoutBranch(this.checkoutBranch, false);
            this.state.currentWorkingBranch = this.checkoutBranch;
        }
    }

    @Override
    public void afterDevelopmentVersionChange(boolean modified) throws IOException, InterruptedException {
        super.afterDevelopmentVersionChange(modified);
        if (modified) {
            this.log(String.format("Committing next development version on branch '%s'", this.state.currentWorkingBranch));
            String comment = this.configuration.get("nextDevelopmentComment");
            if (StringUtils.isBlank((String)comment)) {
                comment = "";
            }
            this.vcsManager.commitWorkingCopy(comment);
        }
    }

    @Override
    public void buildCompleted(BuildContext buildContext) throws IOException, InterruptedException {
        PackageManagersContext context = PackageManagersContext.createContextFromMap(this.configuration);
        CurrentBuildResult result = buildContext.getBuildResult();
        if (BuildState.SUCCESS.equals((Object)result.getBuildState())) {
            if (this.modifiedFilesForDevVersion) {
                this.vcsManager.push(this.vcsManager.getRemoteUrl(), this.checkoutBranch);
            }
        } else {
            this.vcsManager.checkoutBranch(this.checkoutBranch, false);
            this.state.currentWorkingBranch = this.checkoutBranch;
            if (this.state.releaseBranchCreated) {
                this.safeDeleteBranch(this.releaseBranch);
            }
            if (this.state.releaseBranchPushed) {
                this.safeDeleteRemoteBranch(this.vcsManager.getRemoteUrl(), this.releaseBranch);
            }
            if (this.state.tagCreated) {
                this.safeDeleteTag(context.releaseManagementContext.getTagUrl());
            }
            if (this.state.tagPushed) {
                this.safeDeleteRemoteTag(this.vcsManager.getRemoteUrl(), context.releaseManagementContext.getTagUrl());
            }
            this.safeRevertWorkingCopy();
        }
    }

    @Override
    public String getRemoteUrlForPom() {
        return null;
    }

    private void safeDeleteBranch(String branch) {
        try {
            this.vcsManager.deleteLocalBranch(branch);
        }
        catch (Exception e) {
            this.log(this.buildLogger.addBuildLogEntry("Failed to delete release branch: " + e.getLocalizedMessage()));
        }
    }

    private void safeDeleteRemoteBranch(String remoteRepository, String branch) {
        try {
            this.vcsManager.deleteRemoteBranch(remoteRepository, branch);
        }
        catch (Exception e) {
            this.log(this.buildLogger.addBuildLogEntry("Failed to delete remote release branch: " + e.getLocalizedMessage()));
        }
    }

    private void safeDeleteTag(String tag) {
        try {
            this.vcsManager.deleteLocalTag(tag);
        }
        catch (Exception e) {
            this.log(this.buildLogger.addBuildLogEntry("Failed to delete tag: " + e.getLocalizedMessage()));
        }
    }

    private void safeDeleteRemoteTag(String remoteRepository, String tag) {
        try {
            this.vcsManager.deleteRemoteTag(remoteRepository, tag);
        }
        catch (Exception e) {
            this.log(this.buildLogger.addBuildLogEntry("Failed to delete remote tag: " + e.getLocalizedMessage()));
        }
    }

    private void safeRevertWorkingCopy() {
        try {
            this.vcsManager.revertWorkingCopy(this.baseCommitIsh);
        }
        catch (Exception e) {
            this.log(this.buildLogger.addBuildLogEntry("Failed to revert working copy: " + e.getLocalizedMessage()));
        }
    }

    @Override
    public String getCheckoutBranch() {
        return this.checkoutBranch;
    }

    @Override
    public boolean isReleaseBranchCreated() {
        return this.state.releaseBranchCreated;
    }

    @Override
    public void setReleaseBranchCreated(boolean releaseBranchCreated) {
        this.state.releaseBranchCreated = releaseBranchCreated;
    }

    @Override
    public boolean isSubversion() {
        return false;
    }

    @Override
    public void setCheckoutBranch(String checkoutBranch) {
        this.checkoutBranch = checkoutBranch;
    }

    @Override
    public String getCurrentWorkingBranch() {
        return this.state.currentWorkingBranch;
    }

    @Override
    public void setCurrentWorkingBranch(String currentWorkingBranch) {
        this.state.currentWorkingBranch = currentWorkingBranch;
    }

    @Override
    public void setCommitIsh(String commitIsh) {
        this.baseCommitIsh = commitIsh;
    }

    @Override
    public String getCommitIsh() {
        return this.baseCommitIsh;
    }

    private static class State {
        String currentWorkingBranch;
        boolean releaseBranchCreated;
        boolean releaseBranchPushed;
        boolean tagCreated;
        boolean tagPushed;

        private State() {
        }
    }
}

