/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.release.action;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jfrog.bamboo.util.Utils;

public class ModuleVersionHolder
implements Serializable {
    private final String key;
    private final String originalValue;
    private boolean releaseProp;
    private String releaseValue;
    private String nextIntegValue;

    public ModuleVersionHolder(String key, String originalValue, boolean releaseProp) {
        this.key = key;
        this.originalValue = originalValue;
        this.releaseProp = releaseProp;
        this.releaseValue = "";
        this.nextIntegValue = "";
    }

    public ModuleVersionHolder(String key, String originalValue) {
        this(key, originalValue, false);
    }

    public String getKey() {
        return this.key;
    }

    public String getOriginalValue() {
        return this.originalValue;
    }

    public boolean isReleaseProp() {
        return this.releaseProp;
    }

    public void setReleaseProp(boolean releaseProp) {
        this.releaseProp = releaseProp;
    }

    public String getReleaseValue() {
        return this.releaseValue;
    }

    public void setReleaseValue(String releaseValue) {
        this.releaseValue = releaseValue;
    }

    public String getNextIntegValue() {
        if (this.releaseProp) {
            return this.originalValue;
        }
        return this.nextIntegValue;
    }

    public void setNextIntegValue(String nextIntegValue) {
        this.nextIntegValue = nextIntegValue;
    }

    public static List<ModuleVersionHolder> buildFromConf(Map<String, String> conf) {
        ArrayList result = Lists.newArrayList();
        int size = ModuleVersionHolder.getNumberOfModules(conf);
        for (int i = 0; i < size; ++i) {
            String moduleKey = conf.get("version.key." + i);
            String currentValue = conf.get("version.currentValue." + i);
            String integValue = conf.get("version.nextIntegValue." + i);
            String releaseValue = conf.get("version.releaseValue." + i);
            String releaseProp = conf.get("version.releaseProp." + i);
            boolean isReleaseProp = Boolean.parseBoolean(releaseProp);
            ModuleVersionHolder holder = new ModuleVersionHolder(moduleKey, currentValue, isReleaseProp);
            holder.setReleaseValue(releaseValue);
            holder.setNextIntegValue(integValue);
            result.add(holder);
        }
        return result;
    }

    private static int getNumberOfModules(Map<String, String> conf) {
        return Utils.filterMapKeysByPrefix(conf, "version.key").size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleVersionHolder holder = (ModuleVersionHolder)o;
        return this.key.equals(holder.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }
}

