/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.configuration.util;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.admin.ServerConfigManager;
import org.jfrog.bamboo.release.vcs.VcsTypes;
import org.jfrog.bamboo.release.vcs.git.GitAuthenticationType;

public class TaskConfigurationValidations {
    public static void validateExecutable(String executableKey, @NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        if (StringUtils.isBlank((String)params.getString(executableKey))) {
            errorCollection.addError(executableKey, "Please specify an Executable.");
        }
    }

    public static void validateJdk(String buildJdkKey, @NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        if (StringUtils.isBlank((String)params.getString(buildJdkKey))) {
            errorCollection.addError(buildJdkKey, "Please specify Build JDK.");
        }
    }

    public static void validateArtifactoryServerProvidedAndValid(String serverKey, ServerConfigManager serverConfigManager, @NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        if (StringUtils.isBlank((String)params.getString(serverKey))) {
            errorCollection.addError(serverKey, "Please specify a Server.");
            return;
        }
        TaskConfigurationValidations.validateServer(serverKey, serverConfigManager, params, errorCollection);
    }

    public static void validateArtifactoryServerAndRepo(String serverKey, String repositoryKey, ServerConfigManager serverConfigManager, @NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        boolean shouldCheckRepo = TaskConfigurationValidations.validateServer(serverKey, serverConfigManager, params, errorCollection);
        if (shouldCheckRepo) {
            TaskConfigurationValidations.validateRepo(repositoryKey, params, errorCollection);
        }
    }

    private static boolean validateServer(String serverKey, ServerConfigManager serverConfigManager, @NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        if (!params.containsKey((Object)serverKey)) {
            return false;
        }
        long configuredServerId = TaskConfigurationValidations.getConfiguredServerId(serverKey, params);
        if (configuredServerId == -1L) {
            return false;
        }
        TaskConfigurationValidations.validateServerConfigExists(configuredServerId, serverKey, serverConfigManager, errorCollection);
        return true;
    }

    private static void validateRepo(String repositoryKey, @NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        if (StringUtils.isBlank((String)params.getString(repositoryKey))) {
            errorCollection.addError(repositoryKey, "Please choose a repository.");
        }
    }

    private static void validateServerConfigExists(long configuredServerId, String serverKey, ServerConfigManager serverConfigManager, @NotNull ErrorCollection errorCollection) {
        ServerConfig serverConfig = serverConfigManager.getServerConfigById(configuredServerId);
        if (serverConfig == null) {
            errorCollection.addError(serverKey, "Could not find Artifactory server configuration by the ID " + configuredServerId);
        }
    }

    private static long getConfiguredServerId(String serverKey, @NotNull ActionParametersMap params) {
        try {
            return params.getLong(serverKey, -1L);
        }
        catch (ConversionException ce) {
            return -1L;
        }
    }

    public static void validateReleaseManagement(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        String enableReleaseManagementKey = "enableReleaseManagement";
        if (!params.getBoolean(enableReleaseManagementKey)) {
            return;
        }
        String vcsTypeKey = "artifactory.vcs.type";
        if (VcsTypes.GIT.toString().equals(params.getString(vcsTypeKey))) {
            String gitUrlKey = "artifactory.vcs.git.url";
            if (!params.containsKey((Object)gitUrlKey) || StringUtils.isBlank((String)params.getString(gitUrlKey))) {
                errorCollection.addError(gitUrlKey, "Please specify Git URL.");
            }
            String gitAuthenticationKey = "artifactory.vcs.git.authenticationType";
            if (GitAuthenticationType.PASSWORD.toString().equals(params.getString(gitAuthenticationKey))) {
                String gitPasswordKey;
                String gitUsernameKey = "artifactory.vcs.git.username";
                if (!params.containsKey((Object)gitUsernameKey) || StringUtils.isBlank((String)params.getString(gitUsernameKey))) {
                    errorCollection.addError(gitUsernameKey, "Please specify Username.");
                }
                if (!params.containsKey((Object)(gitPasswordKey = "artifactory.vcs.git.password")) || StringUtils.isBlank((String)params.getString(gitPasswordKey))) {
                    errorCollection.addError(gitUsernameKey, "Please specify Password.");
                }
            }
            return;
        }
        if (VcsTypes.PERFORCE.toString().equals(params.getString(vcsTypeKey))) {
            String perforceDepot;
            String perforceClient;
            String perforcePort = "artifactory.vcs.p4.port";
            if (!params.containsKey((Object)perforcePort) || StringUtils.isBlank((String)params.getString(perforcePort))) {
                errorCollection.addError(perforcePort, "Please specify Port.");
            }
            if (!params.containsKey((Object)(perforceClient = "artifactory.vcs.p4.client")) || StringUtils.isBlank((String)params.getString(perforceClient))) {
                errorCollection.addError(perforceClient, "Please specify Client (workspace).");
            }
            if (!params.containsKey((Object)(perforceDepot = "artifactory.vcs.p4.depot")) || StringUtils.isBlank((String)params.getString(perforceDepot))) {
                errorCollection.addError(perforceDepot, "Please specify Depot view.");
            }
        }
    }

    public static void validateCaptureBuildInfoParams(String buildNameKey, String buildNumberKey, String captureBuildInfoKey, @NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        if (params.getBoolean(captureBuildInfoKey)) {
            TaskConfigurationValidations.validateBuildNameNumber(buildNameKey, buildNumberKey, params, errorCollection);
        }
    }

    public static void validateBuildNameNumber(String buildNameKey, String buildNumberKey, @NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        if (StringUtils.isBlank((String)params.getString(buildNameKey))) {
            errorCollection.addError(buildNameKey, "Please specify Build Name.");
        }
        if (StringUtils.isBlank((String)params.getString(buildNumberKey))) {
            errorCollection.addError(buildNumberKey, "Please specify Build Number.");
        }
    }
}

