/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.configuration;

import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.utils.EscapeChars;
import com.atlassian.spring.container.ContainerManager;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;

public class ConfigurationHelper
implements Serializable {
    public static final String DEFAULT_JDK = "JAVA_HOME";
    private static ConfigurationHelper instance = new ConfigurationHelper();
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private HttpClient httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());

    private ConfigurationHelper() {
        ContainerManager.autowireComponent((Object)this);
    }

    public static ConfigurationHelper getInstance() {
        return instance;
    }

    public void setAdministrationConfigurationAccessor(AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }

    public Map<String, String> getAllVariables(PlanKey planKey) {
        HashMap params = Maps.newHashMap();
        params.put("planKey", planKey);
        String requestUrl = this.prepareRequestUrl("artifactoryAdminConfigServlet", params);
        GetMethod getMethod = new GetMethod(requestUrl);
        try {
            Map map;
            block15: {
                InputStream responseStream;
                JsonFactory jsonFactory;
                block13: {
                    HashMap hashMap;
                    block14: {
                        this.executeMethod(requestUrl, getMethod);
                        jsonFactory = new JsonFactory();
                        ObjectMapper mapper = new ObjectMapper();
                        jsonFactory.setCodec((ObjectCodec)mapper);
                        responseStream = getMethod.getResponseBodyAsStream();
                        try {
                            if (responseStream != null) break block13;
                            hashMap = Maps.newHashMap();
                            if (responseStream == null) break block14;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (responseStream != null) {
                                    try {
                                        responseStream.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IOException e) {
                                String message = "Failed while invoking URL " + requestUrl + " to get Bamboo variables. " + e.getMessage();
                                throw new RuntimeException(message, e);
                            }
                        }
                        responseStream.close();
                    }
                    return hashMap;
                }
                JsonParser parser = jsonFactory.createJsonParser(responseStream);
                map = (Map)parser.readValueAs(Map.class);
                if (responseStream == null) break block15;
                responseStream.close();
            }
            return map;
        }
        finally {
            getMethod.releaseConnection();
        }
    }

    private String prepareRequestUrl(String servletName, Map<String, PlanKey> params) {
        String bambooBaseUrl = this.administrationConfigurationAccessor.getAdministrationConfiguration().getBaseUrl();
        StringBuilder builder = new StringBuilder(bambooBaseUrl);
        if (!bambooBaseUrl.endsWith("/")) {
            builder.append("/");
        }
        StringBuilder requestUrlBuilder = builder.append("plugins/servlet/").append(servletName);
        if (params.size() != 0) {
            requestUrlBuilder.append("?");
            for (Map.Entry<String, PlanKey> param : params.entrySet()) {
                if (!requestUrlBuilder.toString().endsWith("?")) {
                    requestUrlBuilder.append("&");
                }
                requestUrlBuilder.append(param.getKey()).append("=").append(EscapeChars.forFormSubmission((String)param.getValue().getKey()));
            }
        }
        return requestUrlBuilder.toString();
    }

    private void executeMethod(String requestUrl, GetMethod getMethod) throws IOException {
        int responseCode = this.httpClient.executeMethod((HttpMethod)getMethod);
        if (responseCode == 404) {
            throw new IOException("Unable to find requested resource: " + requestUrl);
        }
        if (responseCode != 200) {
            throw new IOException("Failed to retrieve requested resource: " + requestUrl + ". Response code: " + responseCode + ", Message: " + getMethod.getStatusText());
        }
    }
}

