/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.google.common.collect.Lists;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jfrog.bamboo.configuration.AbstractArtifactoryConfiguration;
import org.jfrog.bamboo.configuration.util.TaskConfigurationValidations;
import org.jfrog.bamboo.context.Maven3BuildContext;
import org.jfrog.bamboo.context.PackageManagersContext;

public class ArtifactoryMaven3Configuration
extends AbstractArtifactoryConfiguration {
    public static final String KEY = "artifactoryMaven3Builder";
    private static final Set<String> FIELDS_TO_COPY = Maven3BuildContext.getFieldsToCopy();
    private static final String DEFAULT_TEST_RESULTS_FILE_PATTERN = "**/target/surefire-reports/*.xml";

    public ArtifactoryMaven3Configuration() {
        super("builder.artifactoryMaven3Builder.", "system.builder.maven");
    }

    @Override
    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        this.populateLegacyContextForCreate(context);
        context.put("maven3Task", (Object)this);
        context.put("builderType", (Object)this);
        context.put("builder", (Object)this);
        context.put("baseUrl", this.administrationConfiguration.getBaseUrl());
        Plan plan = (Plan)context.get("plan");
        context.put("build", plan);
        context.put("dummyList", Lists.newArrayList());
        context.put("serverConfigManager", this.serverConfigManager);
        context.put("testDirectoryOption", "standardTestDirectory");
        context.put("selectedServerId", -1);
        context.put("selectedRepoKey", "");
        context.put("selectedResolutionArtifactoryServerId", -1);
        context.put("selectedResolutionRepoKey", "");
        context.put("builder.artifactoryMaven3Builder.gitReleaseBranch", "REL-BRANCH-");
        context.put("artifactory.vcs.git.vcs.type.list", this.getVcsTypes());
        context.put("artifactory.vcs.git.authenticationType.list", this.getGitAuthenticationTypes());
    }

    @Override
    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.populateLegacyContextForEdit(context, taskDefinition);
        this.populateContextWithConfiguration(context, taskDefinition, FIELDS_TO_COPY);
        String publishingKey = "builder.artifactoryMaven3Builder.deployableRepo";
        String selectedPublishingRepoKey = context.get(publishingKey) != null ? context.get(publishingKey).toString() : "noPublishingRepoKeyConfigured";
        context.put("selectedRepoKey", selectedPublishingRepoKey);
        Maven3BuildContext buildContext = Maven3BuildContext.createMavenContextFromMap(context);
        String resolutionRepo = buildContext.getResolutionRepo();
        if (resolutionRepo == null) {
            resolutionRepo = "";
        }
        context.put("selectedResolutionArtifactoryServerId", buildContext.getResolutionArtifactoryServerId());
        context.put("selectedResolutionRepoKey", resolutionRepo);
        context.put("selectedServerId", buildContext.getArtifactoryServerId());
        context.put("hasTests", buildContext.isTestChecked());
        context.put("serverConfigManager", this.serverConfigManager);
        context.put("artifactory.vcs.git.vcs.type.list", this.getVcsTypes());
        context.put("artifactory.vcs.git.authenticationType.list", this.getGitAuthenticationTypes());
        ArtifactoryMaven3Configuration.populateDefaultEnvVarsExcludePatternsInBuildContext(context);
        ArtifactoryMaven3Configuration.populateDefaultBuildNameNumberInBuildContext(context);
        Map taskConfiguration = taskDefinition.getConfiguration();
        Maven3BuildContext taskContext = new Maven3BuildContext(taskConfiguration);
        if (StringUtils.isBlank((CharSequence)taskContext.getResolverOverrideCredentialsChoice()) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{taskContext.getResolverUsername(), taskContext.getResolverPassword()})) {
            context.put("resolver.overrideCredentialsChoice", "usernamePassword");
        }
        if (StringUtils.isBlank((CharSequence)taskContext.getDeployerOverrideCredentialsChoice()) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{taskContext.getDeployerUsername(), taskContext.getDeployerPassword()})) {
            context.put("deployer.overrideCredentialsChoice", "usernamePassword");
        }
    }

    @Override
    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map<String, String> taskConfigMap = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(taskConfigMap, params, FIELDS_TO_COPY);
        Maven3BuildContext buildContext = new Maven3BuildContext(taskConfigMap);
        this.resetDeployerConfigIfNeeded(buildContext);
        this.resetResolverConfigIfNeeded(buildContext);
        taskConfigMap.put("builder.artifactoryMaven3Builder.testResultsDirectory", this.getTestDirectory(buildContext));
        taskConfigMap.putAll(super.getSshFileContent(params, previousTaskDefinition));
        this.decryptFields(taskConfigMap);
        return taskConfigMap;
    }

    @Override
    protected void resetResolverConfigIfNeeded(PackageManagersContext buildContext) {
        long serverId = buildContext.getResolutionArtifactoryServerId();
        boolean resolveFromArtifactory = ((Maven3BuildContext)buildContext).isResolveFromArtifactory();
        if (serverId == -1L || !resolveFromArtifactory) {
            buildContext.resetResolverContextToDefault();
        }
    }

    @Override
    protected String getKey() {
        return KEY;
    }

    @Override
    protected String getDefaultTestDirectory() {
        return DEFAULT_TEST_RESULTS_FILE_PATTERN;
    }

    public boolean taskProducesTestResults(@NotNull TaskDefinition definition) {
        return new Maven3BuildContext(definition.getConfiguration()).isTestChecked();
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        String resolutionServerKey = "builder.artifactoryMaven3Builder.resolutionArtifactoryServerId";
        String resolutionRepoKey = "builder.artifactoryMaven3Builder.resolutionRepo";
        TaskConfigurationValidations.validateArtifactoryServerAndRepo(resolutionServerKey, resolutionRepoKey, this.serverConfigManager, params, errorCollection);
        String deploymentServerKey = "builder.artifactoryMaven3Builder.artifactoryServerId";
        String deploymentRepoKey = "builder.artifactoryMaven3Builder.deployableRepo";
        TaskConfigurationValidations.validateArtifactoryServerAndRepo(deploymentServerKey, deploymentRepoKey, this.serverConfigManager, params, errorCollection);
        String goalsKey = "builder.artifactoryMaven3Builder.goal";
        if (StringUtils.isBlank((CharSequence)params.getString(goalsKey))) {
            errorCollection.addError(goalsKey, "Please specify Goals.");
        }
        String buildJdkKey = "builder.artifactoryMaven3Builder.buildJdk";
        TaskConfigurationValidations.validateJdk(buildJdkKey, params, errorCollection);
        String executableKey = "builder.artifactoryMaven3Builder.executable";
        TaskConfigurationValidations.validateExecutable(executableKey, params, errorCollection);
        TaskConfigurationValidations.validateReleaseManagement(params, errorCollection);
        TaskConfigurationValidations.validateCaptureBuildInfoParams("artifactory.task.buildName", "artifactory.task.buildNumber", "captureBuildInfo", params, errorCollection);
    }
}

