/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.google.common.collect.Lists;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jfrog.bamboo.configuration.AbstractArtifactoryConfiguration;
import org.jfrog.bamboo.configuration.util.TaskConfigurationValidations;
import org.jfrog.bamboo.context.IvyBuildContext;

public class ArtifactoryIvyConfiguration
extends AbstractArtifactoryConfiguration {
    public static final String KEY = "artifactoryIvyBuilder";
    protected static final String DEFAULT_TEST_REPORTS_XML = "**/test-reports/*.xml";
    private static final Set<String> FIELDS_TO_COPY = IvyBuildContext.getFieldsToCopy();

    public ArtifactoryIvyConfiguration() {
        super("builder.artifactoryIvyBuilder.", "system.builder.ivy");
    }

    @Override
    protected String getKey() {
        return KEY;
    }

    @Override
    protected String getDefaultTestDirectory() {
        return DEFAULT_TEST_REPORTS_XML;
    }

    @Override
    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        this.populateLegacyContextForCreate(context);
        context.put("artifactoryIvyTask", (Object)this);
        context.put("builderType", (Object)this);
        context.put("builder", (Object)this);
        context.put("adminConfig", this.administrationConfiguration);
        context.put("baseUrl", this.administrationConfiguration.getBaseUrl());
        context.put("build", context.get("plan"));
        context.put("dummyList", Lists.newArrayList());
        context.put("serverConfigManager", this.serverConfigManager);
        context.put("selectedServerId", -1);
        context.put("selectedRepoKey", "");
    }

    @Override
    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.populateLegacyContextForEdit(context, taskDefinition);
        this.populateContextWithConfiguration(context, taskDefinition, FIELDS_TO_COPY);
        String publishingKey = "builder.artifactoryIvyBuilder.deployableRepo";
        String selectedPublishingRepoKey = context.get(publishingKey) != null ? context.get(publishingKey).toString() : "noPublishingRepoKeyConfigured";
        context.put("selectedRepoKey", selectedPublishingRepoKey);
        context.put("selectedServerId", context.get("builder.artifactoryIvyBuilder.artifactoryServerId"));
        context.put("serverConfigManager", this.serverConfigManager);
        ArtifactoryIvyConfiguration.populateDefaultEnvVarsExcludePatternsInBuildContext(context);
        ArtifactoryIvyConfiguration.populateDefaultBuildNameNumberInBuildContext(context);
        Map taskConfiguration = taskDefinition.getConfiguration();
        IvyBuildContext taskContext = new IvyBuildContext(taskConfiguration);
        if (StringUtils.isBlank((CharSequence)taskContext.getDeployerOverrideCredentialsChoice()) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{taskContext.getDeployerUsername(), taskContext.getDeployerPassword()})) {
            context.put("deployer.overrideCredentialsChoice", "usernamePassword");
        }
    }

    @Override
    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map<String, String> configMap = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(configMap, params, FIELDS_TO_COPY);
        IvyBuildContext buildContext = new IvyBuildContext(configMap);
        this.resetDeployerConfigIfNeeded(buildContext);
        this.resetResolverConfigIfNeeded(buildContext);
        configMap.put("builder.artifactoryIvyBuilder.testResultsDirectory", this.getTestDirectory(buildContext));
        this.decryptFields(configMap);
        return configMap;
    }

    public boolean taskProducesTestResults(@NotNull TaskDefinition definition) {
        return new IvyBuildContext(definition.getConfiguration()).isTestChecked();
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        String targetsKey;
        String resolutionServerKey = "builder.artifactoryIvyBuilder.artifactoryServerId";
        String resolutionRepoKey = "builder.artifactoryIvyBuilder.deployableRepo";
        TaskConfigurationValidations.validateArtifactoryServerAndRepo(resolutionServerKey, resolutionRepoKey, this.serverConfigManager, params, errorCollection);
        String buildFileKey = "builder.artifactoryIvyBuilder.buildFile";
        if (StringUtils.isBlank((CharSequence)params.getString(buildFileKey))) {
            errorCollection.addError(buildFileKey, "Please specify Build File.");
        }
        if (StringUtils.isBlank((CharSequence)params.getString(targetsKey = "builder.artifactoryIvyBuilder.target"))) {
            errorCollection.addError(targetsKey, "Please specify Targets.");
        }
        String buildJdkKey = "builder.artifactoryIvyBuilder.buildJdk";
        TaskConfigurationValidations.validateJdk(buildJdkKey, params, errorCollection);
        String executableKey = "builder.artifactoryIvyBuilder.executable";
        TaskConfigurationValidations.validateExecutable(executableKey, params, errorCollection);
        TaskConfigurationValidations.validateCaptureBuildInfoParams("artifactory.task.buildName", "artifactory.task.buildNumber", "captureBuildInfo", params, errorCollection);
    }
}

