/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.TaskDefinition;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jfrog.bamboo.configuration.AbstractArtifactoryConfiguration;
import org.jfrog.bamboo.context.DeploymentUploadContext;
import org.jfrog.bamboo.util.deployment.LegacyDeploymentUtils;

public class ArtifactoryDeploymentUploadConfiguration
extends AbstractArtifactoryConfiguration {
    static final Set<String> FIELDS_TO_COPY = DeploymentUploadContext.getFieldsToCopy();
    public static final String DEPLOYMENT_PREFIX = "artifactory.deployment.";
    public static final String LEGACY_DEPLOYMENT_REPOSITORY = "deploymentRepository";
    public static final String PASSWORD = "password";
    public static final String USERNAME = "username";
    public static final String SPEC_SOURCE_CHOICE = "specSourceChoice";
    public static final String SPEC_SOURCE_JOB_CONFIGURATION = "jobConfiguration";
    public static final String SPEC_SOURCE_FILE = "file";

    @Override
    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        this.populateLegacyContextForCreate(context);
        context.put("serverConfigManager", this.serverConfigManager);
        context.put("selectedServerId", -1);
        context.put("artifactoryServerId", -1);
        this.contextPutEmpty(context, USERNAME);
        this.contextPutEmpty(context, PASSWORD);
        this.contextPutEmpty(context, "artifactoryServerId");
    }

    @Override
    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        Map taskConfiguration;
        DeploymentUploadContext taskContext;
        super.populateContextForEdit(context, taskDefinition);
        this.populateLegacyContextForEdit(context, taskDefinition);
        this.populateContextWithConfiguration(context, taskDefinition, FIELDS_TO_COPY);
        String selectedServerId = (String)taskDefinition.getConfiguration().get("artifactory.deployment.artifactoryServerId");
        String username = (String)taskDefinition.getConfiguration().get("artifactory.deployment.username");
        String password = (String)taskDefinition.getConfiguration().get("artifactory.deployment.password");
        if (StringUtils.isBlank((CharSequence)selectedServerId)) {
            selectedServerId = (String)taskDefinition.getConfiguration().get("artifactoryServerId");
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            username = (String)taskDefinition.getConfiguration().get(USERNAME);
            context.put("artifactory.deployment.username", username);
        }
        if (StringUtils.isBlank((CharSequence)password)) {
            password = (String)taskDefinition.getConfiguration().get(PASSWORD);
            context.put("artifactory.deployment.password", password);
        }
        context.put("serverConfigManager", this.serverConfigManager);
        context.put("selectedServerId", selectedServerId);
        String specSource = (String)taskDefinition.getConfiguration().get("artifactory.deployment.specSourceChoice");
        if (StringUtils.isBlank((CharSequence)specSource)) {
            String spec = this.createSpecFromLegacyConfig(taskDefinition);
            context.put("artifactory.deployment.jobConfiguration", spec);
        }
        if (StringUtils.isBlank((CharSequence)(taskContext = new DeploymentUploadContext(taskConfiguration = taskDefinition.getConfiguration())).getDeployerOverrideCredentialsChoice()) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{taskContext.getUsername(), taskContext.getPassword()})) {
            context.put("deployer.overrideCredentialsChoice", "usernamePassword");
        }
    }

    private String createSpecFromLegacyConfig(@NotNull TaskDefinition taskDefinition) {
        String selectedRepoKey = (String)taskDefinition.getConfiguration().get("artifactory.deployment.deploymentRepository");
        if (StringUtils.isBlank((CharSequence)selectedRepoKey)) {
            selectedRepoKey = (String)taskDefinition.getConfiguration().get(LEGACY_DEPLOYMENT_REPOSITORY);
        }
        if (StringUtils.isBlank((CharSequence)selectedRepoKey)) {
            return "";
        }
        return LegacyDeploymentUtils.buildDeploymentSpec(selectedRepoKey);
    }

    @Override
    protected String getKey() {
        return DEPLOYMENT_PREFIX;
    }

    public boolean taskProducesTestResults(@NotNull TaskDefinition taskDefinition) {
        return false;
    }

    private void contextPut(Map<String, Object> context, String key, String value) {
        context.put(DEPLOYMENT_PREFIX + key, value);
    }

    private void contextPutEmpty(Map<String, Object> context, String key) {
        context.put(DEPLOYMENT_PREFIX + key, "");
    }

    @Override
    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map<String, String> taskConfigMap = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(taskConfigMap, params, FIELDS_TO_COPY);
        this.decryptFields(taskConfigMap);
        return taskConfigMap;
    }
}

