/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.builder;

import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.utils.EscapeChars;
import com.atlassian.bamboo.v2.build.trigger.DependencyTriggerReason;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.builder.BaseBuildInfoHelper;
import org.jfrog.bamboo.configuration.BuildParamsOverrideManager;
import org.jfrog.bamboo.context.GradleBuildContext;
import org.jfrog.bamboo.util.BuildInfoLog;
import org.jfrog.bamboo.util.ConfigurationPathHolder;
import org.jfrog.bamboo.util.ProxyUtils;
import org.jfrog.bamboo.util.TaskUtils;
import org.jfrog.bamboo.util.version.VcsHelper;
import org.jfrog.build.api.util.NullLog;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.IncludeExcludePatterns;
import org.joda.time.DateTime;

public class GradleDataHelper
extends BaseBuildInfoHelper {
    private File buildInfoTempFile;
    private ServerConfig selectedServerConfig;
    private ArtifactoryClientConfiguration configuration;
    private String serverUrl;
    private String deployerUsername;
    private String deployerPassword;
    private String resolverUsername;
    private String resolverPassword;

    public GradleDataHelper(BuildParamsOverrideManager buildParamsOverrideManager, CommonTaskContext context, GradleBuildContext buildContext, AdministrationConfiguration administrationConfiguration, EnvironmentVariableAccessor envVarAccessor, String artifactoryPluginVersion, boolean aggregateBuildInfo) {
        super.init(buildParamsOverrideManager, ((TaskContext)context).getBuildContext(), context.getBuildLogger());
        this.setAdministrationConfiguration(administrationConfiguration);
        long selectedServerId = buildContext.getArtifactoryServerId();
        if (selectedServerId != -1L && this.isServerConfigured(selectedServerId) || aggregateBuildInfo) {
            this.configuration = this.createClientConfiguration(context, buildContext, this.selectedServerConfig, envVarAccessor.getEnvironment(context), artifactoryPluginVersion);
        }
    }

    protected boolean isServerConfigured(long selectedServerId) {
        this.selectedServerConfig = this.getConfiguredServer(this.buildInfoLog, selectedServerId);
        return this.selectedServerConfig != null;
    }

    public ConfigurationPathHolder createAndGetGradleInitScriptPath(File bambooTmp, String dependenciesDir, GradleBuildContext buildContext, String scriptTemplate, Map<String, String> generalEnv, boolean aggregateBuildInfo) {
        if (this.selectedServerConfig == null && !aggregateBuildInfo) {
            return null;
        }
        String normalizedPath = FilenameUtils.separatorsToUnix((String)dependenciesDir);
        scriptTemplate = scriptTemplate.replace("${pluginLibDir}", normalizedPath);
        try {
            File buildProps = File.createTempFile("buildinfo", "properties", bambooTmp);
            MapDifference buildVarDifference = Maps.difference(generalEnv, System.getenv());
            Map filteredBuildVarDifferences = buildVarDifference.entriesOnlyOnLeft();
            IncludeExcludePatterns patterns = new IncludeExcludePatterns(buildContext.getEnvVarsIncludePatterns(), buildContext.getEnvVarsExcludePatterns());
            if (aggregateBuildInfo) {
                this.buildInfoTempFile = File.createTempFile("generated.build.info", ".json", bambooTmp);
                this.configuration.info.setGeneratedBuildInfoFilePath(this.buildInfoTempFile.getAbsolutePath());
            }
            this.configuration.info.addBuildVariables(filteredBuildVarDifferences, patterns);
            this.configuration.setPropertiesFile(buildProps.getAbsolutePath());
            this.configuration.persistToPropertiesFile();
            File tempInitScript = File.createTempFile("artifactory.init.script", "gradle", bambooTmp);
            FileUtils.writeStringToFile((File)tempInitScript, (String)scriptTemplate, (String)"utf-8");
            if (buildContext.isPublishBuildInfo() || buildContext.isCaptureBuildInfo()) {
                this.context.getBuildResult().getCustomBuildData().put("org.jfrog.bamboo.buildInfo.activated", "true");
                this.context.getBuildResult().getCustomBuildData().put("org.jfrog.bamboo.release.activated", String.valueOf(buildContext.releaseManagementContext.isActivateReleaseManagement()));
                if (this.selectedServerConfig != null) {
                    this.context.getBuildResult().getCustomBuildData().put("org.jfrog.bamboo.buildInfo.serverUrl", this.selectedServerConfig.getUrl());
                }
            }
            return new ConfigurationPathHolder(tempInitScript.getCanonicalPath(), buildProps.getCanonicalPath());
        }
        catch (IOException e) {
            log.warn("An error occurred while creating the gradle build info init script. Build-info task will not be added.", (Throwable)e);
            return null;
        }
    }

    public File getBuildInfoTempFilePath() {
        return this.buildInfoTempFile;
    }

    private ArtifactoryClientConfiguration createClientConfiguration(CommonTaskContext taskContext, GradleBuildContext buildContext, ServerConfig serverConfig, Map<String, String> taskEnv, String artifactoryPluginVersion) {
        String[] vcsUrls;
        ArtifactoryClientConfiguration clientConf = new ArtifactoryClientConfiguration(new NullLog());
        String buildName = buildContext.getBuildName(this.context);
        clientConf.info.setBuildName(buildName);
        clientConf.info.setArtifactoryPluginVersion(artifactoryPluginVersion);
        clientConf.publisher.addMatrixParam("build.name", buildName);
        String buildNumber = buildContext.getBuildNumber(this.context);
        clientConf.info.setBuildNumber(buildNumber);
        clientConf.publisher.addMatrixParam("build.number", buildNumber);
        String vcsRevision = VcsHelper.getRevisionKey(this.context);
        if (StringUtils.isNotBlank((CharSequence)vcsRevision)) {
            clientConf.info.setVcsRevision(vcsRevision);
            clientConf.publisher.addMatrixParam("vcs.revision", vcsRevision);
        }
        if ((vcsUrls = VcsHelper.getVcsUrls(this.context)).length > 0) {
            clientConf.info.setVcsUrl(vcsUrls[0]);
        }
        String buildTimeStampVal = (String)this.context.getBuildResult().getCustomBuildData().get("buildTimeStamp");
        long buildTimeStamp = System.currentTimeMillis();
        if (StringUtils.isNotBlank((CharSequence)buildTimeStampVal)) {
            buildTimeStamp = new DateTime((Object)buildTimeStampVal).getMillis();
        }
        String buildTimeStampString = String.valueOf(buildTimeStamp);
        clientConf.info.setBuildTimestamp(buildTimeStampString);
        clientConf.publisher.addMatrixParam("build.timestamp", buildTimeStampString);
        StringBuilder summaryUrlBuilder = new StringBuilder(this.bambooBaseUrl);
        if (!this.bambooBaseUrl.endsWith("/")) {
            summaryUrlBuilder.append("/");
        }
        String buildUrl = summaryUrlBuilder.append("browse/").append(EscapeChars.forFormSubmission((String)this.context.getPlanResultKey().getKey())).toString();
        clientConf.info.setBuildUrl(buildUrl);
        String principal = this.getTriggeringUserNameRecursively(this.context);
        if (StringUtils.isBlank((CharSequence)principal)) {
            principal = "auto";
        }
        clientConf.info.setPrincipal(principal);
        this.addBuildParentProperties(clientConf, this.context.getTriggerReason());
        clientConf.info.setAgentName("Bamboo");
        clientConf.info.setAgentVersion(BuildUtils.getVersionAndBuild());
        clientConf.info.setReleaseEnabled(buildContext.releaseManagementContext.isActivateReleaseManagement());
        clientConf.info.setReleaseComment(buildContext.releaseManagementContext.getStagingComment());
        if (serverConfig != null) {
            this.addClientProperties(taskContext, clientConf, serverConfig, buildContext, taskEnv);
        }
        if (buildContext.isCaptureBuildInfo()) {
            clientConf.publisher.setPublishBuildInfo(false);
        } else {
            clientConf.publisher.setPublishBuildInfo(buildContext.isPublishBuildInfo());
        }
        clientConf.setIncludeEnvVars(buildContext.isIncludeEnvVars());
        clientConf.setEnvVarsIncludePatterns(buildContext.getEnvVarsIncludePatterns());
        clientConf.setEnvVarsExcludePatterns(buildContext.getEnvVarsExcludePatterns());
        HashMap props = Maps.newHashMap(TaskUtils.getEscapedEnvMap(taskEnv));
        props.putAll(this.getBuildInfoConfigPropertiesFileParams((String)props.get("buildInfoConfig.propertiesFile")));
        IncludeExcludePatterns patterns = new IncludeExcludePatterns(buildContext.getEnvVarsIncludePatterns(), buildContext.getEnvVarsExcludePatterns());
        clientConf.info.addBuildVariables(props, patterns);
        clientConf.fillFromProperties(props, patterns);
        return clientConf;
    }

    private void addBuildParentProperties(ArtifactoryClientConfiguration clientConf, TriggerReason triggerReason) {
        String triggeringBuildResultKey;
        if (triggerReason instanceof DependencyTriggerReason && StringUtils.isNotBlank((CharSequence)(triggeringBuildResultKey = ((DependencyTriggerReason)triggerReason).getTriggeringBuildResultKey())) && StringUtils.split((String)triggeringBuildResultKey, (String)"-").length == 3) {
            String triggeringBuildKey = triggeringBuildResultKey.substring(0, triggeringBuildResultKey.lastIndexOf("-"));
            String triggeringBuildNumber = triggeringBuildResultKey.substring(triggeringBuildResultKey.lastIndexOf("-") + 1);
            String parentBuildName = this.getBuildName(triggeringBuildKey);
            if (StringUtils.isBlank((CharSequence)parentBuildName)) {
                log.error("Received a null build parent name.");
            }
            clientConf.info.setParentBuildName(parentBuildName);
            clientConf.publisher.addMatrixParam("build.parentName", parentBuildName);
            clientConf.info.setParentBuildNumber(triggeringBuildNumber);
            clientConf.publisher.addMatrixParam("build.parentNumber", triggeringBuildNumber);
        }
    }

    private void addClientProperties(CommonTaskContext taskContext, ArtifactoryClientConfiguration clientConf, ServerConfig serverConfig, GradleBuildContext buildContext, Map<String, String> environment) {
        this.setServerConfigurations(taskContext, buildContext, serverConfig);
        clientConf.publisher.setContextUrl(this.serverUrl);
        clientConf.resolver.setContextUrl(this.serverUrl);
        clientConf.publisher.setRepoKey(this.getPublishingRepoKey(buildContext, environment));
        String resolutionRepo = this.overrideParam(buildContext.getResolutionRepo(), "artifactory.override.resolve.repo");
        if (StringUtils.isNotBlank((CharSequence)resolutionRepo) && !"noResolutionRepoKeyConfigured".equals(resolutionRepo)) {
            clientConf.resolver.setRepoKey(resolutionRepo);
        }
        clientConf.resolver.setUsername(this.resolverUsername);
        if (StringUtils.isNotBlank((CharSequence)this.deployerUsername)) {
            clientConf.publisher.setUsername(this.deployerUsername);
        }
        ProxyUtils.setProxyConfigurationToArtifactoryClientConfig(this.serverUrl, clientConf);
        boolean publishArtifacts = buildContext.isPublishArtifacts();
        clientConf.publisher.setPublishArtifacts(publishArtifacts);
        clientConf.publisher.setIncludePatterns(buildContext.getIncludePattern());
        clientConf.publisher.setExcludePatterns(buildContext.getExcludePattern());
        clientConf.publisher.setFilterExcludedArtifactsFromBuild(buildContext.isFilterExcludedArtifactsFromBuild());
        if (publishArtifacts) {
            clientConf.publisher.setPublishForkCount(buildContext.getPublishForkCount());
            boolean m2Compatible = buildContext.isMaven2Compatible();
            clientConf.publisher.setM2Compatible(m2Compatible);
            if (!m2Compatible) {
                clientConf.publisher.setIvyPattern(buildContext.getIvyPattern());
                clientConf.publisher.setIvyArtifactPattern(buildContext.getArtifactPattern());
            }
        }
        clientConf.publisher.setIvy(buildContext.isPublishIvyDescriptors());
        clientConf.publisher.setMaven(buildContext.isPublishMavenDescriptors());
        String artifactSpecs = buildContext.getArtifactSpecs();
        if (StringUtils.isNotBlank((CharSequence)artifactSpecs)) {
            clientConf.publisher.setArtifactSpecs(artifactSpecs);
        }
    }

    public void addPasswordsSystemProps(List<String> command, @NotNull TaskContext context) {
        if (this.selectedServerConfig == null) {
            return;
        }
        ArtifactoryClientConfiguration clientConf = new ArtifactoryClientConfiguration(null);
        command.add("-D" + clientConf.resolver.getPrefix() + "password=" + this.resolverPassword);
        command.add("-D" + clientConf.publisher.getPrefix() + "password=" + this.deployerPassword);
        context.getBuildContext().getVariableContext().addLocalVariable("artifactory.password.mask.a", this.resolverPassword);
        context.getBuildContext().getVariableContext().addLocalVariable("artifactory.password.mask.b", this.deployerPassword);
    }

    private void setServerConfigurations(CommonTaskContext taskContext, GradleBuildContext buildContext, ServerConfig selectedServerConfig) {
        Map runtimeContext = taskContext.getRuntimeTaskContext();
        BuildInfoLog buildInfoLog = new BuildInfoLog(log, taskContext.getBuildLogger());
        ServerConfig resolutionServerConfig = TaskUtils.getResolutionServerConfig(buildContext.getOverriddenUsername(runtimeContext, buildInfoLog, true), buildContext.getOverriddenPassword(runtimeContext, buildInfoLog, true), this.serverConfigManager, selectedServerConfig, this.buildParamsOverrideManager);
        this.serverUrl = resolutionServerConfig.getUrl();
        this.resolverUsername = resolutionServerConfig.getUsername();
        this.resolverPassword = resolutionServerConfig.getPassword();
        ServerConfig deployerServerConfig = TaskUtils.getDeploymentServerConfig(buildContext.getOverriddenUsername(runtimeContext, buildInfoLog, true), buildContext.getOverriddenPassword(runtimeContext, buildInfoLog, true), this.serverConfigManager, selectedServerConfig, this.buildParamsOverrideManager);
        this.deployerUsername = (String)StringUtils.defaultIfBlank((CharSequence)deployerServerConfig.getUsername(), (CharSequence)this.resolverUsername);
        this.deployerPassword = (String)StringUtils.defaultIfBlank((CharSequence)deployerServerConfig.getPassword(), (CharSequence)this.resolverPassword);
    }

    public ServerConfig getDeployServer() {
        if (this.serverUrl == null) {
            return null;
        }
        return new ServerConfig(this.selectedServerConfig.getId(), this.serverUrl, this.deployerUsername, this.deployerPassword, this.selectedServerConfig.getTimeout());
    }

    public ServerConfig getResolveServer() {
        if (this.serverUrl == null) {
            return null;
        }
        return new ServerConfig(this.selectedServerConfig.getId(), this.serverUrl, this.resolverUsername, this.resolverPassword, this.selectedServerConfig.getTimeout());
    }
}

