/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.builder;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.utils.EscapeChars;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.trigger.ManualBuildTriggerReason;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.admin.ServerConfigManager;
import org.jfrog.bamboo.configuration.BuildParamsOverrideManager;
import org.jfrog.bamboo.context.PackageManagersContext;
import org.jfrog.bamboo.util.BuildInfoLog;
import org.jfrog.bamboo.util.TaskUtils;
import org.jfrog.bamboo.util.Utils;
import org.jfrog.build.api.util.Log;

public abstract class BaseBuildInfoHelper {
    protected static final Logger log = LogManager.getLogger(BaseBuildInfoHelper.class);
    protected Log buildInfoLog;
    protected BuildContext context;
    protected ServerConfigManager serverConfigManager;
    protected AdministrationConfiguration administrationConfiguration;
    protected AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private HttpClient httpClient;
    protected String bambooBaseUrl;
    protected BuildParamsOverrideManager buildParamsOverrideManager;

    public void init(BuildParamsOverrideManager buildParamsOverrideManager, BuildContext context, BuildLogger logger) {
        this.buildParamsOverrideManager = buildParamsOverrideManager;
        this.context = context;
        this.buildInfoLog = new BuildInfoLog(log, logger);
        this.serverConfigManager = ServerConfigManager.getInstance();
        ContainerManager.autowireComponent((Object)this);
        this.httpClient = new HttpClient();
        this.bambooBaseUrl = this.determineBambooBaseUrl();
    }

    public void setAdministrationConfiguration(AdministrationConfiguration administrationConfiguration) {
        this.administrationConfiguration = administrationConfiguration;
    }

    public void setAdministrationConfigurationAccessor(AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }

    protected String getBuildName(String triggeringBuildKey) {
        try {
            HashMap params = Maps.newHashMap();
            params.put("buildKey", triggeringBuildKey);
            return this.getStringResource("artifactoryBuildServlet", params);
        }
        catch (IOException ioe) {
            log.error("Unable to determine triggering build name.", (Throwable)ioe);
            return null;
        }
    }

    protected String getPublishingRepoKey(PackageManagersContext buildContext, Map<String, String> environment) {
        String releaseManagementPublishRepo = environment.get("bamboo_release_management_repoKey");
        if (StringUtils.isNotBlank((String)releaseManagementPublishRepo)) {
            return releaseManagementPublishRepo;
        }
        return this.overrideParam(buildContext.getPublishingRepo(), "artifactory.override.deploy.repo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStringResource(String servletName, Map<String, String> params) throws IOException {
        String requestUrl = this.prepareRequestUrl(servletName, params);
        GetMethod getMethod = new GetMethod(requestUrl);
        try {
            this.executeMethod(requestUrl, getMethod);
            String string = getMethod.getResponseBodyAsString();
            return string;
        }
        finally {
            getMethod.releaseConnection();
        }
    }

    public Map<String, String> getBuildInfoConfigPropertiesFileParams(String propFilePath) {
        File propFile;
        HashMap variablesToReturn = Maps.newHashMap();
        if (StringUtils.isNotBlank((String)propFilePath) && (propFile = new File(propFilePath)).isFile()) {
            Properties fileProperties = new Properties();
            try (FileInputStream inputStream = new FileInputStream(propFile);){
                fileProperties.load(inputStream);
            }
            catch (IOException ioe) {
                log.error("Error occurred while trying to resolve build info properties from: " + propFilePath, (Throwable)ioe);
            }
            variablesToReturn.putAll(Utils.filterPropertiesKeysByPrefix(fileProperties, "deploy."));
            variablesToReturn.putAll(Utils.filterPropertiesKeysByPrefix(fileProperties, "buildInfo.property."));
        }
        return TaskUtils.getEscapedEnvMap(variablesToReturn);
    }

    private String prepareRequestUrl(String servletName, Map<String, String> params) {
        StringBuilder builder = new StringBuilder(this.bambooBaseUrl);
        if (!this.bambooBaseUrl.endsWith("/")) {
            builder.append("/");
        }
        StringBuilder requestUrlBuilder = builder.append("plugins/servlet/").append(servletName);
        if (params.size() != 0) {
            requestUrlBuilder.append("?");
            for (Map.Entry<String, String> param : params.entrySet()) {
                if (!requestUrlBuilder.toString().endsWith("?")) {
                    requestUrlBuilder.append("&");
                }
                requestUrlBuilder.append(param.getKey()).append("=").append(EscapeChars.forFormSubmission((String)param.getValue()));
            }
        }
        return requestUrlBuilder.toString();
    }

    private void executeMethod(String requestUrl, GetMethod getMethod) throws IOException {
        int responseCode = this.httpClient.executeMethod((HttpMethod)getMethod);
        if (responseCode == 404) {
            throw new IOException("Unable to find requested resource: " + requestUrl);
        }
        if (responseCode != 200) {
            throw new IOException("Failed to retrieve requested resource: " + requestUrl + ". Response code: " + responseCode + ", Message: " + getMethod.getStatusText());
        }
    }

    protected String determineBambooBaseUrl() {
        if (this.administrationConfiguration != null) {
            return this.administrationConfiguration.getBaseUrl();
        }
        if (this.administrationConfigurationAccessor != null) {
            return this.administrationConfigurationAccessor.getAdministrationConfiguration().getBaseUrl();
        }
        return null;
    }

    public String overrideParam(String originalValue, String overrideKey) {
        String overriddenValue = this.buildParamsOverrideManager.getOverrideValue(overrideKey);
        return overriddenValue.isEmpty() ? originalValue : overriddenValue;
    }

    protected String getTriggeringUserNameRecursively(BuildContext context) {
        BuildContext parentContext;
        String principal = null;
        TriggerReason triggerReason = context.getTriggerReason();
        if (triggerReason instanceof ManualBuildTriggerReason && StringUtils.isBlank((String)(principal = ((ManualBuildTriggerReason)triggerReason).getUserName())) && (parentContext = context.getParentBuildContext()) != null) {
            principal = this.getTriggeringUserNameRecursively(parentContext);
        }
        return principal;
    }

    protected ServerConfig getConfiguredServer(Log buildInfoLog, long selectedServerId) {
        ServerConfig serverConfig = this.serverConfigManager.getServerConfigById(selectedServerId);
        if (serverConfig == null) {
            String warning = "Found an ID of a selected Artifactory server configuration (" + selectedServerId + ") but could not find a matching configuration. Build info collection is disabled.";
            buildInfoLog.warn(warning);
            return null;
        }
        return serverConfig;
    }
}

