/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.ci;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.builder.BuildInfoBuilder;
import org.jfrog.build.api.builder.ModuleBuilder;
import org.jfrog.build.api.builder.ModuleType;
import org.jfrog.build.api.dependency.BuildDependency;
import org.jfrog.build.api.release.PromotionStatus;
import org.jfrog.build.extractor.ci.Agent;
import org.jfrog.build.extractor.ci.Artifact;
import org.jfrog.build.extractor.ci.BaseBuildBean;
import org.jfrog.build.extractor.ci.BuildAgent;
import org.jfrog.build.extractor.ci.BuildRetention;
import org.jfrog.build.extractor.ci.Dependency;
import org.jfrog.build.extractor.ci.Issues;
import org.jfrog.build.extractor.ci.MatrixParameter;
import org.jfrog.build.extractor.ci.Module;
import org.jfrog.build.extractor.ci.Vcs;

@JsonIgnoreProperties(ignoreUnknown=true, value={"project", "startedMillis"})
public class BuildInfo
extends BaseBuildBean {
    public static final String STARTED_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private String version = "1.0.1";
    private String name;
    private String number;
    private String project;
    private BuildAgent buildAgent;
    private Agent agent;
    private String started;
    private long startedMillis;
    private long durationMillis;
    private String principal;
    private String artifactoryPrincipal;
    private String artifactoryPluginVersion;
    private String url;
    private String parentName;
    private String parentNumber;
    private List<Vcs> vcs;
    @Deprecated
    private String parentBuildId;
    private BuildRetention buildRetention;
    private List<MatrixParameter> runParameters;
    private List<Module> modules;
    private List<PromotionStatus> statuses;
    private List<BuildDependency> buildDependencies;
    private Issues issues;

    public static String formatBuildStarted(long timestamp) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(STARTED_FORMAT);
        return dateFormat.format(timestamp);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getParentName() {
        return this.parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public String getParentNumber() {
        return this.parentNumber;
    }

    public void setParentNumber(String parentNumber) {
        this.parentNumber = parentNumber;
    }

    public List<Vcs> getVcs() {
        return this.vcs;
    }

    public void setVcs(List<Vcs> vcs) {
        this.vcs = vcs;
    }

    public Agent getAgent() {
        return this.agent;
    }

    public void setAgent(Agent agent) {
        this.agent = agent;
    }

    public BuildAgent getBuildAgent() {
        return this.buildAgent;
    }

    public void setBuildAgent(BuildAgent buildAgent) {
        this.buildAgent = buildAgent;
    }

    public String getStarted() {
        return this.started;
    }

    public void setStarted(String started) {
        this.started = started;
    }

    public long getStartedMillis() {
        return this.startedMillis;
    }

    public void setStartedMillis(long startedMillis) {
        this.startedMillis = startedMillis;
    }

    public void setStartedDate(Date startedDate) {
        this.startedMillis = startedDate.getTime();
        this.started = BuildInfo.formatBuildStarted(this.startedMillis);
    }

    public long getDurationMillis() {
        return this.durationMillis;
    }

    public void setDurationMillis(long durationMillis) {
        this.durationMillis = durationMillis;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public String getArtifactoryPrincipal() {
        return this.artifactoryPrincipal;
    }

    public void setArtifactoryPrincipal(String artifactoryPrincipal) {
        this.artifactoryPrincipal = artifactoryPrincipal;
    }

    public String getArtifactoryPluginVersion() {
        return this.artifactoryPluginVersion;
    }

    public void setArtifactoryPluginVersion(String artifactoryPluginVersion) {
        this.artifactoryPluginVersion = artifactoryPluginVersion;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Deprecated
    public String getParentBuildId() {
        return this.parentBuildId;
    }

    @Deprecated
    public void setParentBuildId(String parentBuildId) {
        this.parentBuildId = parentBuildId;
    }

    public List<Module> getModules() {
        return this.modules;
    }

    public void setModules(List<Module> modules) {
        this.modules = modules;
    }

    public Module getModule(String moduleId) {
        if (this.modules != null) {
            for (Module module : this.modules) {
                if (!module.getId().equals(moduleId)) continue;
                return module;
            }
        }
        return null;
    }

    public BuildRetention getBuildRetention() {
        return this.buildRetention;
    }

    public void setBuildRetention(BuildRetention buildRetention) {
        this.buildRetention = buildRetention;
    }

    public List<MatrixParameter> getRunParameters() {
        return this.runParameters;
    }

    public void setRunParameters(List<MatrixParameter> runParameters) {
        this.runParameters = runParameters;
    }

    public List<PromotionStatus> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List<PromotionStatus> statuses) {
        this.statuses = statuses;
    }

    public void addStatus(PromotionStatus promotionStatus) {
        if (this.statuses == null) {
            this.statuses = new ArrayList<PromotionStatus>();
        }
        this.statuses.add(promotionStatus);
    }

    public List<BuildDependency> getBuildDependencies() {
        return this.buildDependencies;
    }

    public void setBuildDependencies(List<BuildDependency> buildDependencies) {
        this.buildDependencies = buildDependencies;
    }

    public void addBuildDependency(BuildDependency buildDependency) {
        if (this.buildDependencies == null) {
            this.buildDependencies = new ArrayList<BuildDependency>();
        }
        this.buildDependencies.add(buildDependency);
    }

    public Issues getIssues() {
        return this.issues;
    }

    public void setIssues(Issues issues) {
        this.issues = issues;
    }

    public void append(BuildInfo other) {
        if (this.buildAgent == null) {
            this.setBuildAgent(other.buildAgent);
        }
        this.appendProperties(other);
        this.appendModules(other);
        this.appendBuildDependencies(other);
        if (this.issues == null) {
            this.issues = other.issues;
            return;
        }
        this.issues.append(other.issues);
    }

    private void appendBuildDependencies(BuildInfo other) {
        List<BuildDependency> buildDependencies = other.getBuildDependencies();
        if (buildDependencies != null && buildDependencies.size() > 0) {
            if (this.buildDependencies == null) {
                this.setBuildDependencies(buildDependencies);
            } else {
                this.buildDependencies.addAll(buildDependencies);
            }
        }
    }

    private void appendModules(BuildInfo other) {
        List<Module> modules = other.getModules();
        if (modules != null && modules.size() > 0) {
            if (this.getModules() == null) {
                this.setModules(modules);
            } else {
                modules.forEach(this::addModule);
            }
        }
    }

    private void appendProperties(BuildInfo other) {
        Properties properties = other.getProperties();
        if (properties != null && properties.size() > 0) {
            if (this.getProperties() == null) {
                this.setProperties(properties);
            } else {
                this.getProperties().putAll((Map<?, ?>)properties);
            }
        }
    }

    private void addModule(Module other) {
        List<Module> modules = this.getModules();
        Module currentModule = modules.stream().filter(module -> StringUtils.equals((CharSequence)module.getId(), (CharSequence)other.getId())).findAny().orElse(null);
        if (currentModule == null) {
            modules.add(other);
        } else {
            currentModule.append(other);
        }
    }

    public String toString() {
        return "BuildInfo{version='" + this.version + '\'' + ", name='" + this.name + '\'' + ", number='" + this.number + '\'' + ", buildAgent=" + this.buildAgent + ", agent=" + this.agent + ", started='" + this.started + '\'' + ", durationMillis=" + this.durationMillis + ", principal='" + this.principal + '\'' + ", artifactoryPrincipal='" + this.artifactoryPrincipal + '\'' + ", artifactoryPluginVersion='" + this.artifactoryPluginVersion + '\'' + ", url='" + this.url + '\'' + ", parentName='" + this.parentName + '\'' + ", parentNumber='" + this.parentNumber + '\'' + ", vcs='" + this.vcs + '\'' + ", parentBuildId='" + this.parentBuildId + '\'' + ", buildRetention=" + this.buildRetention + ", runParameters=" + this.runParameters + ", modules=" + this.modules + ", statuses=" + this.statuses + ", buildDependencies=" + this.buildDependencies + ", issues=" + this.issues + '}';
    }

    public Build ToBuild() {
        BuildInfoBuilder builder = new BuildInfoBuilder(this.name).number(this.number).project(this.project).agent(this.agent == null ? null : new org.jfrog.build.api.Agent(this.agent.getName(), this.agent.getVersion())).buildAgent(this.buildAgent == null ? null : new org.jfrog.build.api.BuildAgent(this.buildAgent.getName(), this.buildAgent.getVersion())).started(this.started).startedMillis(this.startedMillis).durationMillis(this.durationMillis).principal(this.principal).artifactoryPrincipal(this.artifactoryPrincipal).artifactoryPluginVersion(this.artifactoryPluginVersion).url(this.url).parentName(this.parentName).parentNumber(this.parentNumber).buildRunParameters(this.runParameters == null ? null : this.runParameters.stream().map(rp -> new org.jfrog.build.api.MatrixParameter(rp.getKey(), rp.getValue())).collect(Collectors.toList())).statuses(this.statuses).properties(this.getProperties()).vcs(this.vcs == null ? null : this.vcs.stream().map(Vcs::ToBuildVcs).collect(Collectors.toList())).buildRetention(this.buildRetention == null ? null : this.buildRetention.ToBuildRetention()).issues(this.issues == null ? null : this.issues.ToBuildIssues());
        if (this.modules != null) {
            builder.modules(this.modules.stream().map(m -> new ModuleBuilder().type(m.getType() == null ? null : ModuleType.valueOf(m.getType().toUpperCase())).id(m.getId()).repository(m.getRepository()).sha1(m.getSha1()).md5(m.getMd5()).artifacts(m.getArtifacts() == null ? null : m.getArtifacts().stream().map(Artifact::ToBuildArtifact).collect(Collectors.toList())).dependencies(m.getDependencies() == null ? null : m.getDependencies().stream().map(Dependency::ToBuildDependency).collect(Collectors.toList())).properties(m.getProperties()).excludedArtifacts(m.getExcludedArtifacts() == null ? null : m.getExcludedArtifacts().stream().map(Artifact::ToBuildArtifact).collect(Collectors.toList())).build()).collect(Collectors.toList()));
        }
        return builder.build();
    }

    public static BuildInfo ToBuildInfo(Build build) {
        org.jfrog.build.extractor.builder.BuildInfoBuilder builder = new org.jfrog.build.extractor.builder.BuildInfoBuilder(build.getName());
        builder.number(build.getNumber()).setProject(build.getProject()).agent(build.getAgent() == null ? null : new Agent(build.getAgent().getName(), build.getAgent().getVersion())).buildAgent(build.getBuildAgent() == null ? null : new BuildAgent(build.getBuildAgent().getName(), build.getBuildAgent().getVersion())).started(build.getStarted()).startedMillis(build.getStartedMillis()).durationMillis(build.getDurationMillis()).principal(build.getPrincipal()).artifactoryPrincipal(build.getArtifactoryPrincipal()).artifactoryPluginVersion(build.getArtifactoryPluginVersion()).url(build.getUrl()).parentName(build.getParentName()).parentNumber(build.getParentNumber()).buildRunParameters(build.getRunParameters() == null ? null : build.getRunParameters().stream().map(rp -> new MatrixParameter(rp.getKey(), rp.getValue())).collect(Collectors.toList())).statuses(build.getStatuses()).properties(build.getProperties()).vcs(build.getVcs() == null ? null : build.getVcs().stream().map(Vcs::ToBuildInfoVcs).collect(Collectors.toList())).buildRetention(build.getBuildRetention() == null ? null : BuildRetention.ToBuildInfoRetention(build.getBuildRetention())).issues(build.getIssues() == null ? null : Issues.ToBuildInfoIssues(build.getIssues()));
        if (build.getModules() != null) {
            builder.modules(build.getModules().stream().map(m -> new org.jfrog.build.extractor.builder.ModuleBuilder().type(m.getType()).id(m.getId()).repository(m.getRepository()).sha1(m.getSha1()).md5(m.getMd5()).artifacts(m.getArtifacts() == null ? null : m.getArtifacts().stream().map(Artifact::ToBuildInfoArtifact).collect(Collectors.toList())).dependencies(m.getDependencies() == null ? null : m.getDependencies().stream().map(Dependency::ToBuildDependency).collect(Collectors.toList())).properties(m.getProperties()).excludedArtifacts(m.getExcludedArtifacts() == null ? null : m.getExcludedArtifacts().stream().map(Artifact::ToBuildInfoArtifact).collect(Collectors.toList())).build()).collect(Collectors.toList()));
        }
        return builder.build();
    }
}

