/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.util.deployment;

import com.atlassian.bamboo.task.CommonTaskContext;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class LegacyDeploymentUtils {
    public static String buildDeploymentSpec(@NotNull CommonTaskContext deploymentTaskContext) {
        String repo = LegacyDeploymentUtils.getRepoKey(deploymentTaskContext);
        if (StringUtils.isBlank((String)repo)) {
            return "";
        }
        return LegacyDeploymentUtils.buildDeploymentSpec(repo);
    }

    public static String buildDeploymentSpec(String repo) {
        return "{\n  \"files\": [\n    {\n      \"pattern\": \"*\",\n      \"target\": \"" + repo + "\",\n      \"flat\": \"false\"\n    }\n  ]\n}";
    }

    private static String getRepoKey(@NotNull CommonTaskContext commonTaskContext) {
        String repositoryKey = (String)commonTaskContext.getConfigurationMap().get((Object)"artifactory.deployment.deploymentRepository");
        if (StringUtils.isBlank((String)repositoryKey)) {
            repositoryKey = (String)commonTaskContext.getConfigurationMap().get((Object)"deploymentRepository");
        }
        return repositoryKey;
    }
}

