/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class PluginProperties {
    private static final String PLUGIN_KEY = "plugin.key";
    private static final String PLUGIN_DESCRIPTOR_KEY = "plugin.descriptor.key";
    public static final String GRADLE_DEPENDENCY_FILENAME_KEY = "gradle.dependency.file.name";
    public static final String IVY_DEPENDENCY_FILENAME_KEY = "ivy.dependency.file.name";
    public static final String MAVEN3_DEPENDENCY_FILENAME_KEY = "maven3.dependency.file.name";
    private static Properties pluginProperties;

    public static String getPluginKey() {
        String pluginKey = pluginProperties.getProperty(PLUGIN_KEY);
        if (StringUtils.isBlank((String)pluginKey)) {
            throw new IllegalStateException("Could not find plugin.key property within artifactory.plugin.properties.");
        }
        return pluginKey;
    }

    public static String getPluginDescriptorKey() {
        String pluginDescriptorKey = pluginProperties.getProperty(PLUGIN_DESCRIPTOR_KEY);
        if (StringUtils.isBlank((String)pluginDescriptorKey)) {
            throw new IllegalStateException("Could not find plugin.descriptor.key property within artifactory.plugin.properties.");
        }
        return pluginDescriptorKey;
    }

    public static String getPluginProperty(String propertyName) {
        String maven3DependencyFileName = pluginProperties.getProperty(propertyName);
        if (StringUtils.isBlank((String)maven3DependencyFileName)) {
            throw new IllegalStateException("Could not find " + propertyName + " property within artifactory.plugin.properties.");
        }
        return maven3DependencyFileName;
    }

    private static Properties getPluginProperties() throws IOException {
        try (InputStream pluginPropertiesStream = PluginProperties.class.getClassLoader().getResourceAsStream("artifactory.plugin.properties");){
            if (pluginPropertiesStream == null) {
                throw new IllegalStateException("Could not find artifactory.plugin.properties resource.");
            }
            Properties pluginProperties = new Properties();
            pluginProperties.load(pluginPropertiesStream);
            Properties properties = pluginProperties;
            return properties;
        }
    }

    static {
        try {
            pluginProperties = PluginProperties.getPluginProperties();
        }
        catch (IOException e) {
            throw new RuntimeException("Error occurred while loading the plugin properties file.", e);
        }
    }
}

