/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.util;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.variable.CustomVariableContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang.StringUtils;

public class FileSpecUtils {
    public static String getFileSpec(boolean isFileSpecInJobConfiguration, String jobConfigurationSpec, String filePathSpec, File workingDirectory, CustomVariableContext customVariableContext, BuildLogger buildLogger) throws IOException {
        String fileSpec = jobConfigurationSpec;
        if (isFileSpecInJobConfiguration) {
            buildLogger.addBuildLogEntry("Using task configuration spec");
            return fileSpec;
        }
        buildLogger.addBuildLogEntry("Using spec from file located at: " + filePathSpec);
        fileSpec = FileSpecUtils.getSpecFromFile(workingDirectory, filePathSpec);
        fileSpec = customVariableContext.substituteString(fileSpec);
        return fileSpec;
    }

    public static void validateFileSpec(String fileSpec) {
        if (StringUtils.isBlank((String)fileSpec)) {
            throw new IllegalStateException("Artifactory Spec can't be empty");
        }
    }

    public static String getSpecFromFile(File sourceCodeDirectory, String specFilePath) throws IOException {
        Path path = Paths.get(specFilePath, new String[0]);
        File specFile = path.isAbsolute() ? path.toFile() : Paths.get(sourceCodeDirectory.getAbsolutePath(), specFilePath).toFile();
        try (FileInputStream fis = new FileInputStream(specFile);){
            byte[] data = new byte[(int)specFile.length()];
            fis.read(data);
            String string = new String(data, StandardCharsets.UTF_8);
            return string;
        }
    }
}

