/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.util;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ActionLog {
    private static final String errorFormat = "<p style='color:red'>%s</p>";
    private static final String messageFormat = "<p>%s</p>";
    private List<String> logEntries;
    private Logger log = LogManager.getLogger(ActionLog.class);

    public ActionLog() {
        this.logEntries = Lists.newArrayList();
    }

    public void setLogger(Logger log) {
        this.log = log;
    }

    public List<String> getLogEntries() {
        return this.logEntries;
    }

    public void logError(String message, Exception e) {
        if (e != null) {
            message = (String)message + " " + e.getMessage() + " <br>";
            this.logStackTrace(e);
        }
        this.log.error((String)message, (Throwable)e);
        this.logEntries.add(String.format(errorFormat, message));
    }

    public void logError(String message) {
        this.log.error(message);
        this.logEntries.add(String.format(errorFormat, message));
    }

    public void logMessage(String message) {
        this.log.info(message);
        this.logEntries.add(String.format(messageFormat, message));
    }

    private void logStackTrace(Exception e) {
        String stackTrace = ExceptionUtils.getStackTrace((Throwable)e);
        stackTrace = String.format(errorFormat, stackTrace);
        this.logEntries.add(stackTrace);
    }
}

