/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.task;

import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.variable.CustomVariableContext;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.admin.ServerConfigManager;
import org.jfrog.bamboo.configuration.BuildParamsOverrideManager;
import org.jfrog.bamboo.context.XrayScanContext;
import org.jfrog.bamboo.task.ArtifactoryTaskType;
import org.jfrog.bamboo.util.TaskUtils;
import org.jfrog.build.client.artifactoryXrayResponse.ArtifactoryXrayResponse;
import org.jfrog.build.client.artifactoryXrayResponse.Summary;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;

public class ArtifactoryXrayScanTask
extends ArtifactoryTaskType {
    private CustomVariableContext customVariableContext;
    private ServerConfig xrayServerConfig;
    private XrayScanContext xrayContext;

    @Override
    protected void initTask(@NotNull CommonTaskContext context) throws TaskException {
        super.initTask(context);
        this.xrayContext = new XrayScanContext((Map<String, String>)context.getConfigurationMap());
        this.setXrayServerConfigurations(this.xrayContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public TaskResult runTask(@NotNull TaskContext taskContext) {
        try {
            ArtifactoryManager client = TaskUtils.getArtifactoryManagerBuilderBuilder(this.xrayServerConfig, this.buildInfoLog).build();
            try {
                ArtifactoryXrayResponse buildScanResult = this.doXrayScan(taskContext, client);
                try {
                    String scanMessage = this.handleXrayScanResult(buildScanResult);
                    this.buildInfoLog.info(scanMessage);
                }
                catch (Exception e) {
                    this.buildInfoLog.error(e.getMessage(), e);
                    TaskResult taskResult2 = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failedWithError().build();
                    if (client == null) return taskResult2;
                    client.close();
                    return taskResult2;
                }
                TaskResult taskResult = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).success().build();
                return taskResult;
            }
            finally {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable;
                        throwable.addSuppressed(throwable2);
                    }
                }
            }
        }
        catch (Exception e) {
            this.buildInfoLog.error("Exception occurred while executing task", e);
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failedWithError().build();
        }
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }

    @Override
    protected ServerConfig getUsageServerConfig() {
        return this.xrayServerConfig;
    }

    @Override
    protected String getTaskUsageName() {
        return "xray_scan";
    }

    private String handleXrayScanResult(ArtifactoryXrayResponse buildScanResult) throws IOException {
        Summary summary = this.getSummaryFromResponse(buildScanResult);
        if (StringUtils.isNotEmpty((String)summary.getMoreDetailsUrl())) {
            this.logger.addBuildLogEntry("Xray scan details are available at: " + summary.getMoreDetailsUrl());
        }
        String scanMessage = summary.getMessage();
        boolean isVulnerable = summary.isFailBuild();
        if (isVulnerable && this.xrayContext.isFailIfVulnerable()) {
            throw new IOException(scanMessage);
        }
        return scanMessage;
    }

    private Summary getSummaryFromResponse(ArtifactoryXrayResponse buildScanResult) {
        Summary summary = buildScanResult.getSummary();
        if (summary == null) {
            throw new IllegalStateException("Failed while processing the JSON result: 'summary' field is missing.");
        }
        return summary;
    }

    private void setXrayServerConfigurations(XrayScanContext xrayContext) {
        ServerConfigManager serverConfigManager = ServerConfigManager.getInstance();
        this.xrayServerConfig = serverConfigManager.getServerConfigById(xrayContext.getArtifactoryServerId());
        if (this.xrayServerConfig == null) {
            throw new IllegalArgumentException("Could not find Artifactory server. Please check the Artifactory server in the task configuration.");
        }
        Map runtimeContext = this.taskContext.getRuntimeTaskContext();
        this.xrayServerConfig = TaskUtils.getResolutionServerConfig(xrayContext.getOverriddenUsername(runtimeContext, this.buildInfoLog, true), xrayContext.getOverriddenPassword(runtimeContext, this.buildInfoLog, true), serverConfigManager, this.xrayServerConfig, new BuildParamsOverrideManager(this.customVariableContext));
    }

    private ArtifactoryXrayResponse doXrayScan(TaskContext taskContext, ArtifactoryManager client) throws IOException {
        String buildName = this.xrayContext.getBuildName(taskContext.getBuildContext());
        String buildNumber = this.xrayContext.getBuildNumber(taskContext.getBuildContext());
        return client.scanBuild(buildName, buildNumber, "", "bamboo");
    }
}

