/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.task;

import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskType;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.task.ArtifactoryTaskBase;
import org.jfrog.bamboo.util.TaskUtils;
import org.jfrog.bamboo.util.generic.GenericData;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.ci.BuildInfo;

public abstract class ArtifactoryTaskType
extends ArtifactoryTaskBase
implements TaskType {
    protected BuildInfo taskBuildInfo;

    protected abstract TaskResult runTask(@NotNull TaskContext var1) throws TaskException;

    @NotNull
    public TaskResult execute(@NotNull TaskContext context) throws TaskException {
        String buildInfoFromContext = "";
        if (this.shouldRemoveBuildInfoFromContext()) {
            buildInfoFromContext = TaskUtils.getAndDeleteAggregatedBuildInfo(context);
        }
        this.initTask((CommonTaskContext)context);
        ServerConfig server = this.getUsageServerConfig();
        if (server != null) {
            this.reportUsage(server, this.getTaskUsageName(), this.buildInfoLog);
        }
        TaskResult taskResult = this.runTask(context);
        if (StringUtils.isNotBlank((CharSequence)buildInfoFromContext) || this.taskBuildInfo != null) {
            this.aggregateBuildInfoAndAddToPlanContext(buildInfoFromContext, context);
        }
        return taskResult;
    }

    private void aggregateBuildInfoAndAddToPlanContext(String buildInfoFromContext, TaskContext context) throws TaskException {
        GenericData gd = new GenericData();
        try {
            if (StringUtils.isNotBlank((CharSequence)buildInfoFromContext)) {
                gd = BuildInfoExtractorUtils.jsonStringToGeneric(buildInfoFromContext, GenericData.class);
            }
            if (this.taskBuildInfo != null) {
                gd.addBuild(this.taskBuildInfo);
            }
            String aggregatedBuildInfo = BuildInfoExtractorUtils.buildInfoToJsonString(gd);
            TaskUtils.addBuildInfoToContext(context, aggregatedBuildInfo);
        }
        catch (IOException ex) {
            throw new TaskException("Failed to add Build Info to context.", (Throwable)ex);
        }
    }

    protected boolean shouldRemoveBuildInfoFromContext() {
        return true;
    }
}

