/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.task;

import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.collect.Lists;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.builder.BuildInfoHelper;
import org.jfrog.bamboo.configuration.BuildParamsOverrideManager;
import org.jfrog.bamboo.context.DotNetBuildContext;
import org.jfrog.bamboo.task.ArtifactoryTaskType;
import org.jfrog.bamboo.util.BuildInfoLog;
import org.jfrog.bamboo.util.TaskUtils;
import org.jfrog.build.extractor.ci.Artifact;
import org.jfrog.build.extractor.ci.BuildInfo;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryManagerBuilder;
import org.jfrog.build.extractor.clientConfiguration.util.spec.SpecsHelper;
import org.jfrog.build.extractor.nuget.extractor.NugetRun;

public abstract class ArtifactoryDotNetTaskBase
extends ArtifactoryTaskType {
    protected final EnvironmentVariableAccessor environmentVariableAccessor;
    protected final CapabilityContext capabilityContext;
    protected CustomVariableContext customVariableContext;
    protected DotNetBuildContext dotNetBuildContext;
    protected BuildInfoHelper buildInfoHelper;
    protected BuildParamsOverrideManager buildParamsOverrideManager;
    protected Map<String, String> environmentVariables;
    protected Path workingDir;
    protected String buildName;
    protected String buildNumber;
    protected TaskType taskType;
    protected String specTemplate = "{\n  \"files\": [\n    {\n      \"pattern\": \"%s\",\n      \"target\": \"%s\"\n    }\n  ]\n}";

    protected void initTask(CommonTaskContext context, String taskKey, String executable, String taskName, TaskType taskType) throws TaskException {
        super.initTask(context);
        this.taskType = taskType;
        this.dotNetBuildContext = new DotNetBuildContext((Map<String, String>)this.taskContext.getConfigurationMap());
        this.buildParamsOverrideManager = new BuildParamsOverrideManager(this.customVariableContext);
        BuildContext buildContext = ((TaskContext)context).getBuildContext();
        this.buildName = this.dotNetBuildContext.getBuildName(buildContext);
        this.buildNumber = this.dotNetBuildContext.getBuildNumber(buildContext);
        this.initBuildInfoHelper(buildContext);
        this.environmentVariables = this.getEnv(taskKey, executable, taskName);
        this.workingDir = this.getWorkPath();
    }

    @Override
    @NotNull
    public TaskResult runTask(@NotNull TaskContext taskContext) {
        BuildInfo build;
        if (this.dotNetBuildContext.isRestoreCommand()) {
            build = this.executeRestore();
        } else {
            try {
                build = this.executePush();
            }
            catch (Exception e) {
                this.buildInfoLog.error("Exception occurred while executing task", e);
                return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failedWithError().build();
            }
        }
        if (build == null) {
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failedWithError().build();
        }
        if (this.dotNetBuildContext.isCaptureBuildInfo()) {
            build.setName(this.buildName);
            build.setNumber(this.buildNumber);
            this.buildInfoHelper.addEnvVarsToBuild(this.dotNetBuildContext, build);
            this.taskBuildInfo = build;
        }
        return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).success().build();
    }

    protected ArtifactoryDotNetTaskBase(EnvironmentVariableAccessor environmentVariableAccessor, CapabilityContext capabilityContext) {
        this.environmentVariableAccessor = environmentVariableAccessor;
        this.capabilityContext = capabilityContext;
        ContainerManager.autowireComponent((Object)this);
    }

    protected BuildInfo executeRestore() {
        ArtifactoryManagerBuilder artifactoryManagerBuilder = TaskUtils.getArtifactoryManagerBuilderBuilder(this.buildInfoHelper.getServerConfig(), new BuildInfoLog(log, this.logger));
        String repo = this.buildInfoHelper.overrideParam(this.dotNetBuildContext.getResolutionRepo(), "artifactory.override.resolve.repo");
        return new NugetRun(artifactoryManagerBuilder, repo, this.taskType == TaskType.DOTNET, String.format("restore %s", this.dotNetBuildContext.getArguments()), this.buildInfoLog, this.workingDir, this.environmentVariables, null, this.buildInfoHelper.getServerConfig().getUsername(), this.buildInfoHelper.getServerConfig().getPassword(), "v2").execute();
    }

    protected BuildInfo executePush() throws Exception {
        String repo = this.buildInfoHelper.overrideParam(this.dotNetBuildContext.getPublishingRepo(), "artifactory.override.deploy.repo");
        String artifactsPattern = this.dotNetBuildContext.getPushPattern();
        String targetPath = this.createTargetPath(repo, this.dotNetBuildContext.getPushTarget());
        String uploadSpec = String.format(this.specTemplate, artifactsPattern, targetPath);
        BuildInfo build = this.buildInfoHelper.getBuilder((TaskContext)this.taskContext).build();
        Map<String, String> buildProperties = this.buildInfoHelper.getDynamicPropertyMap(build);
        this.buildInfoHelper.addCommonProperties(buildProperties);
        SpecsHelper specsHelper = new SpecsHelper(new BuildInfoLog(log, this.logger));
        ArtifactoryManagerBuilder artifactoryManagerBuilder = this.buildInfoHelper.getClientBuilder(this.taskContext.getBuildLogger(), log);
        List<Artifact> artifactList = specsHelper.uploadArtifactsBySpec(uploadSpec, this.workingDir.toFile(), buildProperties, artifactoryManagerBuilder);
        return this.buildInfoHelper.addBuildInfoParams(build, artifactList, Lists.newArrayList(), Lists.newArrayList());
    }

    private String createTargetPath(String repo, String relativePath) {
        Object targetPath = StringUtils.appendIfMissing((String)repo, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        if (StringUtils.isNotBlank((CharSequence)relativePath)) {
            relativePath = StringUtils.removeStart((String)relativePath, (String)"/");
            targetPath = (String)targetPath + StringUtils.appendIfMissing((String)relativePath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        }
        return targetPath;
    }

    protected Map<String, String> getEnv(String taskKey, String executable, String taskName) throws TaskException {
        Map<String, String> env = TaskUtils.getEnvironmentVariables(this.dotNetBuildContext, this.environmentVariableAccessor);
        return TaskUtils.addExecutablePathToEnv(env, this.dotNetBuildContext, this.capabilityContext, taskKey, executable, taskName, this.containerized);
    }

    protected Path getWorkPath() {
        File rootDir = this.taskContext.getRootDirectory();
        String subDirectory = this.dotNetBuildContext.getWorkingSubdirectory();
        if (StringUtils.isNotBlank((CharSequence)subDirectory)) {
            return new File(rootDir, subDirectory).toPath();
        }
        return rootDir.toPath();
    }

    protected void initBuildInfoHelper(BuildContext buildContext) {
        Map runtimeContext = this.taskContext.getRuntimeTaskContext();
        this.buildInfoHelper = this.dotNetBuildContext.isRestoreCommand() ? BuildInfoHelper.createResolveBuildInfoHelper(this.buildName, this.buildNumber, this.taskContext, buildContext, this.environmentVariableAccessor, this.dotNetBuildContext.getResolutionArtifactoryServerId(), this.dotNetBuildContext.getOverriddenUsername(runtimeContext, this.buildInfoLog, false), this.dotNetBuildContext.getOverriddenPassword(runtimeContext, this.buildInfoLog, false), this.buildParamsOverrideManager) : BuildInfoHelper.createDeployBuildInfoHelper(this.buildName, this.buildNumber, this.taskContext, buildContext, this.environmentVariableAccessor, this.dotNetBuildContext.getArtifactoryServerId(), this.dotNetBuildContext.getOverriddenUsername(runtimeContext, this.buildInfoLog, true), this.dotNetBuildContext.getOverriddenPassword(runtimeContext, this.buildInfoLog, true), this.buildParamsOverrideManager);
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }

    @Override
    protected ServerConfig getUsageServerConfig() {
        return this.buildInfoHelper.getServerConfig();
    }

    protected static enum TaskType {
        NUGET,
        DOTNET;

    }
}

