/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.security.provider;

import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.serialization.WhitelistedSerializable;
import com.atlassian.bamboo.task.RuntimeTaskDataProvider;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinition;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class SharedCredentialsDataProvider
implements RuntimeTaskDataProvider {
    public static final String RESOLVER_SHARED_CREDENTIALS_USER = "resolverSharedCredentialsUser";
    public static final String RESOLVER_SHARED_CREDENTIALS_PASSWORD = "resolverSharedCredentialsPassword";
    public static final String DEPLOYER_SHARED_CREDENTIALS_USER = "deployerSharedCredentialsUser";
    public static final String DEPLOYER_SHARED_CREDENTIALS_PASSWORD = "deployerSharedCredentialsPassword";
    private CredentialsAccessor credentialsAccessor;

    @NotNull
    public Map<String, String> populateRuntimeTaskData(@NotNull TaskDefinition taskDefinition, @NotNull CommonContext commonContext) {
        HashMap result = Maps.newHashMap();
        this.populateSharedCredentials(taskDefinition, result, "resolver.sharedCredentials", RESOLVER_SHARED_CREDENTIALS_USER, RESOLVER_SHARED_CREDENTIALS_PASSWORD);
        this.populateSharedCredentials(taskDefinition, result, "deployer.sharedCredentials", DEPLOYER_SHARED_CREDENTIALS_USER, DEPLOYER_SHARED_CREDENTIALS_PASSWORD);
        return result;
    }

    private void populateSharedCredentials(TaskDefinition taskDefinition, Map<String, String> result, String type, String credUser, String credPassword) {
        String credentialsName = (String)taskDefinition.getConfiguration().get(type);
        if (StringUtils.isBlank((CharSequence)credentialsName)) {
            return;
        }
        CredentialsData credentialsData = this.credentialsAccessor.getCredentialsByName(credentialsName);
        if (credentialsData == null) {
            return;
        }
        Map credentialsConfiguration = credentialsData.getConfiguration();
        String username = (String)credentialsConfiguration.get("username");
        String password = (String)credentialsConfiguration.get("password");
        if (username == null || password == null) {
            return;
        }
        result.put(credUser, username);
        result.put(credPassword, password);
        taskDefinition.getConfiguration().put(credUser, username);
        taskDefinition.getConfiguration().put(credPassword, password);
    }

    @NotNull
    public Map<String, WhitelistedSerializable> createRuntimeTaskData(@NotNull RuntimeTaskDefinition runtimeTaskDefinition, @NotNull CommonContext commonContext) {
        return new HashMap<String, WhitelistedSerializable>();
    }

    public void processRuntimeTaskData(@NotNull RuntimeTaskDefinition runtimeTaskDefinition, @NotNull CommonContext commonContext) {
    }

    public void setCredentialsAccessor(CredentialsAccessor credentialsAccessor) {
        this.credentialsAccessor = credentialsAccessor;
    }
}

