/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.security;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import javax.annotation.concurrent.ThreadSafe;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ThreadSafe
public class EncryptionHelper {
    private static final Logger log = LogManager.getLogger(EncryptionHelper.class);
    private static final String DESEDE_ENCRYPTION_SCHEME = "DESede";
    private static final String KEY_CHARSET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final int KEY_LENGTH = 24;
    private static final String uiKey = EncryptionHelper.generateRandomKey();
    private static final String dbKey = "Beetlejuice version $version (c) Copyright 2003-2005 Pols Consulting Limited";
    private static ThreadLocal<Cipher> threadLocalEncrypter = new ThreadLocal<Cipher>(){

        @Override
        protected Cipher initialValue() {
            try {
                return Cipher.getInstance(EncryptionHelper.DESEDE_ENCRYPTION_SCHEME);
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
                log.error("Cannot create encrypter", (Throwable)e);
                return null;
            }
        }
    };
    private static ThreadLocal<Cipher> threadLocalDecrypter = new ThreadLocal<Cipher>(){

        @Override
        protected Cipher initialValue() {
            try {
                return Cipher.getInstance(EncryptionHelper.DESEDE_ENCRYPTION_SCHEME);
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
                log.error("Cannot create decrypter", (Throwable)e);
                return null;
            }
        }
    };

    @NotNull
    public static String encryptForConfig(@Nullable String stringToEncrypt) {
        if (StringUtils.isEmpty((CharSequence)stringToEncrypt)) {
            return "";
        }
        try {
            byte[] encrypted = EncryptionHelper.getEncrypter(dbKey).doFinal(stringToEncrypt.getBytes(StandardCharsets.UTF_8));
            return Base64.getMimeEncoder().encodeToString(encrypted);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to encrypt.", e);
        }
    }

    @NotNull
    public static String encryptForUi(@Nullable String stringToEncrypt) {
        if (StringUtils.isEmpty((CharSequence)stringToEncrypt)) {
            return "";
        }
        try {
            byte[] encrypted = EncryptionHelper.getEncrypter(uiKey).doFinal(stringToEncrypt.getBytes(StandardCharsets.UTF_8));
            return new Base32().encodeAsString(encrypted);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to encrypt.", e);
        }
    }

    @NotNull
    public static String decrypt(@Nullable String data) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            return "";
        }
        try {
            byte[] encrypted = Base64.getMimeDecoder().decode(data);
            return EncryptionHelper.decryptWithKey(dbKey, encrypted);
        }
        catch (Exception e) {
            try {
                byte[] encrypted = new Base32().decode(data);
                return EncryptionHelper.decryptWithKey(uiKey, encrypted);
            }
            catch (Exception ee) {
                throw new RuntimeException("Failed to decrypt.", ee);
            }
        }
    }

    public static String decryptIfNeeded(String s) {
        try {
            s = EncryptionHelper.decrypt(s);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return s;
    }

    private static String decryptWithKey(String key, byte[] encrypted) throws InvalidKeySpecException, InvalidKeyException, NoSuchAlgorithmException, BadPaddingException, IllegalBlockSizeException {
        return new String(EncryptionHelper.getDecrypter(key).doFinal(encrypted), StandardCharsets.UTF_8);
    }

    private static String generateRandomKey() {
        SecureRandom rnd = new SecureRandom();
        StringBuilder sb = new StringBuilder(24);
        for (int i = 0; i < 24; ++i) {
            sb.append(KEY_CHARSET.charAt(rnd.nextInt(KEY_CHARSET.length())));
        }
        return sb.toString();
    }

    private static SecretKey generateSecret(String key) throws InvalidKeySpecException, InvalidKeyException, NoSuchAlgorithmException {
        DESedeKeySpec myKeySpec = new DESedeKeySpec(key.getBytes(StandardCharsets.UTF_8));
        SecretKeyFactory myKeyFactory = SecretKeyFactory.getInstance(DESEDE_ENCRYPTION_SCHEME);
        return myKeyFactory.generateSecret(myKeySpec);
    }

    private static Cipher getDecrypter(String key) throws InvalidKeySpecException, InvalidKeyException, NoSuchAlgorithmException {
        SecretKey secretKey = EncryptionHelper.generateSecret(key);
        Cipher decrypter = threadLocalDecrypter.get();
        decrypter.init(2, secretKey);
        return decrypter;
    }

    private static Cipher getEncrypter(String key) throws InvalidKeySpecException, InvalidKeyException, NoSuchAlgorithmException {
        SecretKey secretKey = EncryptionHelper.generateSecret(key);
        Cipher encrypter = threadLocalEncrypter.get();
        encrypter.init(1, secretKey);
        return encrypter;
    }
}

