/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.release.vcs.git;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.Transport;

public class SshPushCommand
extends PushCommand {
    private final Transport transport;
    private List<RefSpec> refSpecs;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;

    protected SshPushCommand(Repository repo, Transport transport) {
        super(repo);
        this.transport = transport;
        this.refSpecs = Lists.newArrayListWithCapacity((int)3);
    }

    @Override
    public Iterable<PushResult> call() throws JGitInternalException, InvalidRemoteException {
        this.checkCallable();
        ArrayList pushResults = Lists.newArrayListWithCapacity((int)3);
        try {
            if (this.isForce()) {
                ArrayList<RefSpec> orig = new ArrayList<RefSpec>(this.refSpecs);
                this.refSpecs.clear();
                for (RefSpec spec : orig) {
                    this.refSpecs.add(spec.setForceUpdate(true));
                }
            }
            RemoteConfig cfg = new RemoteConfig(this.repo.getConfig(), this.getRemote());
            this.transport.applyConfig(cfg);
            if (0 <= this.getTimeout()) {
                this.transport.setTimeout(this.getTimeout());
            }
            this.transport.setPushThin(this.isThin());
            if (this.getReceivePack() != null) {
                this.transport.setOptionReceivePack(this.getReceivePack());
            }
            this.transport.setDryRun(this.isDryRun());
            Collection<RemoteRefUpdate> toPush = this.transport.findRemoteRefUpdatesFor(this.getRefSpecs());
            this.transport.push(this.monitor, toPush);
            try {
                PushResult result = this.transport.push(this.monitor, toPush);
                pushResults.add(result);
            }
            catch (TransportException e) {
                throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfPushCommand, e);
            }
            finally {
                this.transport.close();
            }
        }
        catch (URISyntaxException e) {
            throw new InvalidRemoteException(MessageFormat.format(JGitText.get().invalidRemote, this.getRemote()));
        }
        catch (NotSupportedException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfPushCommand, e);
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfPushCommand, e);
        }
        return pushResults;
    }
}

