/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.release.vcs;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jfrog.bamboo.release.vcs.VcsCoordinator;
import org.jfrog.bamboo.release.vcs.VcsTypes;
import org.jfrog.bamboo.release.vcs.git.GitCoordinator;
import org.jfrog.bamboo.release.vcs.perforce.PerforceCoordinator;

public abstract class AbstractVcsCoordinator
implements VcsCoordinator {
    private static final Logger log = LogManager.getLogger(AbstractVcsCoordinator.class);
    protected final BuildLogger buildLogger;
    protected final CustomVariableContext customVariableContext;
    protected final CredentialsAccessor credentialsAccessor;
    protected BuildContext context;
    protected boolean modifiedFilesForDevVersion;
    protected boolean modifiedFilesForReleaseVersion;

    public AbstractVcsCoordinator(BuildContext context, BuildLogger buildLogger, CustomVariableContext customVariableContext, CredentialsAccessor credentialsAccessor) {
        this.context = context;
        this.buildLogger = buildLogger;
        this.customVariableContext = customVariableContext;
        this.credentialsAccessor = credentialsAccessor;
    }

    public static VcsCoordinator createVcsCoordinator(BuildContext context, Map<? extends String, ? extends String> configuration, BuildLogger buildLogger, CustomVariableContext customVariableContext, CredentialsAccessor credentialsAccessor) {
        HashMap combined = Maps.newHashMap();
        combined.putAll(configuration);
        Map customBuildData = context.getBuildResult().getCustomBuildData();
        combined.putAll(customBuildData);
        if (VcsTypes.GIT.name().equals(configuration.get("artifactory.vcs.type"))) {
            return new GitCoordinator(context, combined, buildLogger, customVariableContext, credentialsAccessor);
        }
        if (VcsTypes.PERFORCE.name().equals(configuration.get("artifactory.vcs.type"))) {
            return new PerforceCoordinator(context, combined, buildLogger, customVariableContext, credentialsAccessor);
        }
        throw new UnsupportedOperationException("This VCS type is not supported");
    }

    @Override
    public void beforeDevelopmentVersionChange() throws IOException {
    }

    @Override
    public void afterDevelopmentVersionChange(boolean modified) throws IOException, InterruptedException {
        this.modifiedFilesForDevVersion = modified;
    }

    @Override
    public String getCheckoutBranch() {
        return "";
    }

    @Override
    public void setCheckoutBranch(String checkoutBranch) {
    }

    @Override
    public String getCurrentWorkingBranch() {
        return "";
    }

    @Override
    public void setCurrentWorkingBranch(String currentWorkingBranch) {
    }

    @Override
    public String getCommitIsh() {
        return "";
    }

    @Override
    public void setCommitIsh(String commitIsh) {
    }

    @Override
    public boolean isReleaseBranchCreated() {
        return false;
    }

    @Override
    public void setReleaseBranchCreated(boolean releaseBranchCreated) {
    }

    @Override
    public void afterReleaseVersionChange(boolean modified) throws IOException {
        this.modifiedFilesForReleaseVersion = modified;
    }

    protected void log(String message) {
        log.info(this.buildLogger.addBuildLogEntry("[RELEASE] " + message));
    }

    @Override
    public void edit(File file) throws IOException, InterruptedException {
    }

    @Override
    public int getCurrentChangeListId() {
        return 0;
    }

    @Override
    public void setCurrentChangeListId(int currentChangeListId) {
    }
}

