/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.release.action.condition;

import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.branch.ChainBranch;
import com.atlassian.bamboo.plugins.web.conditions.AbstractPlanPermissionCondition;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.task.TaskDefinition;
import java.util.List;
import java.util.Map;
import org.acegisecurity.acls.Permission;
import org.jfrog.bamboo.context.PackageManagersContext;

public class ReleasePromotionActionCondition
extends AbstractPlanPermissionCondition {
    private PlanManager planManager;

    public boolean shouldDisplay(Map<String, Object> context) {
        String planKeyStr = (String)context.get("planKey");
        if (planKeyStr == null) {
            return false;
        }
        PlanKey planKey = PlanKeys.getPlanKey((String)planKeyStr);
        if (!this.bambooPermissionManager.hasPlanPermission((Permission)BambooPermission.BUILD, planKey)) {
            return false;
        }
        Plan plan = this.planManager.getPlanByKey(planKey);
        if (plan == null && (plan = this.extractMasterPlanFromBranchPlan(planKey)) == null) {
            return false;
        }
        List taskDefs = plan.getBuildDefinition().getTaskDefinitions();
        for (TaskDefinition taskDef : taskDefs) {
            PackageManagersContext buildContext;
            if (!taskDef.isEnabled() || (buildContext = PackageManagersContext.createContextFromMap(taskDef.getConfiguration())) == null || !buildContext.releaseManagementContext.isReleaseMgmtEnabled()) continue;
            return true;
        }
        return false;
    }

    private Plan extractMasterPlanFromBranchPlan(PlanKey planKey) {
        PlanKey chainKey = PlanKeys.getChainKeyIfJobKey((PlanKey)planKey);
        if (chainKey == null) {
            return null;
        }
        Plan chainKeyPlan = this.planManager.getPlanByKey(chainKey);
        if (!(chainKeyPlan instanceof ChainBranch)) {
            return null;
        }
        Plan master = (Plan)chainKeyPlan.getMaster();
        if (master == null) {
            return null;
        }
        PlanKey masterJobKey = PlanKeys.getJobKey((PlanKey)master.getPlanKey(), (String)PlanKeys.getPartialJobKey((PlanKey)planKey));
        return this.planManager.getPlanByKey(masterJobKey);
    }

    public void setPlanManager(PlanManager planManager) {
        this.planManager = planManager;
    }
}

