/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.context;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.bamboo.context.PackageManagersContext;

public class GradleBuildContext
extends PackageManagersContext {
    public static final String PREFIX = "builder.artifactoryGradleBuilder.";
    public static final String SWITCHES_PARAM = "switches";
    public static final String TASKS_PARAM = "tasks";
    public static final String BUILD_SCRIPT_PARAM = "buildScript";
    public static final String BUILD_FILE_PARAM = "buildFile";
    public static final String USE_GRADLE_WRAPPER_PARAM = "useGradleWrapper";
    public static final String GRADLE_WRAPPER_LOCATION_PARAM = "gradleWrapperLocation";
    public static final String PUBLISH_FORK_COUNT_PARAM = "publishForkCount";
    private static final List<Integer> PUBLISH_FORK_COUNT_OPTIONS = ImmutableList.of((Object)1, (Object)2, (Object)4, (Object)8);

    public GradleBuildContext(Map<String, String> env) {
        super(PREFIX, env);
    }

    @Override
    public String getResolverUsername() {
        return (String)this.env.get("builder.artifactoryGradleBuilder.deployerUsername");
    }

    @Override
    public String getResolverPassword() {
        return (String)this.env.get("builder.artifactoryGradleBuilder.deployerPassword");
    }

    public String getSwitches() {
        return (String)this.env.get("builder.artifactoryGradleBuilder.switches");
    }

    public String getTasks() {
        return (String)this.env.get("builder.artifactoryGradleBuilder.tasks");
    }

    public String getBuildScript() {
        return (String)this.env.get("builder.artifactoryGradleBuilder.buildScript");
    }

    public String getBuildFile() {
        return (String)this.env.get("builder.artifactoryGradleBuilder.buildFile");
    }

    public String getReleaseProps() {
        return (String)this.env.get("builder.artifactoryGradleBuilder.releaseProps");
    }

    public String getNextIntegProps() {
        return (String)this.env.get("builder.artifactoryGradleBuilder.nextIntegProps");
    }

    @Override
    public String getArtifactSpecs() {
        return (String)this.env.get("builder.artifactoryGradleBuilder.artifactSpecs");
    }

    public boolean isUseGradleWrapper() {
        return Boolean.parseBoolean((String)this.env.get("builder.artifactoryGradleBuilder.useGradleWrapper"));
    }

    public String getGradleWrapperLocation() {
        return (String)this.env.get("builder.artifactoryGradleBuilder.gradleWrapperLocation");
    }

    public int getPublishForkCount() {
        String forkCount = (String)this.env.get("builder.artifactoryGradleBuilder.publishForkCount");
        return Integer.parseInt(StringUtils.isNotBlank((CharSequence)forkCount) ? forkCount : GradleBuildContext.getDefaultPublishForkCount());
    }

    public static GradleBuildContext createGradleContextFromMap(Map<String, Object> map) {
        Map transformed = Maps.transformValues(map, (Function)new Function<Object, String>(){

            public String apply(Object input) {
                if (input == null) {
                    return "";
                }
                return input.toString();
            }
        });
        return new GradleBuildContext(transformed);
    }

    public static Set<String> getFieldsToCopy() {
        HashSet fieldsToCopy = Sets.newHashSet((Object[])new String[]{"builder.artifactoryGradleBuilder.switches", "builder.artifactoryGradleBuilder.tasks", "builder.artifactoryGradleBuilder.buildScript", "builder.artifactoryGradleBuilder.buildFile", "builder.artifactoryGradleBuilder.useGradleWrapper", "builder.artifactoryGradleBuilder.gradleWrapperLocation", "builder.artifactoryGradleBuilder.artifactoryServerId", "builder.artifactoryGradleBuilder.resolutionRepo", "builder.artifactoryGradleBuilder.publishingRepo", "builder.artifactoryGradleBuilder.deployerUsername", "builder.artifactoryGradleBuilder.deployerPassword", "builder.artifactoryGradleBuilder.useArtifactoryGradlePlugin", "publishBuildInfo", "includeEnvVars", "envVarsExcludePatterns", "envVarsIncludePatterns", "publishArtifacts", "builder.artifactoryGradleBuilder.publishForkCount", "builder.artifactoryGradleBuilder.publishMavenDescriptors", "builder.artifactoryGradleBuilder.publishIvyDescriptors", "useM2CompatiblePatterns", "builder.artifactoryGradleBuilder.ivyPattern", "builder.artifactoryGradleBuilder.buildJdk", "builder.artifactoryGradleBuilder.artifactPattern", "builder.artifactoryGradleBuilder.publishIncludePatterns", "builder.artifactoryGradleBuilder.publishExcludePatterns", "builder.artifactoryGradleBuilder.filterExcludedArtifactsFromBuild", "builder.artifactoryGradleBuilder.environmentVariables", "builder.artifactoryGradleBuilder.artifactSpecs", "builder.artifactoryGradleBuilder.executable", "testChecked", "builder.artifactoryGradleBuilder.testResultsDirectory", "buildInfoAggregation", "captureBuildInfo", "testDirectoryOption", "enableReleaseManagement", "builder.artifactoryGradleBuilder.vcsTagBase", "builder.artifactoryGradleBuilder.gitReleaseBranch", "builder.artifactoryGradleBuilder.alternativeTasks", "builder.artifactoryGradleBuilder.releaseProps", "builder.artifactoryGradleBuilder.nextIntegProps", "artifactory.task.buildName", "artifactory.task.buildNumber", "resolver.overrideCredentialsChoice", "resolver.sharedCredentials", "deployer.overrideCredentialsChoice", "deployer.sharedCredentials"});
        fieldsToCopy.addAll(GradleBuildContext.getVcsFieldsToCopy());
        return fieldsToCopy;
    }

    public static List<String> getPublishForkCountList() {
        return PUBLISH_FORK_COUNT_OPTIONS.stream().map(String::valueOf).collect(Collectors.toList());
    }

    public static String getDefaultPublishForkCount() {
        return String.valueOf(PUBLISH_FORK_COUNT_OPTIONS.stream().mapToInt(v -> v).max().orElseThrow(NoSuchElementException::new));
    }
}

