/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.google.common.collect.Lists;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jfrog.bamboo.configuration.AbstractArtifactoryConfiguration;
import org.jfrog.bamboo.configuration.util.TaskConfigurationValidations;
import org.jfrog.bamboo.context.GradleBuildContext;

public class ArtifactoryGradleConfiguration
extends AbstractArtifactoryConfiguration {
    public static final String KEY = "artifactoryGradleBuilder";
    protected static final String DEFAULT_TEST_REPORTS_XML = "**/build/test-results/*.xml";
    private static final Set<String> FIELDS_TO_COPY = GradleBuildContext.getFieldsToCopy();
    private static final String PUBLISH_FORK_COUNT_OPTIONS_KEY = "publishForkCountList";
    private static final String PUBLISH_FORK_COUNT_KEY = "publishForkCount";

    public ArtifactoryGradleConfiguration() {
        super("builder.artifactoryGradleBuilder.", "system.builder.gradle");
    }

    @Override
    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        this.populateLegacyContextForCreate(context);
        context.put("artifactoryGradleTask", (Object)this);
        context.put("builderType", (Object)this);
        context.put("builder", (Object)this);
        context.put("adminConfig", this.administrationConfiguration);
        context.put("baseUrl", this.administrationConfiguration.getBaseUrl());
        Plan plan = (Plan)context.get("plan");
        context.put("build", plan);
        context.put("dummyList", Lists.newArrayList());
        context.put("serverConfigManager", this.serverConfigManager);
        context.put("selectedServerId", -1);
        context.put("selectedResolutionRepoKey", "");
        context.put("selectedPublishingRepoKey", "");
        context.put("builder.artifactoryGradleBuilder.gitReleaseBranch", "REL-BRANCH-");
        context.put("artifactory.vcs.git.vcs.type.list", this.getVcsTypes());
        context.put("artifactory.vcs.git.authenticationType.list", this.getGitAuthenticationTypes());
        context.put("builder.artifactoryGradleBuilder.publishForkCountList", GradleBuildContext.getPublishForkCountList());
        context.put("builder.artifactoryGradleBuilder.publishForkCount", GradleBuildContext.getDefaultPublishForkCount());
    }

    @Override
    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.populateLegacyContextForEdit(context, taskDefinition);
        this.populateContextWithConfiguration(context, taskDefinition, FIELDS_TO_COPY);
        context.put("selectedServerId", context.get("builder.artifactoryGradleBuilder.artifactoryServerId"));
        String resolutionRepoKey = "builder.artifactoryGradleBuilder.resolutionRepo";
        String selectedResolutionRepoKey = context.get(resolutionRepoKey) != null ? context.get(resolutionRepoKey).toString() : "noResolutionRepoKeyConfigured";
        context.put("selectedResolutionRepoKey", selectedResolutionRepoKey);
        String publishingKey = "builder.artifactoryGradleBuilder.publishingRepo";
        String selectedPublishingRepoKey = context.get(publishingKey) != null ? context.get(publishingKey).toString() : "noPublishingRepoKeyConfigured";
        context.put("selectedPublishingRepoKey", selectedPublishingRepoKey);
        GradleBuildContext buildContext = GradleBuildContext.createGradleContextFromMap(context);
        context.put("hasTests", buildContext.isTestChecked());
        context.put("serverConfigManager", this.serverConfigManager);
        context.put("artifactory.vcs.git.vcs.type.list", this.getVcsTypes());
        context.put("artifactory.vcs.git.authenticationType.list", this.getGitAuthenticationTypes());
        context.put("builder.artifactoryGradleBuilder.publishForkCountList", GradleBuildContext.getPublishForkCountList());
        context.put("builder.artifactoryGradleBuilder.publishForkCount", buildContext.getPublishForkCount());
        ArtifactoryGradleConfiguration.populateDefaultEnvVarsExcludePatternsInBuildContext(context);
        ArtifactoryGradleConfiguration.populateDefaultBuildNameNumberInBuildContext(context);
        Map taskConfiguration = taskDefinition.getConfiguration();
        GradleBuildContext taskContext = new GradleBuildContext(taskConfiguration);
        if (StringUtils.isBlank((CharSequence)taskContext.getDeployerOverrideCredentialsChoice()) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{taskContext.getDeployerUsername(), taskContext.getDeployerPassword()})) {
            context.put("deployer.overrideCredentialsChoice", "usernamePassword");
        }
    }

    @Override
    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map<String, String> taskConfigMap = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(taskConfigMap, params, FIELDS_TO_COPY);
        GradleBuildContext buildContext = new GradleBuildContext(taskConfigMap);
        this.resetDeployerConfigIfNeeded(buildContext);
        this.resetResolverConfigIfNeeded(buildContext);
        taskConfigMap.put("builder.artifactoryGradleBuilder.testResultsDirectory", this.getTestDirectory(buildContext));
        taskConfigMap.putAll(super.getSshFileContent(params, previousTaskDefinition));
        this.decryptFields(taskConfigMap);
        return taskConfigMap;
    }

    @Override
    protected String getKey() {
        return KEY;
    }

    @Override
    protected String getDefaultTestDirectory() {
        return DEFAULT_TEST_REPORTS_XML;
    }

    public boolean taskProducesTestResults(@NotNull TaskDefinition definition) {
        return new GradleBuildContext(definition.getConfiguration()).isTestChecked();
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        String resolutionServerKey = "builder.artifactoryGradleBuilder.resolutionArtifactoryServerId";
        String resolutionRepoKey = "builder.artifactoryMaven3Builder.resolutionRepo";
        TaskConfigurationValidations.validateArtifactoryServerAndRepo(resolutionServerKey, resolutionRepoKey, this.serverConfigManager, params, errorCollection);
        String deploymentServerKey = "builder.artifactoryGradleBuilder.artifactoryServerId";
        String deploymentRepoKey = "builder.artifactoryGradleBuilder.publishingRepo";
        TaskConfigurationValidations.validateArtifactoryServerAndRepo(deploymentServerKey, deploymentRepoKey, this.serverConfigManager, params, errorCollection);
        String buildJdkKey = "builder.artifactoryGradleBuilder.buildJdk";
        TaskConfigurationValidations.validateJdk(buildJdkKey, params, errorCollection);
        if (!params.getBoolean("builder.artifactoryGradleBuilder.useGradleWrapper")) {
            String executableKey = "builder.artifactoryGradleBuilder.executable";
            TaskConfigurationValidations.validateExecutable(executableKey, params, errorCollection);
        }
        TaskConfigurationValidations.validateReleaseManagement(params, errorCollection);
        TaskConfigurationValidations.validateCaptureBuildInfoParams("artifactory.task.buildName", "artifactory.task.buildNumber", "captureBuildInfo", params, errorCollection);
    }

    @Override
    protected boolean isUseWrapper(TaskDefinition taskDefinition) {
        return Boolean.parseBoolean((String)taskDefinition.getConfiguration().get("builder.artifactoryGradleBuilder.useGradleWrapper"));
    }
}

