/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.admin;

import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.spring.container.ContainerManager;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BuildServlet
extends HttpServlet {
    private static final Logger log = LogManager.getLogger(BuildServlet.class);
    private PlanManager planManager = (PlanManager)ContainerManager.getComponent((String)"planManager");
    private final UserManager userManager;

    public BuildServlet(UserManager userManager) {
        this.userManager = userManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        UserProfile profile = this.userManager.getRemoteUser(req);
        if (profile == null || profile.getUserKey() == null) {
            resp.sendError(404);
            return;
        }
        String buildKeyValue = req.getParameter("buildKey");
        if (StringUtils.isBlank((String)buildKeyValue)) {
            resp.sendError(400, "Please provide a build key.");
            log.error("Unable to retrieve build information. No build key was provided.");
            return;
        }
        PlanIdentifier planIdentifierForPermissionCheckingByKey = this.planManager.getPlanIdentifierForPermissionCheckingByKey(buildKeyValue);
        Plan plan = this.planManager.getPlanById(planIdentifierForPermissionCheckingByKey.getId());
        if (plan == null) {
            resp.sendError(404, "Could not find plan with the key " + buildKeyValue + ".");
            log.error("Unable to retrieve build information. No plan was found with the key " + buildKeyValue + ".");
            return;
        }
        try (PrintWriter writer = resp.getWriter();){
            writer.write(plan.getName());
            writer.flush();
        }
    }
}

