/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.admin;

import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalAdminSecurityAware;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.admin.ServerConfigManager;
import org.jfrog.bamboo.security.EncryptionHelper;
import org.jfrog.bamboo.util.BuildInfoLog;
import org.jfrog.bamboo.util.TaskUtils;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryManagerBuilder;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;

public class ArtifactoryServerConfigAction
extends BambooActionSupport
implements GlobalAdminSecurityAware {
    private transient Logger log = LogManager.getLogger(ArtifactoryServerConfigAction.class);
    private String mode;
    private long serverId;
    private String url;
    private String username;
    private String password;
    private int timeout;
    private String isSendTest;
    private transient ServerConfigManager serverConfigManager;

    public ArtifactoryServerConfigAction(ServerConfigManager serverConfigManager) {
        this.serverConfigManager = serverConfigManager;
        this.mode = "add";
        this.timeout = 300;
    }

    public void validate() {
        this.clearErrorsAndMessages();
        if (StringUtils.isBlank((String)this.url)) {
            this.addFieldError("url", "Please specify a URL of an Artifactory server.");
        } else {
            try {
                new URL(this.url);
            }
            catch (MalformedURLException mue) {
                this.addFieldError("url", "Please specify a valid URL of an Artifactory server.");
            }
        }
        if (this.timeout <= 0) {
            this.addFieldError("timeout", "Please specify a positive integer.");
        }
    }

    public String doAdd() throws Exception {
        return "input";
    }

    public String doCreate() throws Exception {
        if (this.isTesting()) {
            this.testConnection();
            return "input";
        }
        this.serverConfigManager.addServerConfiguration(new ServerConfig(-1L, this.getUrl(), this.getUsername(), this.getPassword(), this.getTimeout()));
        return "success";
    }

    public String doEdit() throws Exception {
        ServerConfig serverConfig = this.serverConfigManager.getServerConfigById(this.serverId);
        if (serverConfig == null) {
            throw new IllegalArgumentException("Could not find Artifactory server configuration by the ID " + this.serverId);
        }
        this.updateFieldsFromServerConfig(serverConfig);
        return "input";
    }

    public String doUpdate() throws Exception {
        this.password = EncryptionHelper.decryptIfNeeded(this.password);
        if (this.isTesting()) {
            this.testConnection();
            this.password = EncryptionHelper.encryptForUi(this.password);
            return "input";
        }
        this.serverConfigManager.updateServerConfiguration(this.createServerConfig());
        return "success";
    }

    public String doDelete() throws Exception {
        this.serverConfigManager.deleteServerConfiguration(this.getServerId());
        return "success";
    }

    public String doBrowse() throws Exception {
        return super.execute();
    }

    public String browse() throws Exception {
        return super.execute();
    }

    public String confirm() throws Exception {
        return "success";
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    private boolean isTesting() {
        return StringUtils.isNotBlank((String)this.isSendTest);
    }

    public long getServerId() {
        return this.serverId;
    }

    public void setServerId(long serverId) {
        this.serverId = serverId;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getIsSendTest() {
        return this.isSendTest;
    }

    public void setSendTest(String sendTest) {
        this.isSendTest = sendTest;
    }

    private void testConnection() {
        ArtifactoryManagerBuilder managerBuilder = StringUtils.isNotBlank((String)this.username) ? TaskUtils.getArtifactoryManagerBuilderBuilder(new ServerConfig(this.serverId, this.url, this.username, this.password, this.timeout), new BuildInfoLog(this.log)) : TaskUtils.getArtifactoryManagerBuilderBuilder(new ServerConfig(this.serverId, this.url, "", "", this.timeout), new BuildInfoLog(this.log));
        try (ArtifactoryManager client = managerBuilder.build();){
            client.getVersion();
            this.addActionMessage("Connection successful!");
        }
        catch (IllegalArgumentException iae) {
            this.handleConnectionException(iae);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void handleConnectionException(Exception e) {
        Throwable throwable = e.getCause();
        String errorMessage = throwable != null ? e.getMessage() + " (" + throwable.getClass().getCanonicalName() + ")" : e.getClass().getCanonicalName() + ": " + e.getMessage();
        this.addActionError("Connection failed " + errorMessage);
        this.log.error("Error while testing the connection to Artifactory server " + this.url, (Throwable)e);
    }

    private void updateFieldsFromServerConfig(ServerConfig serverConfig) {
        this.setUrl(serverConfig.getUrl());
        this.setUsername(serverConfig.getUsername());
        this.setPassword(EncryptionHelper.encryptForUi(serverConfig.getPassword()));
        this.setTimeout(serverConfig.getTimeout());
    }

    @NotNull
    private ServerConfig createServerConfig() {
        return new ServerConfig(this.serverId, this.url, this.username, this.password, this.timeout);
    }
}

