/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.maven.resolver;

import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.maven.Maven3BuildInfoLogger;

@Component(role=ResolutionHelper.class)
public class ResolutionHelper {
    @Requirement
    private Logger logger;
    private ArtifactoryClientConfiguration internalConfiguration;
    private boolean initialized = false;

    public void init(Properties allMavenProps) {
        if (this.internalConfiguration != null) {
            return;
        }
        Maven3BuildInfoLogger log = new Maven3BuildInfoLogger(this.logger);
        Properties allProps = BuildInfoExtractorUtils.mergePropertiesWithSystemAndPropertyFile(allMavenProps, log);
        this.internalConfiguration = new ArtifactoryClientConfiguration(log);
        this.internalConfiguration.fillFromProperties(allProps);
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public String getScopeByRequestContext(String requestContext) {
        if (requestContext == null) {
            return "project";
        }
        if ("plugin".equals(requestContext)) {
            return "build";
        }
        return "project";
    }

    public String getRepoReleaseUrl() {
        return this.internalConfiguration.resolver.getUrl(this.internalConfiguration.resolver.getRepoKey());
    }

    public String getRepoSnapshotUrl() {
        return this.internalConfiguration.resolver.getUrl(this.internalConfiguration.resolver.getDownloadSnapshotRepoKey());
    }

    public boolean resolutionRepositoriesConfigured() {
        return StringUtils.isNotBlank(this.getRepoReleaseUrl()) || StringUtils.isNotBlank(this.getRepoSnapshotUrl());
    }

    public String getRepoUsername() {
        return this.internalConfiguration.resolver.getUsername();
    }

    public String getRepoPassword() {
        return this.internalConfiguration.resolver.getPassword();
    }

    public String getHttpProxyHost() {
        return this.internalConfiguration.proxy.getHost();
    }

    public String getNoProxy() {
        return this.internalConfiguration.proxy.getNoProxy();
    }

    public Integer getHttpProxyPort() {
        return this.internalConfiguration.proxy.getPort();
    }

    public String getHttpProxyUsername() {
        return this.internalConfiguration.proxy.getUsername();
    }

    public String getHttpProxyPassword() {
        return this.internalConfiguration.proxy.getPassword();
    }

    public String getHttpsProxyHost() {
        return this.internalConfiguration.httpsProxy.getHost();
    }

    public Integer getHttpsProxyPort() {
        return this.internalConfiguration.httpsProxy.getPort();
    }

    public String getHttpsProxyUsername() {
        return this.internalConfiguration.httpsProxy.getUsername();
    }

    public String getHttpsProxyPassword() {
        return this.internalConfiguration.httpsProxy.getPassword();
    }

    public Logger getLogger() {
        return this.logger;
    }
}

