/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.maven.resolver;

import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.Authentication;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.repository.Proxy;
import org.codehaus.plexus.logging.Logger;
import org.jfrog.build.extractor.ProxySelector;
import org.jfrog.build.extractor.maven.resolver.ArtifactoryResolutionRepositoryBase;

public class ArtifactoryPluginResolution
extends ArtifactoryResolutionRepositoryBase {
    public ArtifactoryPluginResolution(String repoReleaseUrl, String snapshotRepoUrl, String repoUsername, String repoPassword, ProxySelector proxySelector, Logger logger) {
        super(repoReleaseUrl, snapshotRepoUrl, repoUsername, repoPassword, proxySelector, logger);
    }

    public ArtifactRepository createSnapshotRepository() {
        if (super.shouldCreateSnapshotRepository()) {
            return this.createDefaultRepository(this.snapshotRepoUrl, "artifactory-snapshot", false, true);
        }
        return null;
    }

    public ArtifactRepository createReleaseRepository() {
        if (super.shouldCreateReleaseRepository()) {
            String repositoryId = this.snapshotPolicyEnabled() ? "artifactory-release-snapshot" : "artifactory-release";
            return this.createDefaultRepository(this.releaseRepoUrl, repositoryId, true, this.snapshotPolicyEnabled());
        }
        return null;
    }

    private ArtifactRepository createDefaultRepository(String repoUrl, String repoId, boolean releasePolicy, Boolean snapshotPolicy) {
        MavenArtifactRepository repository = new MavenArtifactRepository();
        this.setPolicy(repository, releasePolicy, snapshotPolicy);
        repository.setLayout(new DefaultRepositoryLayout());
        repository.setUrl(repoUrl);
        repository.setId(repoId);
        this.setAuth(repository);
        this.setProxy(repository);
        return repository;
    }

    private void setPolicy(ArtifactRepository snapshotPluginRepository, boolean releasePolicyEnabled, boolean snapshotPolicyEnabled) {
        ArtifactRepositoryPolicy releasePolicy = new ArtifactRepositoryPolicy(releasePolicyEnabled, "daily", "warn");
        snapshotPluginRepository.setReleaseUpdatePolicy(releasePolicy);
        ArtifactRepositoryPolicy snapshotPolicy = new ArtifactRepositoryPolicy(snapshotPolicyEnabled, "daily", "warn");
        snapshotPluginRepository.setSnapshotUpdatePolicy(snapshotPolicy);
    }

    private void setAuth(ArtifactRepository snapshotPluginRepository) {
        if (this.shouldSetAuthentication()) {
            Authentication authentication = new Authentication(this.repoUsername, this.repoPassword);
            snapshotPluginRepository.setAuthentication(authentication);
        }
    }

    private void setProxy(ArtifactRepository repository) {
        Proxy proxy = this.createMavenProxy(repository.getUrl());
        if (proxy != null) {
            repository.setProxy(proxy);
        }
    }
}

