/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.util;

import com.atlassian.bamboo.task.TaskDefinition;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.jfrog.bamboo.context.PackageManagersContext;

public abstract class TaskDefinitionHelper {
    private TaskDefinitionHelper() {
        throw new IllegalAccessError();
    }

    @Nullable
    public static TaskDefinition findMavenOrGradleDefinition(List<TaskDefinition> taskDefinitions) {
        if (taskDefinitions == null || taskDefinitions.isEmpty()) {
            return null;
        }
        TaskDefinition definition = TaskDefinitionHelper.findMavenDefinition(taskDefinitions);
        if (definition == null) {
            definition = TaskDefinitionHelper.findGradleDefinition(taskDefinitions);
        }
        return definition;
    }

    @Nullable
    public static TaskDefinition findGradleDefinition(List<? extends TaskDefinition> taskDefinitions) {
        if (taskDefinitions != null) {
            for (TaskDefinition taskDefinition : taskDefinitions) {
                if (!taskDefinition.isEnabled() || !StringUtils.endsWith((String)taskDefinition.getPluginKey(), (String)"artifactoryGradleTask")) continue;
                return taskDefinition;
            }
        }
        return null;
    }

    @Nullable
    public static TaskDefinition findMavenDefinition(List<? extends TaskDefinition> taskDefinitions) {
        if (taskDefinitions != null) {
            for (TaskDefinition taskDefinition : taskDefinitions) {
                if (!taskDefinition.isEnabled() || !StringUtils.endsWith((String)taskDefinition.getPluginKey(), (String)"maven3Task")) continue;
                return taskDefinition;
            }
        }
        return null;
    }

    @Nullable
    public static TaskDefinition findReleaseTaskDefinition(List<? extends TaskDefinition> taskDefinitions) {
        if (taskDefinitions != null) {
            for (TaskDefinition taskDefinition : taskDefinitions) {
                if (!taskDefinition.isEnabled() || !TaskDefinitionHelper.isReleaseMgmtEnabled(taskDefinition)) continue;
                return taskDefinition;
            }
        }
        return null;
    }

    public static boolean isReleaseMgmtEnabled(TaskDefinition taskDefinition) {
        PackageManagersContext config = PackageManagersContext.createContextFromMap(taskDefinition.getConfiguration());
        return config != null && config.releaseManagementContext.isReleaseMgmtEnabled();
    }

    @Nullable
    public static boolean isBuildPublishTaskExists(List<? extends TaskDefinition> taskDefinitions) {
        if (taskDefinitions != null) {
            for (TaskDefinition taskDefinition : taskDefinitions) {
                if (!taskDefinition.isEnabled() || !StringUtils.endsWith((String)taskDefinition.getPluginKey(), (String)"artifactoryPublishBuildInfoTask")) continue;
                return true;
            }
        }
        return false;
    }
}

