/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.task;

import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.spring.container.ContainerManager;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.builder.BuildInfoHelper;
import org.jfrog.bamboo.configuration.BuildParamsOverrideManager;
import org.jfrog.bamboo.context.NpmBuildContext;
import org.jfrog.bamboo.task.ArtifactoryTaskType;
import org.jfrog.bamboo.util.BuildInfoLog;
import org.jfrog.bamboo.util.TaskUtils;
import org.jfrog.build.extractor.ci.BuildInfo;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryManagerBuilder;
import org.jfrog.build.extractor.npm.extractor.NpmInstallCi;
import org.jfrog.build.extractor.npm.extractor.NpmPublish;

public class ArtifactoryNpmTask
extends ArtifactoryTaskType {
    private static final String TASK_NAME = "artifactoryNpmTask";
    private static final String NPM_KEY = "system.builder.npm.";
    private static final String EXECUTABLE_NAME = "npm";
    private final EnvironmentVariableAccessor environmentVariableAccessor;
    private final CapabilityContext capabilityContext;
    private BuildParamsOverrideManager buildParamsOverrideManager;
    private CustomVariableContext customVariableContext;
    private Map<String, String> environmentVariables;
    private NpmBuildContext npmBuildContext;
    private BuildInfoHelper buildInfoHelper;
    private String buildNumber;
    private String buildName;
    private Path packagePath;

    public ArtifactoryNpmTask(EnvironmentVariableAccessor environmentVariableAccessor, CapabilityContext capabilityContext) {
        this.environmentVariableAccessor = environmentVariableAccessor;
        this.capabilityContext = capabilityContext;
        ContainerManager.autowireComponent((Object)this);
    }

    @Override
    protected void initTask(@NotNull CommonTaskContext context) throws TaskException {
        super.initTask(context);
        this.npmBuildContext = new NpmBuildContext((Map<String, String>)this.taskContext.getConfigurationMap());
        this.buildParamsOverrideManager = new BuildParamsOverrideManager(this.customVariableContext);
        BuildContext buildContext = ((TaskContext)context).getBuildContext();
        this.buildName = this.npmBuildContext.getBuildName(buildContext);
        this.buildNumber = this.npmBuildContext.getBuildNumber(buildContext);
        this.initBuildInfoHelper(buildContext);
        this.environmentVariables = this.getEnv();
        this.packagePath = this.getPackagePath();
    }

    @Override
    @NotNull
    public TaskResult runTask(@NotNull TaskContext taskContext) {
        BuildInfo build = this.npmBuildContext.isNpmCommandInstall() ? this.executeNpmInstall() : this.executeNpmPublish();
        if (build == null) {
            return this.failRun((CommonTaskContext)taskContext);
        }
        if (this.npmBuildContext.isCaptureBuildInfo()) {
            build.setName(this.buildName);
            build.setNumber(this.buildNumber);
            this.buildInfoHelper.addEnvVarsToBuild(this.npmBuildContext, build);
            this.taskBuildInfo = build;
        }
        return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).success().build();
    }

    private TaskResult failRun(@NotNull CommonTaskContext taskContext) {
        return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failedWithError().build();
    }

    private void initBuildInfoHelper(BuildContext buildContext) {
        Map runtimeContext = this.taskContext.getRuntimeTaskContext();
        this.buildInfoHelper = this.npmBuildContext.isNpmCommandInstall() ? BuildInfoHelper.createResolveBuildInfoHelper(this.buildName, this.buildNumber, this.taskContext, buildContext, this.environmentVariableAccessor, this.npmBuildContext.getResolutionArtifactoryServerId(), this.npmBuildContext.getOverriddenUsername(runtimeContext, this.buildInfoLog, false), this.npmBuildContext.getOverriddenPassword(runtimeContext, this.buildInfoLog, false), this.buildParamsOverrideManager) : BuildInfoHelper.createDeployBuildInfoHelper(this.buildName, this.buildNumber, this.taskContext, buildContext, this.environmentVariableAccessor, this.npmBuildContext.getArtifactoryServerId(), this.npmBuildContext.getOverriddenUsername(runtimeContext, this.buildInfoLog, true), this.npmBuildContext.getOverriddenPassword(runtimeContext, this.buildInfoLog, true), this.buildParamsOverrideManager);
    }

    private BuildInfo executeNpmInstall() {
        ServerConfig serverConfig = this.buildInfoHelper.getServerConfig();
        BuildInfoLog buildInfoLogger = new BuildInfoLog(log, this.logger);
        ArtifactoryManagerBuilder artifactoryManagerBuilder = TaskUtils.getArtifactoryManagerBuilderBuilder(serverConfig, buildInfoLogger);
        String repo = this.buildInfoHelper.overrideParam(this.npmBuildContext.getResolutionRepo(), "artifactory.override.resolve.repo");
        return new NpmInstallCi(artifactoryManagerBuilder, repo, this.npmBuildContext.getArguments(), this.buildInfoLog, this.packagePath, this.environmentVariables, "", this.buildName, false, "").execute();
    }

    private BuildInfo executeNpmPublish() {
        String repo = this.buildInfoHelper.overrideParam(this.npmBuildContext.getPublishingRepo(), "artifactory.override.deploy.repo");
        return new NpmPublish(this.buildInfoHelper.getClientBuilder(this.logger, log), TaskUtils.getCommonArtifactPropertiesMap(this.buildInfoHelper), this.packagePath, repo, this.buildInfoLog, this.environmentVariables, "").execute();
    }

    private Path getPackagePath() {
        File rootDir = this.taskContext.getRootDirectory();
        String subDirectory = this.npmBuildContext.getWorkingSubdirectory();
        if (StringUtils.isNotBlank((String)subDirectory)) {
            return new File(rootDir, subDirectory).toPath();
        }
        return rootDir.toPath();
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }

    public Map<String, String> getEnv() throws TaskException {
        Map<String, String> env = TaskUtils.getEnvironmentVariables(this.npmBuildContext, this.environmentVariableAccessor);
        return TaskUtils.addExecutablePathToEnv(env, this.npmBuildContext, this.capabilityContext, NPM_KEY, EXECUTABLE_NAME, TASK_NAME, this.containerized);
    }

    @Override
    protected ServerConfig getUsageServerConfig() {
        return this.buildInfoHelper.getServerConfig();
    }

    @Override
    protected String getTaskUsageName() {
        return EXECUTABLE_NAME;
    }
}

