/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.task;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.builder.BuildInfoHelper;
import org.jfrog.bamboo.configuration.BuildParamsOverrideManager;
import org.jfrog.bamboo.context.GenericContext;
import org.jfrog.bamboo.task.ArtifactoryTaskType;
import org.jfrog.bamboo.util.FileSpecUtils;
import org.jfrog.bamboo.util.TaskUtils;
import org.jfrog.bamboo.util.Utils;
import org.jfrog.bamboo.util.generic.GenericArtifactsResolver;
import org.jfrog.build.api.dependency.BuildDependency;
import org.jfrog.build.extractor.ci.BuildInfo;
import org.jfrog.build.extractor.ci.Dependency;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.clientConfiguration.util.spec.SpecsHelper;

public class ArtifactoryGenericResolveTask
extends ArtifactoryTaskType {
    private final EnvironmentVariableAccessor environmentVariableAccessor;
    private final BuildParamsOverrideManager buildParamsOverrideManager;
    private CustomVariableContext customVariableContext;
    private BuildInfoHelper buildInfoHelper;
    private GenericContext genericContext;
    private String fileSpec;

    public ArtifactoryGenericResolveTask(EnvironmentVariableAccessor environmentVariableAccessor) {
        this.environmentVariableAccessor = environmentVariableAccessor;
        ContainerManager.autowireComponent((Object)this);
        this.buildParamsOverrideManager = new BuildParamsOverrideManager(this.customVariableContext);
    }

    @Override
    protected void initTask(@NotNull CommonTaskContext context) throws TaskException {
        super.initTask(context);
        BuildContext buildContext = ((TaskContext)context).getBuildContext();
        this.genericContext = new GenericContext((Map<String, String>)context.getConfigurationMap());
        Map runtimeContext = context.getRuntimeTaskContext();
        this.buildInfoHelper = BuildInfoHelper.createResolveBuildInfoHelper(this.genericContext.getBuildName(buildContext), this.genericContext.getBuildNumber(buildContext), context, buildContext, this.environmentVariableAccessor, this.genericContext.getSelectedServerId(), this.genericContext.getOverriddenUsername(runtimeContext, this.buildInfoLog, false), this.genericContext.getOverriddenPassword(runtimeContext, this.buildInfoLog, false), this.buildParamsOverrideManager);
    }

    @Override
    @NotNull
    public TaskResult runTask(@NotNull TaskContext taskContext) {
        this.logger.addBuildLogEntry("Bamboo Artifactory Plugin version: " + Utils.getPluginVersion(this.pluginAccessor));
        try (ArtifactoryManager artifactoryManager = TaskUtils.getArtifactoryManagerBuilderBuilder(this.buildInfoHelper.getServerConfig(), this.buildInfoLog).build();){
            List<Dependency> dependencies;
            ArrayList<BuildDependency> buildDependencies;
            if (this.genericContext.isUseFileSpecs()) {
                buildDependencies = Lists.newArrayList();
                this.initFileSpec((CommonTaskContext)taskContext, this.logger);
                SpecsHelper specsHelper = new SpecsHelper(this.buildInfoLog);
                dependencies = specsHelper.downloadArtifactsBySpec(this.fileSpec, artifactoryManager, taskContext.getWorkingDirectory().getCanonicalPath());
            } else {
                GenericArtifactsResolver resolver = new GenericArtifactsResolver((CommonTaskContext)taskContext, artifactoryManager, this.genericContext.getResolvePattern(), this.buildInfoLog);
                buildDependencies = resolver.retrieveBuildDependencies();
                dependencies = resolver.retrievePublishedDependencies();
            }
            if (this.genericContext.isCaptureBuildInfo()) {
                BuildInfo build = this.buildInfoHelper.getBuild(taskContext, this.genericContext);
                this.taskBuildInfo = build = this.buildInfoHelper.addBuildInfoParams(build, Lists.newArrayList(), dependencies, buildDependencies);
            }
        }
        catch (IOException | InterruptedException e) {
            this.buildInfoLog.error("Exception occurred while executing task", e);
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failedWithError().build();
        }
        return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).success().build();
    }

    @Override
    protected ServerConfig getUsageServerConfig() {
        return this.buildInfoHelper.getServerConfig();
    }

    @Override
    protected String getTaskUsageName() {
        return "generic_resolve";
    }

    private void initFileSpec(CommonTaskContext context, BuildLogger logger) throws IOException {
        this.fileSpec = FileSpecUtils.getFileSpec(this.genericContext.isFileSpecInJobConfiguration(), this.genericContext.getJobConfigurationSpec(), this.genericContext.getFilePathSpec(), context.getWorkingDirectory(), this.customVariableContext, logger);
        logger.addBuildLogEntry("Spec: " + this.fileSpec);
        FileSpecUtils.validateFileSpec(this.fileSpec);
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }
}

