/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.task;

import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.spring.container.ContainerManager;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.builder.BuildInfoHelper;
import org.jfrog.bamboo.configuration.BuildParamsOverrideManager;
import org.jfrog.bamboo.context.DockerBuildContext;
import org.jfrog.bamboo.task.ArtifactoryTaskType;
import org.jfrog.bamboo.util.TaskUtils;
import org.jfrog.build.extractor.ci.BuildInfo;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryManagerBuilder;
import org.jfrog.build.extractor.docker.extractor.DockerPull;
import org.jfrog.build.extractor.docker.extractor.DockerPush;

public class ArtifactoryDockerTask
extends ArtifactoryTaskType {
    private final EnvironmentVariableAccessor environmentVariableAccessor;
    private BuildParamsOverrideManager buildParamsOverrideManager;
    private CustomVariableContext customVariableContext;
    private Map<String, String> environmentVariables;
    private DockerBuildContext dockerBuildContext;
    private BuildInfoHelper buildInfoHelper;
    private String buildNumber;
    private String buildName;
    private ArtifactoryManagerBuilder artifactoryManagerBuilder;

    public ArtifactoryDockerTask(EnvironmentVariableAccessor environmentVariableAccessor) {
        this.environmentVariableAccessor = environmentVariableAccessor;
        ContainerManager.autowireComponent((Object)this);
    }

    @Override
    protected void initTask(@NotNull CommonTaskContext context) throws TaskException {
        super.initTask(context);
        this.dockerBuildContext = new DockerBuildContext((Map<String, String>)this.taskContext.getConfigurationMap());
        this.buildParamsOverrideManager = new BuildParamsOverrideManager(this.customVariableContext);
        this.environmentVariables = TaskUtils.getEnvironmentVariables(this.dockerBuildContext, this.environmentVariableAccessor);
        BuildContext buildContext = ((TaskContext)context).getBuildContext();
        this.buildName = this.dockerBuildContext.getBuildName(buildContext);
        this.buildNumber = this.dockerBuildContext.getBuildNumber(buildContext);
        this.initBuildInfoHelper(buildContext);
        this.artifactoryManagerBuilder = TaskUtils.getArtifactoryManagerBuilderBuilder(this.buildInfoHelper.getServerConfig(), this.buildInfoLog);
    }

    @Override
    @NotNull
    public TaskResult runTask(@NotNull TaskContext taskContext) {
        BuildInfo build = this.dockerBuildContext.isDockerCommandPull() ? this.executeDockerPull() : this.executeDockerPush();
        if (build == null) {
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failedWithError().build();
        }
        if (this.dockerBuildContext.isCaptureBuildInfo()) {
            build.setName(this.buildName);
            build.setNumber(this.buildNumber);
            this.buildInfoHelper.addEnvVarsToBuild(this.dockerBuildContext, build);
            this.taskBuildInfo = build;
        }
        return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).success().build();
    }

    private BuildInfo executeDockerPull() {
        String repo = this.buildInfoHelper.overrideParam(this.dockerBuildContext.getResolutionRepo(), "artifactory.override.resolve.repo");
        String userName = this.buildInfoHelper.getServerConfig().getUsername();
        String password = this.buildInfoHelper.getServerConfig().getPassword();
        return new DockerPull(this.artifactoryManagerBuilder, this.dockerBuildContext.getImageName(), this.dockerBuildContext.getHost(), repo, userName, password, this.buildInfoLog, this.environmentVariables).execute();
    }

    private BuildInfo executeDockerPush() {
        String repo = this.buildInfoHelper.overrideParam(this.dockerBuildContext.getPublishingRepo(), "artifactory.override.deploy.repo");
        String userName = this.buildInfoHelper.getServerConfig().getUsername();
        String password = this.buildInfoHelper.getServerConfig().getPassword();
        return new DockerPush(this.artifactoryManagerBuilder, this.dockerBuildContext.getImageName(), this.dockerBuildContext.getHost(), TaskUtils.getCommonArtifactPropertiesMap(this.buildInfoHelper), repo, userName, password, this.buildInfoLog, this.environmentVariables).execute();
    }

    private void initBuildInfoHelper(BuildContext buildContext) {
        Map runtimeContext = this.taskContext.getRuntimeTaskContext();
        this.buildInfoHelper = this.dockerBuildContext.isDockerCommandPull() ? BuildInfoHelper.createResolveBuildInfoHelper(this.buildName, this.buildNumber, this.taskContext, buildContext, this.environmentVariableAccessor, this.dockerBuildContext.getResolutionArtifactoryServerId(), this.dockerBuildContext.getOverriddenUsername(runtimeContext, this.buildInfoLog, false), this.dockerBuildContext.getOverriddenPassword(runtimeContext, this.buildInfoLog, false), this.buildParamsOverrideManager) : BuildInfoHelper.createDeployBuildInfoHelper(this.buildName, this.buildNumber, this.taskContext, buildContext, this.environmentVariableAccessor, this.dockerBuildContext.getArtifactoryServerId(), this.dockerBuildContext.getOverriddenUsername(runtimeContext, this.buildInfoLog, true), this.dockerBuildContext.getOverriddenPassword(runtimeContext, this.buildInfoLog, true), this.buildParamsOverrideManager);
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }

    @Override
    protected ServerConfig getUsageServerConfig() {
        return this.buildInfoHelper.getServerConfig();
    }

    @Override
    protected String getTaskUsageName() {
        return "docker";
    }
}

