/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.release.vcs.perforce;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CurrentBuildResult;
import com.atlassian.bamboo.variable.CustomVariableContext;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.jfrog.bamboo.context.PackageManagersContext;
import org.jfrog.bamboo.release.vcs.AbstractVcsCoordinator;
import org.jfrog.bamboo.release.vcs.perforce.PerforceManager;

public class PerforceCoordinator
extends AbstractVcsCoordinator {
    private PerforceManager perforce;
    private final Map<String, String> configuration;
    private boolean tagCreated;
    private int currentChangeListId;

    public PerforceCoordinator(BuildContext context, Map<String, String> configuration, BuildLogger buildLogger, CustomVariableContext customVariableContext, CredentialsAccessor credentialsAccessor) {
        super(context, buildLogger, customVariableContext, credentialsAccessor);
        this.configuration = configuration;
    }

    @Override
    public void prepare() throws IOException {
        this.perforce = new PerforceManager(this.context, this.buildLogger);
        this.perforce.prepare();
    }

    @Override
    public void beforeReleaseVersionChange() throws IOException {
        this.currentChangeListId = this.perforce.createNewChangeList();
    }

    @Override
    public void afterSuccessfulReleaseVersionBuild() throws IOException, InterruptedException {
        PackageManagersContext context = PackageManagersContext.createContextFromMap(this.configuration);
        PackageManagersContext.ReleaseManagementContext releaseManagementContext = context.releaseManagementContext;
        String labelChangeListId = this.configuration.get("repository.revision.number");
        if (this.modifiedFilesForReleaseVersion) {
            this.log("Submitting release version changes");
            labelChangeListId = this.currentChangeListId + "";
            this.perforce.commitWorkingCopy(this.currentChangeListId, releaseManagementContext.getTagComment());
        } else {
            this.safeRevertWorkingCopy();
            this.currentChangeListId = this.perforce.getDefaultChangeListId();
        }
        if (releaseManagementContext.isCreateVcsTag()) {
            this.log("Creating label: '" + releaseManagementContext.getTagUrl() + "' with change list id: " + labelChangeListId);
            this.perforce.createTag(releaseManagementContext.getTagUrl(), releaseManagementContext.getTagComment(), labelChangeListId);
            this.tagCreated = true;
        }
    }

    @Override
    public void beforeDevelopmentVersionChange() throws IOException {
        this.currentChangeListId = this.perforce.getDefaultChangeListId();
    }

    @Override
    public void afterDevelopmentVersionChange(boolean modified) throws IOException, InterruptedException {
        super.afterDevelopmentVersionChange(modified);
        PackageManagersContext context = PackageManagersContext.createContextFromMap(this.configuration);
        PackageManagersContext.ReleaseManagementContext releaseManagementContext = context.releaseManagementContext;
        if (modified) {
            this.log("Submitting next development version changes");
            this.perforce.commitWorkingCopy(this.currentChangeListId, releaseManagementContext.getNextDevelopmentComment());
        } else {
            this.safeRevertWorkingCopy();
            this.currentChangeListId = this.perforce.getDefaultChangeListId();
        }
    }

    @Override
    public void edit(File file) throws IOException, InterruptedException {
        this.log("Opening file: '" + file.getAbsolutePath() + "' for editing");
        this.perforce.edit(this.currentChangeListId, file);
    }

    @Override
    public void buildCompleted(BuildContext buildContext) throws IOException, InterruptedException {
        PackageManagersContext context = PackageManagersContext.createContextFromMap(this.configuration);
        CurrentBuildResult result = buildContext.getBuildResult();
        if (!BuildState.SUCCESS.equals((Object)result.getBuildState())) {
            this.safeRevertWorkingCopy();
            if (this.tagCreated) {
                this.safeDeleteLabel(context.releaseManagementContext.getTagUrl());
            }
        } else {
            this.log("Closing connection to perforce server");
            this.perforce.closeConnection();
        }
    }

    private void safeRevertWorkingCopy() {
        this.log("Reverting local changes");
        try {
            this.perforce.revertWorkingCopy(this.currentChangeListId);
        }
        catch (Exception e) {
            this.log("Failed to revert: " + e.getLocalizedMessage());
        }
    }

    private void safeDeleteLabel(String label) throws IOException {
        this.log("Deleting label '" + label + "'");
        try {
            this.perforce.deleteLabel(label);
        }
        catch (Exception e) {
            this.log("Failed to delete label: " + e.getLocalizedMessage());
        }
    }

    @Override
    public String getRemoteUrlForPom() {
        return null;
    }

    @Override
    public boolean isSubversion() {
        return false;
    }

    @Override
    public int getCurrentChangeListId() {
        return this.currentChangeListId;
    }

    @Override
    public void setCurrentChangeListId(int currentChangeListId) {
        this.currentChangeListId = currentChangeListId;
    }
}

