/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.promotion;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jfrog.bamboo.release.action.ReleasePromotionAction;
import org.jfrog.bamboo.util.ActionLog;
import org.jfrog.build.api.builder.PromotionBuilder;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;

public class PromotionThread
extends Thread {
    transient Logger log = LogManager.getLogger(PromotionThread.class);
    private ReleasePromotionAction action;
    private ArtifactoryManager client;
    private String bambooUsername;
    private ActionLog releaseLog;
    private String buildName;
    private String buildNumber;

    public PromotionThread(ReleasePromotionAction action, ArtifactoryManager client, String bambooUsername, String buildName, String buildNumber) {
        this.action = action;
        this.client = client;
        this.bambooUsername = bambooUsername;
        this.releaseLog = ReleasePromotionAction.promotionContext.getActionLog();
        this.releaseLog.setLogger(this.log);
        this.buildName = buildName;
        this.buildNumber = buildNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            ReleasePromotionAction.promotionContext.getLock().lock();
            ReleasePromotionAction.promotionContext.setBuildKey(this.action.getBuildKey());
            ReleasePromotionAction.promotionContext.setBuildNumber(this.action.getBuildNumber());
            ReleasePromotionAction.promotionContext.setDone(false);
            ReleasePromotionAction.promotionContext.getLog().clear();
            this.performPromotion();
        }
        catch (Exception e) {
            String message = "An error occurred: " + e.getMessage();
            this.releaseLog.logError(message, e);
        }
        finally {
            try {
                this.client.close();
            }
            finally {
                ReleasePromotionAction.promotionContext.setDone(true);
                ReleasePromotionAction.promotionContext.getLock().unlock();
            }
        }
    }

    private void performPromotion() throws IOException {
        this.releaseLog.logMessage("Promoting build ...");
        PromotionBuilder promotionBuilder = new PromotionBuilder().status(this.action.getTarget()).comment(this.action.getComment()).ciUser(this.bambooUsername).targetRepo(this.action.getPromotionRepo()).dependencies(this.action.isIncludeDependencies()).copy(this.action.isUseCopy()).dryRun(true);
        this.releaseLog.logMessage("Performing dry run promotion (no changes are made during dry run) ...");
        if (StringUtils.isBlank((String)this.buildName)) {
            this.buildName = this.action.getImmutableBuild().getName();
        }
        if (StringUtils.isBlank((String)this.buildNumber)) {
            this.buildNumber = this.action.getBuildNumber().toString();
        }
        try {
            this.client.stageBuild(this.buildName, this.buildNumber, "", promotionBuilder.build());
            this.releaseLog.logMessage("Dry run finished successfully. Performing promotion ...");
        }
        catch (IOException e) {
            this.releaseLog.logMessage(ExceptionUtils.getRootCauseMessage(e));
            return;
        }
        this.client.stageBuild(this.buildName, this.buildNumber, "", promotionBuilder.dryRun(false).build());
        this.releaseLog.logMessage("Promotion completed successfully!");
    }
}

