/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.configuration;

import com.atlassian.bamboo.task.TaskDefinition;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.configuration.AbstractGenericBuildConfiguration;
import org.jfrog.bamboo.context.GenericContext;

public class ArtifactoryGenericBuildConfiguration
extends AbstractGenericBuildConfiguration {
    static final String KEY = "artifactoryGenericBuilder";

    @Override
    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        this.populateLegacyContextForCreate(context);
    }

    @Override
    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        String selectedPublishingRepoKey;
        super.populateContextForEdit(context, taskDefinition);
        this.populateLegacyContextForEdit(context, taskDefinition);
        String string = selectedPublishingRepoKey = context.get("builder.artifactoryGenericBuilder.deployableRepo") != null ? context.get("builder.artifactoryGenericBuilder.deployableRepo").toString() : null;
        if (StringUtils.isBlank(selectedPublishingRepoKey)) {
            selectedPublishingRepoKey = (String)taskDefinition.getConfiguration().get("artifactory.generic.deployableRepo");
        }
        context.put("selectedRepoKey", selectedPublishingRepoKey);
        context.put("signMethods", GenericContext.SIGN_METHOD_MAP);
        Map taskConfiguration = taskDefinition.getConfiguration();
        GenericContext taskContext = new GenericContext(taskConfiguration);
        if (StringUtils.isBlank(taskContext.getDeployerOverrideCredentialsChoice()) && StringUtils.isNoneBlank(taskContext.getUsername(), taskContext.getPassword())) {
            context.put("deployer.overrideCredentialsChoice", "usernamePassword");
        }
    }

    @Override
    protected String getKey() {
        return KEY;
    }
}

