/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jfrog.bamboo.configuration.AbstractArtifactoryConfiguration;
import org.jfrog.bamboo.configuration.util.TaskConfigurationValidations;
import org.jfrog.bamboo.context.DockerBuildContext;
import org.jfrog.bamboo.context.PackageManagersContext;

public class ArtifactoryDockerConfiguration
extends AbstractArtifactoryConfiguration {
    public static final String CFG_DOCKER_COMMAND_PULL = "pull";
    private static final String CFG_DOCKER_COMMAND_PUSH = "push";
    private static final String KEY = "artifactoryDockerBuilder";
    private static final Set<String> FIELDS_TO_COPY = DockerBuildContext.getFieldsToCopy();
    private static final Map<String, String> CFG_DOCKER_COMMAND_OPTIONS = ImmutableMap.of("pull", "pull", "push", "push");

    public ArtifactoryDockerConfiguration() {
        super("artifactory.task.docker.", "system.builder.docker");
    }

    @Override
    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        this.populateDockerCommandContext(context);
        context.put("artifactoryDockerTask", (Object)this);
        context.put("builderType", (Object)this);
        context.put("builder", (Object)this);
        context.put("adminConfig", this.administrationConfiguration);
        context.put("baseUrl", this.administrationConfiguration.getBaseUrl());
        Plan plan = (Plan)context.get("plan");
        context.put("build", plan);
        context.put("dummyList", Lists.newArrayList());
        context.put("serverConfigManager", this.serverConfigManager);
        context.put("selectedResolutionServerId", -1);
        context.put("selectedResolutionRepoKey", "");
        context.put("selectedPublishingServerId", -1);
        context.put("selectedPublishingRepoKey", "");
    }

    @Override
    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.populateDockerCommandContext(context);
        this.populateContextWithConfiguration(context, taskDefinition, FIELDS_TO_COPY);
        context.put("selectedPublishingServerId", context.get("artifactory.task.docker.artifactoryServerId"));
        context.put("selectedResolutionServerId", context.get("artifactory.task.docker.resolutionArtifactoryServerId"));
        String selectedResolutionRepoKey = context.get("artifactory.task.docker.resolutionRepo") != null ? context.get("artifactory.task.docker.resolutionRepo").toString() : "noResolutionRepoKeyConfigured";
        context.put("selectedResolutionRepoKey", selectedResolutionRepoKey);
        String selectedPublishingRepoKey = context.get("artifactory.task.docker.publishingRepo") != null ? context.get("artifactory.task.docker.publishingRepo").toString() : "noPublishingRepoKeyConfigured";
        context.put("selectedPublishingRepoKey", selectedPublishingRepoKey);
        context.put("serverConfigManager", this.serverConfigManager);
        String envVarsExcludePatterns = (String)context.get("envVarsExcludePatterns");
        if (envVarsExcludePatterns == null) {
            context.put("envVarsExcludePatterns", "*password*,*pwd*,*secret*,*security*,*key*,*token*");
        }
    }

    private void populateDockerCommandContext(@NotNull Map<String, Object> context) {
        context.put("dockerCommandOptions", CFG_DOCKER_COMMAND_OPTIONS);
        context.put("artifactory.task.docker.command.choice", CFG_DOCKER_COMMAND_PULL);
    }

    @Override
    protected void resetResolverConfigIfNeeded(PackageManagersContext buildContext) {
        long serverId = buildContext.getResolutionArtifactoryServerId();
        if (serverId == -1L) {
            buildContext.resetResolverContextToDefault();
        }
    }

    @Override
    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map<String, String> taskConfigMap = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(taskConfigMap, params, FIELDS_TO_COPY);
        DockerBuildContext buildContext = new DockerBuildContext(taskConfigMap);
        this.resetDeployerConfigIfNeeded(buildContext);
        this.resetResolverConfigIfNeeded(buildContext);
        taskConfigMap.putAll(super.getSshFileContent(params, previousTaskDefinition));
        this.decryptFields(taskConfigMap);
        return taskConfigMap;
    }

    @Override
    protected String getKey() {
        return KEY;
    }

    public boolean taskProducesTestResults(@NotNull TaskDefinition taskDefinition) {
        return false;
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        String imageName;
        String commandChoiceKey = "artifactory.task.docker.command.choice";
        if (CFG_DOCKER_COMMAND_PUSH.equals(params.getString(commandChoiceKey))) {
            TaskConfigurationValidations.validateArtifactoryServerAndRepo("artifactory.task.docker.artifactoryServerId", "artifactory.task.docker.publishingRepo", this.serverConfigManager, params, errorCollection);
        }
        if (CFG_DOCKER_COMMAND_PULL.equals(params.getString(commandChoiceKey))) {
            TaskConfigurationValidations.validateArtifactoryServerAndRepo("artifactory.task.docker.resolutionArtifactoryServerId", "artifactory.task.docker.resolutionRepo", this.serverConfigManager, params, errorCollection);
        }
        if (StringUtils.isBlank((String)params.getString(imageName = "artifactory.task.docker.imageName"))) {
            errorCollection.addError(imageName, "Please specify an Image Name.");
        }
        TaskConfigurationValidations.validateCaptureBuildInfoParams("artifactory.task.buildName", "artifactory.task.buildNumber", "captureBuildInfo", params, errorCollection);
    }
}

