/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.builder;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.utils.EscapeChars;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.trigger.DependencyTriggerReason;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.admin.ServerConfigManager;
import org.jfrog.bamboo.builder.BaseBuildInfoHelper;
import org.jfrog.bamboo.configuration.BuildParamsOverrideManager;
import org.jfrog.bamboo.context.GenericContext;
import org.jfrog.bamboo.context.PackageManagersContext;
import org.jfrog.bamboo.util.BuildInfoLog;
import org.jfrog.bamboo.util.TaskUtils;
import org.jfrog.bamboo.util.version.VcsHelper;
import org.jfrog.build.api.dependency.BuildDependency;
import org.jfrog.build.extractor.builder.BuildInfoBuilder;
import org.jfrog.build.extractor.builder.ModuleBuilder;
import org.jfrog.build.extractor.ci.Agent;
import org.jfrog.build.extractor.ci.Artifact;
import org.jfrog.build.extractor.ci.BuildAgent;
import org.jfrog.build.extractor.ci.BuildInfo;
import org.jfrog.build.extractor.ci.Dependency;
import org.jfrog.build.extractor.ci.Module;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryManagerBuilder;
import org.jfrog.build.extractor.clientConfiguration.IncludeExcludePatterns;
import org.jfrog.build.extractor.clientConfiguration.PatternMatcher;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class BuildInfoHelper
extends BaseBuildInfoHelper {
    private final Map<String, String> env;
    private final String buildName;
    private final String buildNumber;
    private final String vcsRevision;
    private final String vcsUrl;
    private ServerConfig serverConfig;

    private BuildInfoHelper(String buildName, String buildNumber, Map<String, String> env, String vcsRevision, String vcsUrl) {
        this.buildName = buildName;
        this.buildNumber = buildNumber;
        this.env = env;
        this.vcsRevision = vcsRevision;
        this.vcsUrl = vcsUrl;
    }

    private BuildInfoBuilder extractBuilder(BuildContext buildContext, BuildLogger buildLogger) {
        String principal;
        String url = this.determineBambooBaseUrl();
        StringBuilder summaryUrl = new StringBuilder(url);
        if (!url.endsWith("/")) {
            summaryUrl.append("/");
        }
        String buildUrl = summaryUrl.append("browse/").append(EscapeChars.forFormSubmission((String)buildContext.getPlanResultKey().getKey())).toString();
        DateTime start = new DateTime(buildContext.getBuildResult().getCustomBuildData().get("buildTimeStamp"));
        DateTime end = new DateTime();
        long duration = -1L;
        if (start.isBefore((ReadableInstant)end)) {
            duration = new Interval((ReadableInstant)start, (ReadableInstant)end).toDurationMillis();
        } else {
            log.warn(buildLogger.addErrorLogEntry("Agent machine time is lower than the server machine time, please synchronize them."));
        }
        BuildInfoBuilder builder = new BuildInfoBuilder(this.buildName).number(this.buildNumber).agent(new Agent("Bamboo", BuildUtils.getVersionAndBuild())).artifactoryPrincipal(this.serverConfig.getUsername()).startedDate(new Date()).durationMillis(duration).url(buildUrl);
        if (StringUtils.isNotBlank(this.vcsRevision)) {
            builder.vcsRevision(this.vcsRevision);
        }
        if (StringUtils.isNotBlank(this.vcsUrl)) {
            builder.vcsUrl(this.vcsUrl);
        }
        if (StringUtils.isBlank(principal = this.getTriggeringUserNameRecursively(buildContext))) {
            principal = "auto";
        }
        builder.principal(principal);
        return builder;
    }

    public List<Artifact> convertDeployDetailsToArtifacts(Set<DeployDetails> details) {
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        for (DeployDetails detail : details) {
            String ext = FilenameUtils.getExtension(detail.getFile().getName());
            Artifact artifact = new Artifact();
            artifact.setName(detail.getFile().getName());
            artifact.setType(ext);
            artifact.setMd5(detail.getMd5());
            artifact.setSha1(detail.getSha1());
            result.add(artifact);
        }
        return result;
    }

    public Map<String, String> getDynamicPropertyMap(BuildInfo build) {
        HashMap<String, String> filteredPropertyMap = new HashMap<String, String>();
        if (build.getProperties() != null) {
            for (Map.Entry<Object, Object> entry : build.getProperties().entrySet()) {
                String key = entry.getKey().toString();
                if (!StringUtils.startsWith(key, "deploy.")) continue;
                filteredPropertyMap.put(StringUtils.removeStart(key, "deploy."), (String)entry.getValue());
            }
        }
        return filteredPropertyMap;
    }

    public BuildInfoBuilder getBuilder(TaskContext taskContext) {
        BuildContext buildContext = taskContext.getBuildContext();
        return this.extractBuilder(buildContext, taskContext.getBuildLogger());
    }

    @NotNull
    public BuildInfo getBuild(@NotNull TaskContext taskContext, GenericContext genericContext) {
        BuildInfoBuilder builder = this.getBuilder(taskContext);
        this.addEnvVarsToBuildInfoBuilder(genericContext.isIncludeEnvVars(), genericContext.getEnvVarsIncludePatterns(), genericContext.getEnvVarsExcludePatterns(), builder);
        BuildInfo build = builder.build();
        build.setBuildAgent(new BuildAgent("Generic"));
        return build;
    }

    private void addEnvVarsToBuildInfoBuilder(boolean isIncludeEnvVars, String envVarsIncludePatterns, String envVarsExcludePatterns, BuildInfoBuilder builder) {
        if (!isIncludeEnvVars) {
            return;
        }
        HashMap<String, String> props = new HashMap<String, String>(TaskUtils.getEscapedEnvMap(this.env));
        props.putAll(this.getBuildInfoConfigPropertiesFileParams((String)props.get("buildInfoConfig.propertiesFile")));
        IncludeExcludePatterns patterns = new IncludeExcludePatterns(envVarsIncludePatterns, envVarsExcludePatterns);
        for (Map.Entry prop : props.entrySet()) {
            String varKey = (String)prop.getKey();
            if (PatternMatcher.pathConflicts(varKey, patterns)) continue;
            if (!StringUtils.startsWith(varKey, "deploy.") && !StringUtils.startsWith(varKey, "buildInfo.property.")) {
                varKey = "buildInfo.env." + varKey;
            }
            builder.addProperty(varKey, prop.getValue());
        }
    }

    public void addEnvVarsToBuild(PackageManagersContext abstractBuildContext, BuildInfo build) {
        BuildInfoBuilder temporaryBuilder = new BuildInfoBuilder("tempBuildName").number("tempBuildNumber").started("tempTimeStamp");
        this.addEnvVarsToBuildInfoBuilder(abstractBuildContext.isIncludeEnvVars(), abstractBuildContext.getEnvVarsIncludePatterns(), abstractBuildContext.getEnvVarsExcludePatterns(), temporaryBuilder);
        build.append(temporaryBuilder.build());
    }

    public void addCommonProperties(Map<String, String> propertyMap) {
        propertyMap.put("build.name", this.buildName);
        propertyMap.put("build.number", this.buildNumber);
        if (StringUtils.isNotBlank(this.vcsRevision)) {
            propertyMap.put("vcs.revision", this.vcsRevision);
        }
        if (StringUtils.isNotBlank(this.vcsUrl)) {
            propertyMap.put("vcs.url", this.vcsUrl);
        }
        String buildTimeStampVal = (String)this.context.getBuildResult().getCustomBuildData().get("buildTimeStamp");
        long buildTimeStamp = System.currentTimeMillis();
        if (StringUtils.isNotBlank(buildTimeStampVal)) {
            buildTimeStamp = new DateTime((Object)buildTimeStampVal).getMillis();
        }
        String buildTimeStampString = String.valueOf(buildTimeStamp);
        propertyMap.put("build.timestamp", buildTimeStampString);
        this.addBuildParentProperties(propertyMap, this.context.getTriggerReason());
    }

    private void addBuildParentProperties(Map<String, String> propertyMap, TriggerReason triggerReason) {
        String triggeringBuildResultKey;
        if (triggerReason instanceof DependencyTriggerReason && StringUtils.isNotBlank(triggeringBuildResultKey = ((DependencyTriggerReason)triggerReason).getTriggeringBuildResultKey()) && StringUtils.split(triggeringBuildResultKey, "-").length == 3) {
            String triggeringBuildKey = triggeringBuildResultKey.substring(0, triggeringBuildResultKey.lastIndexOf("-"));
            String triggeringBuildNumber = triggeringBuildResultKey.substring(triggeringBuildResultKey.lastIndexOf("-") + 1);
            String parentBuildName = this.getBuildName(triggeringBuildKey);
            if (StringUtils.isBlank(parentBuildName)) {
                log.error("Received a null build parent name.");
            }
            propertyMap.put("build.parentName", parentBuildName);
            propertyMap.put("build.parentNumber", triggeringBuildNumber);
        }
    }

    private static Module createModule(String buildName, String buildNumber, List<Artifact> artifacts, List<Dependency> dependencies) {
        ModuleBuilder moduleBuilder = new ModuleBuilder().id(buildName + ":" + buildNumber).artifacts(artifacts).dependencies(dependencies);
        return moduleBuilder.build();
    }

    public ArtifactoryManagerBuilder getClientBuilder(BuildLogger buildLogger, Logger logger) {
        BuildInfoLog bambooBuildInfoLog = new BuildInfoLog(logger, buildLogger);
        return TaskUtils.getArtifactoryManagerBuilderBuilder(this.serverConfig, bambooBuildInfoLog);
    }

    private static BuildInfoHelper createBuildInfoHelper(String buildName, String buildNumber, CommonTaskContext taskContext, BuildContext buildContext, EnvironmentVariableAccessor environmentVariableAccessor, BuildParamsOverrideManager buildParamsOverrideManager, ServerConfig serverConfig) {
        String[] vcsUrls;
        String vcsUrl;
        HashMap<String, String> env = new HashMap<String, String>();
        env.putAll(environmentVariableAccessor.getEnvironment(taskContext));
        env.putAll(environmentVariableAccessor.getEnvironment());
        String vcsRevision = VcsHelper.getRevisionKey(buildContext);
        if (StringUtils.isBlank(vcsRevision)) {
            vcsRevision = "";
        }
        String string = vcsUrl = (vcsUrls = VcsHelper.getVcsUrls(buildContext)).length > 0 ? vcsUrls[0] : "";
        if (serverConfig == null) {
            throw new IllegalArgumentException("Could not find Artifactory server. Please check the Artifactory server in the task configuration.");
        }
        BuildInfoHelper buildInfoHelper = new BuildInfoHelper(buildName, buildNumber, env, vcsRevision, vcsUrl);
        buildInfoHelper.init(buildParamsOverrideManager, buildContext, taskContext.getBuildLogger());
        return buildInfoHelper;
    }

    public static BuildInfoHelper createDeployBuildInfoHelper(String buildName, String buildNumber, CommonTaskContext taskContext, BuildContext buildContext, EnvironmentVariableAccessor environmentVariableAccessor, long selectedServerId, String username, String password, BuildParamsOverrideManager buildParamsOverrideManager) {
        ServerConfigManager serverConfigManager = ServerConfigManager.getInstance();
        ServerConfig selectedServerConfig = serverConfigManager.getServerConfigById(selectedServerId);
        BuildInfoHelper buildInfoHelper = BuildInfoHelper.createBuildInfoHelper(buildName, buildNumber, taskContext, buildContext, environmentVariableAccessor, buildParamsOverrideManager, selectedServerConfig);
        buildInfoHelper.serverConfig = TaskUtils.getDeploymentServerConfig(username, password, serverConfigManager, selectedServerConfig, buildParamsOverrideManager);
        return buildInfoHelper;
    }

    public static BuildInfoHelper createResolveBuildInfoHelper(String buildName, String buildNumber, CommonTaskContext taskContext, BuildContext buildContext, EnvironmentVariableAccessor environmentVariableAccessor, long selectedServerId, String username, String password, BuildParamsOverrideManager buildParamsOverrideManager) {
        ServerConfigManager serverConfigManager = ServerConfigManager.getInstance();
        ServerConfig selectedServerConfig = serverConfigManager.getServerConfigById(selectedServerId);
        BuildInfoHelper buildInfoHelper = BuildInfoHelper.createBuildInfoHelper(buildName, buildNumber, taskContext, buildContext, environmentVariableAccessor, buildParamsOverrideManager, selectedServerConfig);
        buildInfoHelper.serverConfig = TaskUtils.getResolutionServerConfig(username, password, serverConfigManager, selectedServerConfig, buildParamsOverrideManager);
        return buildInfoHelper;
    }

    public BuildInfo addBuildInfoParams(BuildInfo build, List<Artifact> artifacts, List<Dependency> dependencies, List<BuildDependency> buildDependencies) {
        Module module = BuildInfoHelper.createModule(this.buildName, this.buildNumber, artifacts, dependencies);
        build.setBuildDependencies(buildDependencies);
        build.setModules(Lists.newArrayList(module));
        return build;
    }

    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }
}

