/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.admin;

import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.admin.ServerConfigManager;

public class ArtifactoryConfigServlet
extends HttpServlet {
    private static final Logger log = LogManager.getLogger(ArtifactoryConfigServlet.class);
    private ServerConfigManager serverConfigManager;
    private final UserManager userManager;

    public ArtifactoryConfigServlet(ServerConfigManager serverConfigManager, UserManager userManager) {
        this.userManager = userManager;
        this.serverConfigManager = serverConfigManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        long serverId;
        UserProfile profile = this.userManager.getRemoteUser(req);
        if (profile == null || profile.getUserKey() == null) {
            resp.sendError(404);
            return;
        }
        String serverIdValue = req.getParameter("serverId");
        if (StringUtils.isBlank((String)serverIdValue)) {
            resp.sendError(400, "Please provide a server ID.");
            log.error("Unable to retrieve server configuration information. No server ID was provided.");
            return;
        }
        try {
            serverId = Long.parseLong(serverIdValue);
        }
        catch (NumberFormatException e) {
            resp.sendError(400, "Please provide a valid long-type server ID.");
            log.error("Unable to retrieve server configuration information. An invalid server ID was provided (" + serverIdValue + ").");
            return;
        }
        ServerConfig serverConfig = this.serverConfigManager.getServerConfigById(serverId);
        if (serverConfig == null) {
            resp.sendError(404, "Could not find an Artifactory server configuration with the ID " + serverId + ".");
            log.error("Unable to retrieve server configuration. No configuration was found with the ID " + serverId + ".");
            return;
        }
        String deployableReposValue = req.getParameter("deployableRepos");
        String resolvingReposValue = req.getParameter("resolvingRepos");
        if (StringUtils.isNotBlank((String)deployableReposValue) && Boolean.valueOf(deployableReposValue).booleanValue()) {
            List<String> deployableRepoList = this.serverConfigManager.getDeployableRepos(serverId, req, resp);
            this.returnJsonObject(resp, deployableRepoList);
        } else if (StringUtils.isNotBlank((String)resolvingReposValue) && Boolean.valueOf(resolvingReposValue).booleanValue()) {
            List<String> resolvingRepoList = this.serverConfigManager.getResolvingRepos(serverId, req, resp);
            this.returnJsonObject(resp, resolvingRepoList);
        } else {
            resp.sendError(400, "Please provide deployableRepos or resolvingRepos parameters.");
        }
    }

    private void returnJsonObject(HttpServletResponse resp, Object toReturn) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper();
        jsonFactory.setCodec(mapper);
        try (PrintWriter writer = resp.getWriter();){
            JsonGenerator jsonGenerator = jsonFactory.createJsonGenerator(writer);
            jsonGenerator.writeObject(toReturn);
            writer.flush();
        }
    }
}

