/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.attributes.Attribute;
import org.eclipse.jgit.attributes.Attributes;
import org.eclipse.jgit.attributes.AttributesHandler;
import org.eclipse.jgit.attributes.AttributesNodeProvider;
import org.eclipse.jgit.attributes.AttributesProvider;
import org.eclipse.jgit.attributes.FilterCommandRegistry;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.StopWalkException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.QuotedString;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.io.EolStreamTypeUtil;

public class TreeWalk
implements AutoCloseable,
AttributesProvider {
    private static final AbstractTreeIterator[] NO_TREES = new AbstractTreeIterator[0];
    private OperationType operationType = OperationType.CHECKOUT_OP;
    private Map<String, String> filterCommandsByNameDotType = new HashMap<String, String>();
    private final ObjectReader reader;
    private final boolean closeReader;
    private final MutableObjectId idBuffer = new MutableObjectId();
    private TreeFilter filter;
    AbstractTreeIterator[] trees;
    private boolean recursive;
    private boolean postOrderTraversal;
    int depth;
    private boolean advance;
    private boolean postChildren;
    private AttributesNodeProvider attributesNodeProvider;
    AbstractTreeIterator currentHead;
    private Attributes attrs = null;
    private AttributesHandler attributesHandler;
    private Config config;
    private Set<String> filterCommands;

    public void setOperationType(OperationType operationType) {
        this.operationType = operationType;
    }

    public static TreeWalk forPath(ObjectReader reader, String path, AnyObjectId ... trees) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        return TreeWalk.forPath(null, reader, path, trees);
    }

    public static TreeWalk forPath(@Nullable Repository repo, ObjectReader reader, String path, AnyObjectId ... trees) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        TreeWalk tw = new TreeWalk(repo, reader);
        PathFilter f = PathFilter.create(path);
        tw.setFilter(f);
        tw.reset(trees);
        tw.setRecursive(false);
        while (tw.next()) {
            if (f.isDone(tw)) {
                return tw;
            }
            if (!tw.isSubtree()) continue;
            tw.enterSubtree();
        }
        return null;
    }

    public static TreeWalk forPath(Repository db, String path, AnyObjectId ... trees) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        try (ObjectReader reader = db.newObjectReader();){
            TreeWalk treeWalk = TreeWalk.forPath(db, reader, path, trees);
            return treeWalk;
        }
    }

    public static TreeWalk forPath(Repository db, String path, RevTree tree) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        return TreeWalk.forPath(db, path, (AnyObjectId[])new ObjectId[]{tree});
    }

    public TreeWalk(Repository repo) {
        this(repo, repo.newObjectReader(), true);
    }

    public TreeWalk(@Nullable Repository repo, ObjectReader or) {
        this(repo, or, false);
    }

    public TreeWalk(ObjectReader or) {
        this(null, or, false);
    }

    private TreeWalk(@Nullable Repository repo, ObjectReader or, boolean closeReader) {
        if (repo != null) {
            this.config = repo.getConfig();
            this.attributesNodeProvider = repo.createAttributesNodeProvider();
            this.filterCommands = FilterCommandRegistry.getRegisteredFilterCommands();
        } else {
            this.config = null;
            this.attributesNodeProvider = null;
        }
        this.reader = or;
        this.filter = TreeFilter.ALL;
        this.trees = NO_TREES;
        this.closeReader = closeReader;
    }

    public ObjectReader getObjectReader() {
        return this.reader;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    @Override
    public void close() {
        if (this.closeReader) {
            this.reader.close();
        }
    }

    public TreeFilter getFilter() {
        return this.filter;
    }

    public void setFilter(TreeFilter newFilter) {
        this.filter = newFilter != null ? newFilter : TreeFilter.ALL;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean b) {
        this.recursive = b;
    }

    public boolean isPostOrderTraversal() {
        return this.postOrderTraversal;
    }

    public void setPostOrderTraversal(boolean b) {
        this.postOrderTraversal = b;
    }

    public void setAttributesNodeProvider(AttributesNodeProvider provider) {
        this.attributesNodeProvider = provider;
    }

    public AttributesNodeProvider getAttributesNodeProvider() {
        return this.attributesNodeProvider;
    }

    @Override
    public Attributes getAttributes() {
        if (this.attrs != null) {
            return this.attrs;
        }
        if (this.attributesNodeProvider == null) {
            throw new IllegalStateException("The tree walk should have one AttributesNodeProvider set in order to compute the git attributes.");
        }
        try {
            if (this.attributesHandler == null) {
                this.attributesHandler = new AttributesHandler(this);
            }
            this.attrs = this.attributesHandler.getAttributes();
            return this.attrs;
        }
        catch (IOException e) {
            throw new JGitInternalException("Error while parsing attributes", e);
        }
    }

    @Nullable
    CoreConfig.EolStreamType getEolStreamType(OperationType opType) {
        if (this.attributesNodeProvider == null || this.config == null) {
            return null;
        }
        return EolStreamTypeUtil.detectStreamType(opType, this.config.get(WorkingTreeOptions.KEY), this.getAttributes());
    }

    @Nullable
    public CoreConfig.EolStreamType getEolStreamType() {
        return this.getEolStreamType(this.operationType);
    }

    public void reset() {
        this.attrs = null;
        this.attributesHandler = null;
        this.trees = NO_TREES;
        this.advance = false;
        this.depth = 0;
    }

    public void reset(AnyObjectId id) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        if (this.trees.length == 1) {
            AbstractTreeIterator o = this.trees[0];
            while (o.parent != null) {
                o = o.parent;
            }
            if (o instanceof CanonicalTreeParser) {
                o.matches = null;
                o.matchShift = 0;
                ((CanonicalTreeParser)o).reset(this.reader, id);
                this.trees[0] = o;
            } else {
                this.trees[0] = this.parserFor(id);
            }
        } else {
            this.trees = new AbstractTreeIterator[]{this.parserFor(id)};
        }
        this.advance = false;
        this.depth = 0;
        this.attrs = null;
    }

    public void reset(AnyObjectId ... ids) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        int newLen = ids.length;
        int oldLen = this.trees.length;
        AbstractTreeIterator[] r = newLen == oldLen ? this.trees : new AbstractTreeIterator[newLen];
        for (int i = 0; i < newLen; ++i) {
            AbstractTreeIterator o;
            if (i < oldLen) {
                o = this.trees[i];
                while (o.parent != null) {
                    o = o.parent;
                }
                if (o instanceof CanonicalTreeParser && o.pathOffset == 0) {
                    o.matches = null;
                    o.matchShift = 0;
                    ((CanonicalTreeParser)o).reset(this.reader, ids[i]);
                    r[i] = o;
                    continue;
                }
            }
            r[i] = o = this.parserFor(ids[i]);
        }
        this.trees = r;
        this.advance = false;
        this.depth = 0;
        this.attrs = null;
    }

    public int addTree(AnyObjectId id) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        return this.addTree(this.parserFor(id));
    }

    public int addTree(AbstractTreeIterator p) {
        int n = this.trees.length;
        AbstractTreeIterator[] newTrees = new AbstractTreeIterator[n + 1];
        System.arraycopy(this.trees, 0, newTrees, 0, n);
        newTrees[n] = p;
        p.matches = null;
        p.matchShift = 0;
        this.trees = newTrees;
        return n;
    }

    public int getTreeCount() {
        return this.trees.length;
    }

    public boolean next() throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        try {
            if (this.advance) {
                this.advance = false;
                this.postChildren = false;
                this.popEntriesEqual();
            }
            while (true) {
                this.attrs = null;
                AbstractTreeIterator t2 = this.min();
                if (t2.eof()) {
                    if (this.depth > 0) {
                        this.exitSubtree();
                        if (this.postOrderTraversal) {
                            this.advance = true;
                            this.postChildren = true;
                            return true;
                        }
                        this.popEntriesEqual();
                        continue;
                    }
                    return false;
                }
                this.currentHead = t2;
                if (this.filter.matchFilter(this) == 1) {
                    this.skipEntriesEqual();
                    continue;
                }
                if (!this.recursive || !FileMode.TREE.equals(t2.mode)) break;
                this.enterSubtree();
            }
            this.advance = true;
            return true;
        }
        catch (StopWalkException stop) {
            this.stopWalk();
            return false;
        }
    }

    void stopWalk() throws IOException {
        for (AbstractTreeIterator t2 : this.trees) {
            t2.stopWalk();
        }
    }

    public <T extends AbstractTreeIterator> T getTree(int nth, Class<T> clazz) {
        AbstractTreeIterator t2 = this.trees[nth];
        return (T)(t2.matches == this.currentHead ? t2 : null);
    }

    public int getRawMode(int nth) {
        AbstractTreeIterator t2 = this.trees[nth];
        return t2.matches == this.currentHead ? t2.mode : 0;
    }

    public FileMode getFileMode(int nth) {
        return FileMode.fromBits(this.getRawMode(nth));
    }

    public FileMode getFileMode() {
        return FileMode.fromBits(this.currentHead.mode);
    }

    public ObjectId getObjectId(int nth) {
        AbstractTreeIterator t2 = this.trees[nth];
        return t2.matches == this.currentHead ? t2.getEntryObjectId() : ObjectId.zeroId();
    }

    public void getObjectId(MutableObjectId out, int nth) {
        AbstractTreeIterator t2 = this.trees[nth];
        if (t2.matches == this.currentHead) {
            t2.getEntryObjectId(out);
        } else {
            out.clear();
        }
    }

    public boolean idEqual(int nthA, int nthB) {
        AbstractTreeIterator ch = this.currentHead;
        AbstractTreeIterator a = this.trees[nthA];
        AbstractTreeIterator b = this.trees[nthB];
        if (a.matches != ch && b.matches != ch) {
            return true;
        }
        if (!a.hasId() || !b.hasId()) {
            return false;
        }
        if (a.matches == ch && b.matches == ch) {
            return a.idEqual(b);
        }
        return false;
    }

    public String getNameString() {
        AbstractTreeIterator t2 = this.currentHead;
        int off = t2.pathOffset;
        int end = t2.pathLen;
        return RawParseUtils.decode(Constants.CHARSET, t2.path, off, end);
    }

    public String getPathString() {
        return TreeWalk.pathOf(this.currentHead);
    }

    public byte[] getRawPath() {
        AbstractTreeIterator t2 = this.currentHead;
        int n = t2.pathLen;
        byte[] r = new byte[n];
        System.arraycopy(t2.path, 0, r, 0, n);
        return r;
    }

    public int getPathLength() {
        return this.currentHead.pathLen;
    }

    public int isPathMatch(byte[] p, int pLen) {
        int ci;
        AbstractTreeIterator t2 = this.currentHead;
        byte[] c = t2.path;
        int cLen = t2.pathLen;
        for (ci = 0; ci < cLen && ci < pLen; ++ci) {
            int c_value = (c[ci] & 0xFF) - (p[ci] & 0xFF);
            if (c_value == 0) continue;
            return 1;
        }
        if (ci < cLen) {
            return c[ci] == 47 ? 0 : 1;
        }
        if (ci < pLen) {
            return p[ci] == 47 && FileMode.TREE.equals(t2.mode) ? -1 : 1;
        }
        return 0;
    }

    public int isPathPrefix(byte[] p, int pLen) {
        int ci;
        AbstractTreeIterator t2 = this.currentHead;
        byte[] c = t2.path;
        int cLen = t2.pathLen;
        for (ci = 0; ci < cLen && ci < pLen; ++ci) {
            int c_value = (c[ci] & 0xFF) - (p[ci] & 0xFF);
            if (c_value == 0) continue;
            return c_value;
        }
        if (ci < cLen) {
            return c[ci] == 47 ? 0 : -1;
        }
        if (ci < pLen) {
            return p[ci] == 47 && FileMode.TREE.equals(t2.mode) ? 0 : -1;
        }
        return 0;
    }

    public boolean isPathSuffix(byte[] p, int pLen) {
        AbstractTreeIterator t2 = this.currentHead;
        byte[] c = t2.path;
        int cLen = t2.pathLen;
        for (int i = 1; i <= pLen; ++i) {
            if (i > cLen) {
                return false;
            }
            if (c[cLen - i] == p[pLen - i]) continue;
            return false;
        }
        return true;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean isSubtree() {
        return FileMode.TREE.equals(this.currentHead.mode);
    }

    public boolean isPostChildren() {
        return this.postChildren && this.isSubtree();
    }

    public void enterSubtree() throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        this.attrs = null;
        AbstractTreeIterator ch = this.currentHead;
        AbstractTreeIterator[] tmp = new AbstractTreeIterator[this.trees.length];
        for (int i = 0; i < this.trees.length; ++i) {
            AbstractTreeIterator t2 = this.trees[i];
            AbstractTreeIterator n = t2.matches == ch && !t2.eof() && (FileMode.TREE.equals(t2.mode) || FileMode.GITLINK.equals(t2.mode) && t2.isWorkTree()) ? t2.createSubtreeIterator(this.reader, this.idBuffer) : t2.createEmptyTreeIterator();
            tmp[i] = n;
        }
        ++this.depth;
        this.advance = false;
        System.arraycopy(tmp, 0, this.trees, 0, this.trees.length);
    }

    AbstractTreeIterator min() throws CorruptObjectException {
        int i = 0;
        AbstractTreeIterator minRef = this.trees[i];
        while (minRef.eof() && ++i < this.trees.length) {
            minRef = this.trees[i];
        }
        if (minRef.eof()) {
            return minRef;
        }
        minRef.matches = minRef;
        while (++i < this.trees.length) {
            AbstractTreeIterator t2 = this.trees[i];
            if (t2.eof()) continue;
            int cmp = t2.pathCompare(minRef);
            if (cmp < 0) {
                t2.matches = t2;
                minRef = t2;
                continue;
            }
            if (cmp != 0) continue;
            t2.matches = minRef;
        }
        return minRef;
    }

    void popEntriesEqual() throws CorruptObjectException {
        AbstractTreeIterator ch = this.currentHead;
        for (int i = 0; i < this.trees.length; ++i) {
            AbstractTreeIterator t2 = this.trees[i];
            if (t2.matches != ch) continue;
            t2.next(1);
            t2.matches = null;
        }
    }

    void skipEntriesEqual() throws CorruptObjectException {
        AbstractTreeIterator ch = this.currentHead;
        for (int i = 0; i < this.trees.length; ++i) {
            AbstractTreeIterator t2 = this.trees[i];
            if (t2.matches != ch) continue;
            t2.skip();
            t2.matches = null;
        }
    }

    void exitSubtree() {
        --this.depth;
        for (int i = 0; i < this.trees.length; ++i) {
            this.trees[i] = this.trees[i].parent;
        }
        AbstractTreeIterator minRef = null;
        for (AbstractTreeIterator t2 : this.trees) {
            if (t2.matches != t2 || minRef != null && t2.pathCompare(minRef) >= 0) continue;
            minRef = t2;
        }
        this.currentHead = minRef;
    }

    private CanonicalTreeParser parserFor(AnyObjectId id) throws IncorrectObjectTypeException, IOException {
        CanonicalTreeParser p = new CanonicalTreeParser();
        p.reset(this.reader, id);
        return p;
    }

    static String pathOf(AbstractTreeIterator t2) {
        return RawParseUtils.decode(Constants.CHARSET, t2.path, 0, t2.pathLen);
    }

    static String pathOf(byte[] buf, int pos, int end) {
        return RawParseUtils.decode(Constants.CHARSET, buf, pos, end);
    }

    public <T extends AbstractTreeIterator> T getTree(Class<T> type) {
        for (int i = 0; i < this.trees.length; ++i) {
            AbstractTreeIterator tree = this.trees[i];
            if (!type.isInstance(tree)) continue;
            return (T)((AbstractTreeIterator)type.cast(tree));
        }
        return null;
    }

    public String getFilterCommand(String filterCommandType) throws IOException {
        Attributes attributes = this.getAttributes();
        Attribute f = attributes.get("filter");
        if (f == null) {
            return null;
        }
        String filterValue = f.getValue();
        if (filterValue == null) {
            return null;
        }
        String filterCommand = this.getFilterCommandDefinition(filterValue, filterCommandType);
        if (filterCommand == null) {
            return null;
        }
        return filterCommand.replaceAll("%f", QuotedString.BOURNE.quote(this.getPathString()));
    }

    private String getFilterCommandDefinition(String filterDriverName, String filterCommandType) {
        String key = filterDriverName + "." + filterCommandType;
        String filterCommand = this.filterCommandsByNameDotType.get(key);
        if (filterCommand != null) {
            return filterCommand;
        }
        filterCommand = this.config.getString("filter", filterDriverName, filterCommandType);
        boolean useBuiltin = this.config.getBoolean("filter", filterDriverName, "useJGitBuiltin", false);
        if (useBuiltin) {
            String builtinFilterCommand = "jgit://builtin/" + filterDriverName + '/' + filterCommandType;
            if (this.filterCommands != null && this.filterCommands.contains(builtinFilterCommand)) {
                filterCommand = builtinFilterCommand;
            }
        }
        if (filterCommand != null) {
            this.filterCommandsByNameDotType.put(key, filterCommand);
        }
        return filterCommand;
    }

    public static enum OperationType {
        CHECKOUT_OP,
        CHECKIN_OP;

    }
}

