/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk;

import java.io.IOException;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;

public class NameConflictTreeWalk
extends TreeWalk {
    private static final int TREE_MODE = FileMode.TREE.getBits();
    private boolean fastMinHasMatch;
    private AbstractTreeIterator dfConflict;

    public NameConflictTreeWalk(Repository repo) {
        super(repo);
    }

    public NameConflictTreeWalk(@Nullable Repository repo, ObjectReader or) {
        super(repo, or);
    }

    public NameConflictTreeWalk(ObjectReader or) {
        super(or);
    }

    @Override
    AbstractTreeIterator min() throws CorruptObjectException {
        AbstractTreeIterator minRef;
        block4: {
            block0: while (true) {
                minRef = this.fastMin();
                if (this.fastMinHasMatch) {
                    return minRef;
                }
                if (!NameConflictTreeWalk.isTree(minRef)) break block4;
                if (!this.skipEntry(minRef)) break;
                AbstractTreeIterator[] abstractTreeIteratorArray = this.trees;
                int n = abstractTreeIteratorArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block0;
                    AbstractTreeIterator t2 = abstractTreeIteratorArray[n2];
                    if (t2.matches == minRef) {
                        t2.next(1);
                        t2.matches = null;
                    }
                    ++n2;
                }
                break;
            }
            return minRef;
        }
        return this.combineDF(minRef);
    }

    private AbstractTreeIterator fastMin() {
        this.fastMinHasMatch = true;
        int i = 0;
        AbstractTreeIterator minRef = this.trees[i];
        while (minRef.eof() && ++i < this.trees.length) {
            minRef = this.trees[i];
        }
        if (minRef.eof()) {
            return minRef;
        }
        boolean hasConflict = false;
        minRef.matches = minRef;
        while (++i < this.trees.length) {
            AbstractTreeIterator t2 = this.trees[i];
            if (t2.eof()) continue;
            int cmp = t2.pathCompare(minRef);
            if (cmp < 0) {
                if (this.fastMinHasMatch && NameConflictTreeWalk.isTree(minRef) && !NameConflictTreeWalk.isTree(t2) && NameConflictTreeWalk.nameEqual(minRef, t2)) {
                    t2.matches = minRef;
                    hasConflict = true;
                    continue;
                }
                this.fastMinHasMatch = false;
                t2.matches = t2;
                minRef = t2;
                continue;
            }
            if (cmp == 0) {
                t2.matches = minRef;
                continue;
            }
            if (this.fastMinHasMatch && NameConflictTreeWalk.isTree(t2) && !NameConflictTreeWalk.isTree(minRef) && NameConflictTreeWalk.nameEqual(t2, minRef)) {
                for (int k = 0; k < i; ++k) {
                    AbstractTreeIterator p = this.trees[k];
                    if (p.matches != minRef) continue;
                    p.matches = t2;
                }
                t2.matches = t2;
                minRef = t2;
                hasConflict = true;
                continue;
            }
            this.fastMinHasMatch = false;
        }
        if (hasConflict && this.fastMinHasMatch && this.dfConflict == null) {
            this.dfConflict = minRef;
        }
        return minRef;
    }

    private static boolean nameEqual(AbstractTreeIterator a, AbstractTreeIterator b) {
        return a.pathCompare(b, TREE_MODE) == 0;
    }

    private static boolean isTree(AbstractTreeIterator p) {
        return FileMode.TREE.equals(p.mode);
    }

    private boolean skipEntry(AbstractTreeIterator minRef) throws CorruptObjectException {
        for (AbstractTreeIterator t2 : this.trees) {
            int cmp;
            if (t2.matches == minRef || t2.first()) continue;
            int stepsBack = 0;
            do {
                ++stepsBack;
                t2.back(1);
                cmp = t2.pathCompare(minRef, 0);
                if (cmp != 0) continue;
                t2.next(stepsBack);
                return true;
            } while (cmp >= 0 && !t2.first());
            t2.next(stepsBack);
        }
        return false;
    }

    private AbstractTreeIterator combineDF(AbstractTreeIterator minRef) throws CorruptObjectException {
        AbstractTreeIterator treeMatch = null;
        block0: for (AbstractTreeIterator t2 : this.trees) {
            int cmp;
            if (t2.matches == minRef || t2.eof()) continue;
            while ((cmp = t2.pathCompare(minRef, TREE_MODE)) < 0) {
                ++t2.matchShift;
                t2.next(1);
                if (!t2.eof()) continue;
                t2.back(t2.matchShift);
                t2.matchShift = 0;
                continue block0;
            }
            if (cmp == 0) {
                t2.matches = minRef;
                treeMatch = t2;
                continue;
            }
            if (t2.matchShift == 0) continue;
            t2.back(t2.matchShift);
            t2.matchShift = 0;
        }
        if (treeMatch != null) {
            for (AbstractTreeIterator t2 : this.trees) {
                if (t2.matches != minRef) continue;
                t2.matches = treeMatch;
            }
            if (this.dfConflict == null) {
                this.dfConflict = treeMatch;
            }
            return treeMatch;
        }
        return minRef;
    }

    @Override
    void popEntriesEqual() throws CorruptObjectException {
        AbstractTreeIterator ch = this.currentHead;
        for (int i = 0; i < this.trees.length; ++i) {
            AbstractTreeIterator t2 = this.trees[i];
            if (t2.matches != ch) continue;
            if (t2.matchShift == 0) {
                t2.next(1);
            } else {
                t2.back(t2.matchShift);
                t2.matchShift = 0;
            }
            t2.matches = null;
        }
        if (ch == this.dfConflict) {
            this.dfConflict = null;
        }
    }

    @Override
    void skipEntriesEqual() throws CorruptObjectException {
        AbstractTreeIterator ch = this.currentHead;
        for (int i = 0; i < this.trees.length; ++i) {
            AbstractTreeIterator t2 = this.trees[i];
            if (t2.matches != ch) continue;
            if (t2.matchShift == 0) {
                t2.skip();
            } else {
                t2.back(t2.matchShift);
                t2.matchShift = 0;
            }
            t2.matches = null;
        }
        if (ch == this.dfConflict) {
            this.dfConflict = null;
        }
    }

    @Override
    void stopWalk() throws IOException {
        if (!this.needsStopWalk()) {
            return;
        }
        while (true) {
            AbstractTreeIterator t2;
            if ((t2 = this.min()).eof()) {
                if (this.depth > 0) {
                    this.exitSubtree();
                    this.popEntriesEqual();
                    continue;
                }
                return;
            }
            this.currentHead = t2;
            this.skipEntriesEqual();
        }
    }

    private boolean needsStopWalk() {
        for (AbstractTreeIterator t2 : this.trees) {
            if (!t2.needsStopWalk()) continue;
            return true;
        }
        return false;
    }

    public boolean isDirectoryFileConflict() {
        return this.dfConflict != null;
    }
}

