/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URL;
import java.net.URLConnection;
import java.security.DigestOutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.transport.WalkEncryption;
import org.eclipse.jgit.util.Base64;
import org.eclipse.jgit.util.HttpSupport;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class AmazonS3 {
    private static final Set<String> SIGNED_HEADERS = new HashSet<String>();
    private static final String HMAC = "HmacSHA1";
    private static final String X_AMZ_ACL = "x-amz-acl";
    private static final String X_AMZ_META = "x-amz-meta-";
    private final String publicKey;
    private final SecretKeySpec privateKey;
    private final ProxySelector proxySelector;
    private final String acl;
    final int maxAttempts;
    private final WalkEncryption encryption;
    private final File tmpDir;
    private final String domain;

    private static boolean isSignedHeader(String name) {
        String nameLC = StringUtils.toLowerCase(name);
        return SIGNED_HEADERS.contains(nameLC) || nameLC.startsWith("x-amz-");
    }

    private static String toCleanString(List<String> list) {
        StringBuilder s2 = new StringBuilder();
        for (String v : list) {
            if (s2.length() > 0) {
                s2.append(',');
            }
            s2.append(v.replaceAll("\n", "").trim());
        }
        return s2.toString();
    }

    private static String remove(Map<String, String> m4, String k) {
        String r = m4.remove(k);
        return r != null ? r : "";
    }

    private static String httpNow() {
        String tz = "GMT";
        SimpleDateFormat fmt = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss", Locale.US);
        fmt.setTimeZone(TimeZone.getTimeZone("GMT"));
        return fmt.format(new Date()) + " " + "GMT";
    }

    private static MessageDigest newMD5() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(JGitText.get().JRELacksMD5Implementation, e);
        }
    }

    public AmazonS3(Properties props) {
        this.domain = props.getProperty("domain", "s3.amazonaws.com");
        this.publicKey = props.getProperty("accesskey");
        if (this.publicKey == null) {
            throw new IllegalArgumentException(JGitText.get().missingAccesskey);
        }
        String secret = props.getProperty("secretkey");
        if (secret == null) {
            throw new IllegalArgumentException(JGitText.get().missingSecretkey);
        }
        this.privateKey = new SecretKeySpec(Constants.encodeASCII(secret), HMAC);
        String pacl = props.getProperty("acl", "PRIVATE");
        if (StringUtils.equalsIgnoreCase("PRIVATE", pacl)) {
            this.acl = "private";
        } else if (StringUtils.equalsIgnoreCase("PUBLIC", pacl)) {
            this.acl = "public-read";
        } else if (StringUtils.equalsIgnoreCase("PUBLIC-READ", pacl)) {
            this.acl = "public-read";
        } else if (StringUtils.equalsIgnoreCase("PUBLIC_READ", pacl)) {
            this.acl = "public-read";
        } else {
            throw new IllegalArgumentException("Invalid acl: " + pacl);
        }
        try {
            this.encryption = WalkEncryption.instance(props);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException(JGitText.get().invalidEncryption, e);
        }
        this.maxAttempts = Integer.parseInt(props.getProperty("httpclient.retry-max", "3"));
        this.proxySelector = ProxySelector.getDefault();
        String tmp = props.getProperty("tmpdir");
        this.tmpDir = tmp != null && tmp.length() > 0 ? new File(tmp) : null;
    }

    public URLConnection get(String bucket, String key) throws IOException {
        block5: for (int curAttempt = 0; curAttempt < this.maxAttempts; ++curAttempt) {
            HttpURLConnection c = this.open("GET", bucket, key);
            this.authorize(c);
            switch (HttpSupport.response(c)) {
                case 200: {
                    this.encryption.validate(c, X_AMZ_META);
                    return c;
                }
                case 404: {
                    throw new FileNotFoundException(key);
                }
                case 500: {
                    continue block5;
                }
                default: {
                    throw this.error(JGitText.get().s3ActionReading, key, c);
                }
            }
        }
        throw this.maxAttempts(JGitText.get().s3ActionReading, key);
    }

    public InputStream decrypt(URLConnection u) throws IOException {
        return this.encryption.decrypt(u.getInputStream());
    }

    public List<String> list(String bucket, String prefix) throws IOException {
        if (prefix.length() > 0 && !prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        ListParser lp = new ListParser(bucket, prefix);
        do {
            lp.list();
        } while (lp.truncated);
        return lp.entries;
    }

    public void delete(String bucket, String key) throws IOException {
        block4: for (int curAttempt = 0; curAttempt < this.maxAttempts; ++curAttempt) {
            HttpURLConnection c = this.open("DELETE", bucket, key);
            this.authorize(c);
            switch (HttpSupport.response(c)) {
                case 204: {
                    return;
                }
                case 500: {
                    continue block4;
                }
                default: {
                    throw this.error(JGitText.get().s3ActionDeletion, key, c);
                }
            }
        }
        throw this.maxAttempts(JGitText.get().s3ActionDeletion, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String bucket, String key, byte[] data) throws IOException {
        if (this.encryption != WalkEncryption.NONE) {
            OutputStream os = this.beginPut(bucket, key, null, null);
            os.write(data);
            os.close();
            return;
        }
        String md5str = Base64.encodeBytes(AmazonS3.newMD5().digest(data));
        String lenstr = String.valueOf(data.length);
        block7: for (int curAttempt = 0; curAttempt < this.maxAttempts; ++curAttempt) {
            HttpURLConnection c = this.open("PUT", bucket, key);
            c.setRequestProperty("Content-Length", lenstr);
            c.setRequestProperty("Content-MD5", md5str);
            c.setRequestProperty(X_AMZ_ACL, this.acl);
            this.authorize(c);
            c.setDoOutput(true);
            c.setFixedLengthStreamingMode(data.length);
            try (OutputStream os = c.getOutputStream();){
                os.write(data);
            }
            switch (HttpSupport.response(c)) {
                case 200: {
                    return;
                }
                case 500: {
                    continue block7;
                }
                default: {
                    throw this.error(JGitText.get().s3ActionWriting, key, c);
                }
            }
        }
        throw this.maxAttempts(JGitText.get().s3ActionWriting, key);
    }

    public OutputStream beginPut(final String bucket, final String key, final ProgressMonitor monitor, final String monitorTask) throws IOException {
        final MessageDigest md5 = AmazonS3.newMD5();
        TemporaryBuffer.LocalFile buffer = new TemporaryBuffer.LocalFile(this.tmpDir){

            @Override
            public void close() throws IOException {
                super.close();
                try {
                    AmazonS3.this.putImpl(bucket, key, md5.digest(), this, monitor, monitorTask);
                }
                finally {
                    this.destroy();
                }
            }
        };
        return this.encryption.encrypt(new DigestOutputStream(buffer, md5));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putImpl(String bucket, String key, byte[] csum, TemporaryBuffer buf, ProgressMonitor monitor, String monitorTask) throws IOException {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        if (monitorTask == null) {
            monitorTask = MessageFormat.format(JGitText.get().progressMonUploading, key);
        }
        String md5str = Base64.encodeBytes(csum);
        long len = buf.length();
        block7: for (int curAttempt = 0; curAttempt < this.maxAttempts; ++curAttempt) {
            HttpURLConnection c = this.open("PUT", bucket, key);
            c.setFixedLengthStreamingMode(len);
            c.setRequestProperty("Content-MD5", md5str);
            c.setRequestProperty(X_AMZ_ACL, this.acl);
            this.encryption.request(c, X_AMZ_META);
            this.authorize(c);
            c.setDoOutput(true);
            monitor.beginTask(monitorTask, (int)(len / 1024L));
            OutputStream os = c.getOutputStream();
            try {
                buf.writeTo(os, monitor);
            }
            finally {
                monitor.endTask();
                os.close();
            }
            switch (HttpSupport.response(c)) {
                case 200: {
                    return;
                }
                case 500: {
                    continue block7;
                }
                default: {
                    throw this.error(JGitText.get().s3ActionWriting, key, c);
                }
            }
        }
        throw this.maxAttempts(JGitText.get().s3ActionWriting, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IOException error(String action, String key, HttpURLConnection c) throws IOException {
        IOException err = new IOException(MessageFormat.format(JGitText.get().amazonS3ActionFailed, action, key, HttpSupport.response(c), c.getResponseMessage()));
        InputStream errorStream = c.getErrorStream();
        if (errorStream == null) {
            return err;
        }
        try {
            int n;
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            byte[] buf = new byte[2048];
            while ((n = errorStream.read(buf)) >= 0) {
                if (n <= 0) continue;
                b.write(buf, 0, n);
            }
            buf = b.toByteArray();
            if (buf.length > 0) {
                err.initCause(new IOException("\n" + new String(buf)));
            }
        }
        finally {
            errorStream.close();
        }
        return err;
    }

    IOException maxAttempts(String action, String key) {
        return new IOException(MessageFormat.format(JGitText.get().amazonS3ActionFailedGivingUp, action, key, this.maxAttempts));
    }

    private HttpURLConnection open(String method, String bucket, String key) throws IOException {
        Map<String, String> noArgs = Collections.emptyMap();
        return this.open(method, bucket, key, noArgs);
    }

    HttpURLConnection open(String method, String bucket, String key, Map<String, String> args) throws IOException {
        StringBuilder urlstr = new StringBuilder();
        urlstr.append("http://");
        urlstr.append(bucket);
        urlstr.append('.');
        urlstr.append(this.domain);
        urlstr.append('/');
        if (key.length() > 0) {
            HttpSupport.encode(urlstr, key);
        }
        if (!args.isEmpty()) {
            urlstr.append('?');
            Iterator<Map.Entry<String, String>> i = args.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, String> e = i.next();
                urlstr.append(e.getKey());
                urlstr.append('=');
                HttpSupport.encode(urlstr, e.getValue());
                if (!i.hasNext()) continue;
                urlstr.append('&');
            }
        }
        URL url = new URL(urlstr.toString());
        Proxy proxy = HttpSupport.proxyFor(this.proxySelector, url);
        HttpURLConnection c = (HttpURLConnection)url.openConnection(proxy);
        c.setRequestMethod(method);
        c.setRequestProperty("User-Agent", "jgit/1.0");
        c.setRequestProperty("Date", AmazonS3.httpNow());
        return c;
    }

    void authorize(HttpURLConnection c) throws IOException {
        String string;
        Map<String, List<String>> reqHdr = c.getRequestProperties();
        TreeMap<String, String> sigHdr = new TreeMap<String, String>();
        for (Map.Entry<String, List<String>> entry : reqHdr.entrySet()) {
            String string2 = entry.getKey();
            if (!AmazonS3.isSignedHeader(string2)) continue;
            sigHdr.put(StringUtils.toLowerCase(string2), AmazonS3.toCleanString(entry.getValue()));
        }
        StringBuilder s2 = new StringBuilder();
        s2.append(c.getRequestMethod());
        s2.append('\n');
        s2.append(AmazonS3.remove(sigHdr, "content-md5"));
        s2.append('\n');
        s2.append(AmazonS3.remove(sigHdr, "content-type"));
        s2.append('\n');
        s2.append(AmazonS3.remove(sigHdr, "date"));
        s2.append('\n');
        for (Map.Entry entry : sigHdr.entrySet()) {
            s2.append((String)entry.getKey());
            s2.append(':');
            s2.append((String)entry.getValue());
            s2.append('\n');
        }
        String host = c.getURL().getHost();
        s2.append('/');
        s2.append(host.substring(0, host.length() - this.domain.length() - 1));
        s2.append(c.getURL().getPath());
        try {
            Mac m4 = Mac.getInstance(HMAC);
            m4.init(this.privateKey);
            string = Base64.encodeBytes(m4.doFinal(s2.toString().getBytes("UTF-8")));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(MessageFormat.format(JGitText.get().noHMACsupport, HMAC, e.getMessage()));
        }
        catch (InvalidKeyException e) {
            throw new IOException(MessageFormat.format(JGitText.get().invalidKey, e.getMessage()));
        }
        c.setRequestProperty("Authorization", "AWS " + this.publicKey + ":" + string);
    }

    static Properties properties(File authFile) throws FileNotFoundException, IOException {
        Properties p = new Properties();
        try (FileInputStream in = new FileInputStream(authFile);){
            p.load(in);
        }
        return p;
    }

    static {
        SIGNED_HEADERS.add("content-type");
        SIGNED_HEADERS.add("content-md5");
        SIGNED_HEADERS.add("date");
    }

    static interface Keys {
        public static final String ACCESS_KEY = "accesskey";
        public static final String SECRET_KEY = "secretkey";
        public static final String PASSWORD = "password";
        public static final String CRYPTO_ALG = "crypto.algorithm";
        public static final String CRYPTO_VER = "crypto.version";
        public static final String ACL = "acl";
        public static final String DOMAIN = "domain";
        public static final String HTTP_RETRY = "httpclient.retry-max";
        public static final String TMP_DIR = "tmpdir";
    }

    private final class ListParser
    extends DefaultHandler {
        final List<String> entries = new ArrayList<String>();
        private final String bucket;
        private final String prefix;
        boolean truncated;
        private StringBuilder data;

        ListParser(String bn, String p) {
            this.bucket = bn;
            this.prefix = p;
        }

        void list() throws IOException {
            TreeMap<String, String> args = new TreeMap<String, String>();
            if (this.prefix.length() > 0) {
                args.put("prefix", this.prefix);
            }
            if (!this.entries.isEmpty()) {
                args.put("marker", this.prefix + this.entries.get(this.entries.size() - 1));
            }
            block11: for (int curAttempt = 0; curAttempt < AmazonS3.this.maxAttempts; ++curAttempt) {
                HttpURLConnection c = AmazonS3.this.open("GET", this.bucket, "", args);
                AmazonS3.this.authorize(c);
                switch (HttpSupport.response(c)) {
                    case 200: {
                        XMLReader xr;
                        this.truncated = false;
                        this.data = null;
                        try {
                            xr = XMLReaderFactory.createXMLReader();
                        }
                        catch (SAXException e) {
                            throw new IOException(JGitText.get().noXMLParserAvailable);
                        }
                        xr.setContentHandler(this);
                        try (InputStream in = c.getInputStream();){
                            xr.parse(new InputSource(in));
                        }
                        return;
                    }
                    case 500: {
                        continue block11;
                    }
                    default: {
                        throw AmazonS3.this.error("Listing", this.prefix, c);
                    }
                }
            }
            throw AmazonS3.this.maxAttempts("Listing", this.prefix);
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes attributes) throws SAXException {
            if ("Key".equals(name) || "IsTruncated".equals(name)) {
                this.data = new StringBuilder();
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int s2, int n) throws SAXException {
            if (this.data != null) {
                this.data.append(ch, s2, n);
            }
        }

        @Override
        public void characters(char[] ch, int s2, int n) throws SAXException {
            if (this.data != null) {
                this.data.append(ch, s2, n);
            }
        }

        @Override
        public void endElement(String uri, String name, String qName) throws SAXException {
            if ("Key".equals(name)) {
                this.entries.add(this.data.toString().substring(this.prefix.length()));
            } else if ("IsTruncated".equals(name)) {
                this.truncated = StringUtils.equalsIgnoreCase("true", this.data.toString());
            }
            this.data = null;
        }
    }
}

