/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.matcher;

import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.matcher.PatternMatcher;

public final class MatcherHelper {
    private MatcherHelper() {
    }

    public static boolean matches(PatternMatcher m4, String expression, String input) {
        return m4.getMatcher(expression).matches(input);
    }

    public static boolean matches(PatternMatcher m4, ModuleId exp, ModuleId mid) {
        return MatcherHelper.matches(m4, exp.getOrganisation(), mid.getOrganisation()) && MatcherHelper.matches(m4, exp.getName(), mid.getName());
    }

    public static boolean matches(PatternMatcher m4, ModuleRevisionId exp, ModuleRevisionId mrid) {
        return MatcherHelper.matches(m4, exp.getOrganisation(), mrid.getOrganisation()) && MatcherHelper.matches(m4, exp.getName(), mrid.getName()) && MatcherHelper.matches(m4, exp.getRevision(), mrid.getRevision());
    }

    public static boolean matches(PatternMatcher m4, ArtifactId exp, ArtifactId aid) {
        return MatcherHelper.matches(m4, exp.getModuleId(), aid.getModuleId()) && MatcherHelper.matches(m4, exp.getName(), aid.getName()) && MatcherHelper.matches(m4, exp.getExt(), aid.getExt()) && MatcherHelper.matches(m4, exp.getType(), aid.getType());
    }

    public static boolean isExact(PatternMatcher m4, ModuleRevisionId exp) {
        return MatcherHelper.isExact(m4, exp.getOrganisation()) && MatcherHelper.isExact(m4, exp.getName()) && MatcherHelper.isExact(m4, exp.getRevision());
    }

    public static boolean isExact(PatternMatcher m4, ModuleId exp) {
        return MatcherHelper.isExact(m4, exp.getOrganisation()) && MatcherHelper.isExact(m4, exp.getName());
    }

    public static boolean isExact(PatternMatcher m4, String exp) {
        return m4.getMatcher(exp).isExact();
    }
}

