/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.resolve;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.event.resolve.EndResolveDependencyEvent;
import org.apache.ivy.core.event.resolve.StartResolveDependencyEvent;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.IncludeRule;
import org.apache.ivy.core.module.descriptor.MDArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ArtifactRevisionId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.IvyNodeBlacklist;
import org.apache.ivy.core.resolve.IvyNodeCallers;
import org.apache.ivy.core.resolve.IvyNodeEviction;
import org.apache.ivy.core.resolve.IvyNodeUsage;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolveEngine;
import org.apache.ivy.core.resolve.ResolveEngineSettings;
import org.apache.ivy.core.resolve.ResolveProcessException;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.matcher.MatcherHelper;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.StringUtils;
import org.apache.ivy.util.filter.Filter;
import org.apache.ivy.util.filter.FilterHelper;

public class IvyNode
implements Comparable<IvyNode> {
    private static final Pattern FALLBACK_CONF_PATTERN = Pattern.compile("(.+)\\((.*)\\)");
    private ResolveData data;
    private ResolveEngineSettings settings;
    private IvyNodeCallers callers;
    private IvyNodeEviction eviction;
    private IvyNode root;
    private ModuleRevisionId id;
    private Map<IvyNode, DependencyDescriptor> dds = new HashMap<IvyNode, DependencyDescriptor>();
    private ModuleDescriptor md;
    private ResolvedModuleRevision module;
    private Exception problem = null;
    private boolean downloaded = false;
    private boolean searched = false;
    private Collection<String> confsToFetch = new HashSet<String>();
    private Collection<String> fetchedConfigurations = new HashSet<String>();
    private Collection<String> loadedRootModuleConfs = new HashSet<String>();
    private IvyNodeUsage usage = new IvyNodeUsage(this);
    private Map<ModuleRevisionId, IvyNodeUsage> mergedUsages = new LinkedHashMap<ModuleRevisionId, IvyNodeUsage>();

    public IvyNode(ResolveData data, IvyNode parent, DependencyDescriptor dd) {
        this.id = dd.getDependencyRevisionId();
        this.dds.put(parent, dd);
        this.root = parent.getRoot();
        this.init(data);
    }

    public IvyNode(ResolveData data, ModuleDescriptor md) {
        this.id = md.getModuleRevisionId();
        this.md = md;
        this.root = this;
        this.init(data);
    }

    private void init(ResolveData data) {
        this.data = data;
        this.settings = data.getSettings();
        this.eviction = new IvyNodeEviction(this);
        this.callers = new IvyNodeCallers(this);
    }

    public boolean loadData(String rootModuleConf, IvyNode parent, String parentConf, String conf, boolean shouldBePublic, IvyNodeUsage usage) {
        Message.debug("loadData of " + this.toString() + " of rootConf=" + rootModuleConf);
        if (!this.isRoot() && this.data.getReport() != null) {
            this.data.getReport().addDependency(this);
        }
        boolean loaded = false;
        if (this.hasProblem()) {
            Message.debug("Node has problem.  Skip loading");
        } else if (this.isEvicted(rootModuleConf)) {
            Message.debug(rootModuleConf + " is evicted.  Skip loading");
        } else if (!this.hasConfigurationsToLoad() && this.isRootModuleConfLoaded(rootModuleConf)) {
            Message.debug(rootModuleConf + " is loaded and no conf to load.  Skip loading");
        } else {
            this.markRootModuleConfLoaded(rootModuleConf);
            if (this.md == null) {
                ResolveEngine engine = IvyContext.getContext().getIvy().getResolveEngine();
                DependencyResolver resolver = engine.getDictatorResolver();
                if (resolver == null) {
                    resolver = this.data.getSettings().getResolver(this.getId());
                }
                if (resolver == null) {
                    Message.error("no resolver found for " + this.getModuleId() + ": check your configuration");
                    this.problem = new RuntimeException("no resolver found for " + this.getModuleId() + ": check your configuration");
                    return false;
                }
                try {
                    Message.debug("\tusing " + resolver + " to resolve " + this.getId());
                    DependencyDescriptor dependencyDescriptor = this.getDependencyDescriptor(parent);
                    long start = System.currentTimeMillis();
                    ModuleRevisionId requestedRevisionId = dependencyDescriptor.getDependencyRevisionId();
                    this.data.getEventManager().fireIvyEvent(new StartResolveDependencyEvent(resolver, dependencyDescriptor, requestedRevisionId));
                    this.module = resolver.getDependency(dependencyDescriptor, this.data);
                    this.data.getEventManager().fireIvyEvent(new EndResolveDependencyEvent(resolver, dependencyDescriptor, requestedRevisionId, this.module, System.currentTimeMillis() - start));
                    if (this.module != null) {
                        this.module.getResolver().getRepositoryCacheManager().saveResolvers(this.module.getDescriptor(), this.module.getResolver().getName(), this.module.getArtifactResolver().getName());
                        if (this.settings.logModuleWhenFound() && "default".equals(this.getData().getOptions().getLog())) {
                            Message.info("\tfound " + this.module.getId() + " in " + this.module.getResolver().getName());
                        } else {
                            Message.verbose("\tfound " + this.module.getId() + " in " + this.module.getResolver().getName());
                        }
                        if (this.settings.getVersionMatcher().isDynamic(this.getId()) && this.settings.getVersionMatcher().isDynamic(this.module.getId())) {
                            Message.error("impossible to resolve dynamic revision for " + this.getId() + ": check your configuration and make sure revision is part of your pattern");
                            this.problem = new RuntimeException("impossible to resolve dynamic revision");
                            return false;
                        }
                        if (!this.getId().equals(this.module.getId())) {
                            IvyNode resolved = this.data.getNode(this.module.getId());
                            if (resolved != null) {
                                this.md = this.module.getDescriptor();
                                if (!this.handleConfiguration(loaded, rootModuleConf, parent, parentConf, conf, shouldBePublic, usage)) {
                                    return false;
                                }
                                this.moveToRealNode(rootModuleConf, parent, parentConf, conf, shouldBePublic, resolved);
                                return true;
                            }
                            String log = "\t[" + this.module.getId().getRevision() + "] " + this.getId();
                            if (!this.settings.getVersionMatcher().isDynamic(this.getId())) {
                                log = log + " (forced)";
                            }
                            if (this.settings.logResolvedRevision() && "default".equals(this.getData().getOptions().getLog())) {
                                Message.info(log);
                            } else {
                                Message.verbose(log);
                            }
                        }
                    } else {
                        Message.warn("\tmodule not found: " + this.getId());
                        resolver.reportFailure();
                        this.problem = new RuntimeException("not found");
                        return false;
                    }
                    this.downloaded = this.module.getReport().isDownloaded();
                    this.searched = this.module.getReport().isSearched();
                    loaded = true;
                    this.md = this.module.getDescriptor();
                    this.confsToFetch.remove("*");
                    this.updateConfsToFetch(Arrays.asList(this.resolveSpecialConfigurations(this.getRequiredConfigurations(parent, parentConf))));
                }
                catch (ResolveProcessException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.problem = e;
                    Message.debug("Unexpected error: " + this.problem.getMessage(), this.problem);
                    return false;
                }
            } else {
                loaded = true;
            }
        }
        this.handleConfiguration(loaded, rootModuleConf, parent, parentConf, conf, shouldBePublic, usage);
        if (this.hasProblem()) {
            Message.debug("problem : " + this.problem.getMessage());
            return false;
        }
        DependencyDescriptor dd = this.getDependencyDescriptor(parent);
        if (dd != null) {
            usage.addUsage(rootModuleConf, dd, parentConf);
        }
        return loaded;
    }

    private void moveToRealNode(String rootModuleConf, IvyNode parent, String parentConf, String conf, boolean shouldBePublic, IvyNode resolved) {
        if (resolved.md == null) {
            resolved.md = this.md;
        }
        if (resolved.module == null) {
            resolved.module = this.module;
        }
        resolved.downloaded |= this.module.getReport().isDownloaded();
        resolved.searched |= this.module.getReport().isSearched();
        resolved.dds.putAll(this.dds);
        resolved.updateDataFrom(this, rootModuleConf, true);
        resolved.loadData(rootModuleConf, parent, parentConf, conf, shouldBePublic, this.usage);
        resolved.usage.updateDataFrom(this.getAllUsages(), rootModuleConf);
        this.usage = resolved.usage;
        this.data.replaceNode(this.getId(), resolved, rootModuleConf);
        if (this.settings.logResolvedRevision() && "default".equals(this.getData().getOptions().getLog())) {
            Message.info("\t[" + this.module.getId().getRevision() + "] " + this.getId());
        } else {
            Message.verbose("\t[" + this.module.getId().getRevision() + "] " + this.getId());
        }
    }

    public Collection<IvyNode> getDependencies(String rootModuleConf, String[] confs, String requestedConf) {
        if (this.md == null) {
            throw new IllegalStateException("impossible to get dependencies when data has not been loaded");
        }
        if (Arrays.asList(confs).contains("*")) {
            confs = this.isRoot() ? this.md.getConfigurationsNames() : this.md.getPublicConfigurationsNames();
        }
        HashSet<IvyNode> deps = new HashSet<IvyNode>();
        for (String conf : confs) {
            deps.addAll(this.getDependencies(rootModuleConf, conf, requestedConf));
        }
        return deps;
    }

    public Collection<IvyNode> getDependencies(String rootModuleConf, String conf, String requestedConf) {
        if (this.md == null) {
            throw new IllegalStateException("impossible to get dependencies when data has not been loaded");
        }
        LinkedHashMap<ModuleRevisionId, IvyNode> dependencies = new LinkedHashMap<ModuleRevisionId, IvyNode>();
        for (DependencyDescriptor dependencyDescriptor : this.md.getDependencies()) {
            DependencyDescriptor dd = this.data.mediate(dependencyDescriptor);
            String[] dependencyConfigurations = dd.getDependencyConfigurations(conf, requestedConf);
            if (dependencyConfigurations.length == 0) continue;
            ModuleRevisionId requestedDependencyRevisionId = dd.getDependencyRevisionId();
            if (this.isDependencyModuleExcluded(dd, rootModuleConf, requestedDependencyRevisionId, conf)) {
                Message.verbose("excluding " + dd + " in " + conf);
                continue;
            }
            IvyNode depNode = (IvyNode)dependencies.get(requestedDependencyRevisionId);
            if (depNode == null) {
                depNode = this.data.getNode(requestedDependencyRevisionId);
            }
            if (depNode == null) {
                depNode = new IvyNode(this.data, this, dd);
            } else {
                depNode.addDependencyDescriptor(this, dd);
                if (depNode.hasProblem()) {
                    // empty if block
                }
            }
            String[] confsArray = depNode.resolveSpecialConfigurations(dependencyConfigurations);
            List<String> confs = Arrays.asList(confsArray);
            depNode.updateConfsToFetch(confs);
            depNode.addRootModuleConfigurations(depNode.usage, rootModuleConf, confsArray);
            depNode.usage.setRequiredConfs(this, conf, confs);
            depNode.addCaller(rootModuleConf, this, conf, requestedConf, dependencyConfigurations, dd);
            dependencies.put(requestedDependencyRevisionId, depNode);
        }
        return dependencies.values();
    }

    private void addDependencyDescriptor(IvyNode parent, DependencyDescriptor dd) {
        this.dds.put(parent, dd);
    }

    public DependencyDescriptor getDependencyDescriptor(IvyNode parent) {
        return this.dds.get(parent);
    }

    private boolean isDependencyModuleExcluded(DependencyDescriptor dd, String rootModuleConf, ModuleRevisionId dependencyRevisionId, String conf) {
        Artifact a = DefaultArtifact.newIvyArtifact(dependencyRevisionId, null);
        if (this.isRoot()) {
            Boolean exclude = this.doesExclude(this.md, rootModuleConf, new String[]{rootModuleConf}, dd, a, new ArrayDeque<IvyNode>());
            return exclude != null && exclude != false;
        }
        return this.callers.doesCallersExclude(rootModuleConf, a);
    }

    Boolean doesExclude(ModuleDescriptor md, String rootModuleConf, String[] moduleConfs, DependencyDescriptor dd, Artifact artifact, Deque<IvyNode> callersStack) {
        if (this.directlyExcludes(md, moduleConfs, dd, artifact)) {
            return Boolean.TRUE;
        }
        IvyNode c = this.getData().getNode(md.getModuleRevisionId());
        if (c != null) {
            if (callersStack.contains(c)) {
                return null;
            }
            return c.doesCallersExclude(rootModuleConf, artifact, callersStack);
        }
        return Boolean.FALSE;
    }

    public boolean directlyExcludes(ModuleDescriptor md, String[] moduleConfs, DependencyDescriptor dd, Artifact artifact) {
        return dd != null && dd.doesExclude(moduleConfs, artifact.getId().getArtifactId()) || md.doesExclude(moduleConfs, artifact.getId().getArtifactId());
    }

    public boolean hasConfigurationsToLoad() {
        return !this.confsToFetch.isEmpty();
    }

    private boolean markRootModuleConfLoaded(String rootModuleConf) {
        return this.loadedRootModuleConfs.add(rootModuleConf);
    }

    private boolean isRootModuleConfLoaded(String rootModuleConf) {
        return this.loadedRootModuleConfs.contains(rootModuleConf);
    }

    private boolean handleConfiguration(boolean loaded, String rootModuleConf, IvyNode parent, String parentConf, String conf, boolean shouldBePublic, IvyNodeUsage usage) {
        if (this.md != null) {
            String[] confs = this.getRealConfs(conf);
            this.addRootModuleConfigurations(usage, rootModuleConf, confs);
            for (String realConf : confs) {
                Configuration c = this.md.getConfiguration(realConf);
                if (c == null) {
                    this.confsToFetch.remove(conf);
                    if (this.isConfRequiredByMergedUsageOnly(rootModuleConf, conf)) {
                        Message.verbose("configuration required by evicted revision is not available in selected revision. skipping " + conf + " in " + this);
                    } else {
                        this.problem = !conf.equals(realConf) ? new RuntimeException("configuration not found in " + this + ": '" + conf + "'. Missing configuration: '" + realConf + "'. It was required from " + parent + " " + parentConf) : new RuntimeException("configuration not found in " + this + ": '" + realConf + "'. It was required from " + parent + " " + parentConf);
                    }
                    return false;
                }
                if (!shouldBePublic || this.isRoot() || Configuration.Visibility.PUBLIC.equals(c.getVisibility())) continue;
                this.confsToFetch.remove(conf);
                if (this.isConfRequiredByMergedUsageOnly(rootModuleConf, conf)) {
                    Message.verbose("configuration required by evicted revision is not visible in selected revision. skipping " + conf + " in " + this);
                } else {
                    this.problem = new RuntimeException("configuration not public in " + this + ": '" + c + "'. It was required from " + parent + " " + parentConf);
                }
                return false;
            }
            if (loaded) {
                this.fetchedConfigurations.add(conf);
                this.confsToFetch.removeAll(Arrays.asList(confs));
                this.confsToFetch.remove(conf);
            }
        }
        return true;
    }

    private String getDefaultConf(String conf) {
        Matcher m4 = FALLBACK_CONF_PATTERN.matcher(conf);
        return m4.matches() ? m4.group(2) : conf;
    }

    private String getMainConf(String conf) {
        Matcher m4 = FALLBACK_CONF_PATTERN.matcher(conf);
        return m4.matches() ? m4.group(1) : null;
    }

    public void updateConfsToFetch(Collection<String> confs) {
        this.confsToFetch.addAll(confs);
        this.confsToFetch.removeAll(this.fetchedConfigurations);
    }

    private String[] resolveSpecialConfigurations(String[] dependencyConfigurations) {
        if (dependencyConfigurations.length == 1 && dependencyConfigurations[0].startsWith("*") && this.isLoaded()) {
            String conf = dependencyConfigurations[0];
            if ("*".equals(conf)) {
                return this.getDescriptor().getPublicConfigurationsNames();
            }
            List<String> exclusions = Arrays.asList(conf.substring(2).split("\\!"));
            ArrayList<String> ret = new ArrayList<String>(Arrays.asList(this.getDescriptor().getPublicConfigurationsNames()));
            ret.removeAll(exclusions);
            return ret.toArray(new String[ret.size()]);
        }
        return dependencyConfigurations;
    }

    public String[] getRequiredConfigurations(IvyNode in, String inConf) {
        LinkedHashSet req = new LinkedHashSet();
        this.addAllIfNotNull(req, this.usage.getRequiredConfigurations(in, inConf));
        for (IvyNodeUsage usage : this.mergedUsages.values()) {
            this.addAllIfNotNull(req, usage.getRequiredConfigurations(in, inConf));
        }
        return req.toArray(new String[req.size()]);
    }

    private <T> void addAllIfNotNull(Collection<T> into, Collection<T> col) {
        if (col != null) {
            into.addAll(col);
        }
    }

    public String[] getRequiredConfigurations() {
        ArrayList<String> required = new ArrayList<String>(this.confsToFetch.size() + this.fetchedConfigurations.size());
        required.addAll(this.fetchedConfigurations);
        required.addAll(this.confsToFetch);
        return required.toArray(new String[required.size()]);
    }

    public Configuration getConfiguration(String conf) {
        if (this.md == null) {
            throw new IllegalStateException("impossible to get configuration when data has not been loaded");
        }
        String defaultConf = this.getDefaultConf(conf);
        Configuration configuration = this.md.getConfiguration(conf = this.getMainConf(conf));
        if (configuration == null) {
            configuration = this.md.getConfiguration(defaultConf);
        }
        return configuration;
    }

    public String[] getConfigurations(String rootModuleConf) {
        LinkedHashSet depConfs = new LinkedHashSet();
        this.addAllIfNotNull(depConfs, this.usage.getConfigurations(rootModuleConf));
        for (IvyNodeUsage usage : this.mergedUsages.values()) {
            this.addAllIfNotNull(depConfs, usage.getConfigurations(rootModuleConf));
        }
        return depConfs.toArray(new String[depConfs.size()]);
    }

    protected boolean isConfRequiredByMergedUsageOnly(String rootModuleConf, String conf) {
        Set<String> confs = this.usage.getConfigurations(rootModuleConf);
        return confs == null || !confs.contains(conf);
    }

    @Deprecated
    public void discardConf(String rootModuleConf, String conf) {
        Set<String> depConfs = this.usage.addAndGetConfigurations(rootModuleConf);
        if (this.md == null) {
            depConfs.remove(conf);
        } else {
            Configuration c = this.md.getConfiguration(conf);
            if (conf == null) {
                Message.warn("unknown configuration in " + this.getId() + ": " + conf);
            } else {
                for (String ext : c.getExtends()) {
                    this.discardConf(rootModuleConf, ext);
                }
                depConfs.remove(c.getName());
            }
        }
    }

    private void addRootModuleConfigurations(IvyNodeUsage usage, String rootModuleConf, String[] dependencyConfs) {
        if (this.md != null) {
            for (String dependencyConf : dependencyConfs) {
                Configuration conf = this.md.getConfiguration(dependencyConf);
                if (conf == null) continue;
                this.addRootModuleConfigurations(usage, rootModuleConf, conf.getExtends());
            }
        }
        Collections.addAll(usage.addAndGetConfigurations(rootModuleConf), dependencyConfs);
    }

    public String[] getRootModuleConfigurations() {
        Set<String> confs = this.getRootModuleConfigurationsSet();
        return confs.toArray(new String[confs.size()]);
    }

    public Set<String> getRootModuleConfigurationsSet() {
        LinkedHashSet<String> confs = new LinkedHashSet<String>();
        this.addAllIfNotNull(confs, this.usage.getRootModuleConfigurations());
        for (IvyNodeUsage usage : this.mergedUsages.values()) {
            this.addAllIfNotNull(confs, usage.getRootModuleConfigurations());
        }
        return confs;
    }

    public String[] getConfsToFetch() {
        return this.confsToFetch.toArray(new String[this.confsToFetch.size()]);
    }

    public String[] getRealConfs(String conf) {
        if (this.md == null) {
            return new String[]{conf};
        }
        String defaultConf = this.getDefaultConf(conf);
        if (this.md.getConfiguration(conf = this.getMainConf(conf)) == null || Configuration.Visibility.PRIVATE.equals(this.md.getConfiguration(conf).getVisibility())) {
            if ("".equals(defaultConf)) {
                return new String[0];
            }
            conf = defaultConf;
        }
        if (conf.charAt(0) == '*') {
            return this.resolveSpecialConfigurations(new String[]{conf});
        }
        if (conf.contains(",")) {
            return StringUtils.splitToArray(conf);
        }
        return new String[]{conf};
    }

    private Collection<IvyNode> findPath(ModuleId from) {
        return this.findPath(from, this, new LinkedList<IvyNode>());
    }

    private Collection<IvyNode> findPath(ModuleId from, IvyNode node, List<IvyNode> path) {
        IvyNode parent = node.getDirectCallerFor(from);
        if (parent == null) {
            throw new IllegalArgumentException("no path from " + from + " to " + this.getId() + " found");
        }
        if (path.contains(parent)) {
            path.add(0, parent);
            Message.verbose("circular dependency found while looking for the path for another one: was looking for " + from + " as a caller of " + path.get(path.size() - 1));
            return path;
        }
        path.add(0, parent);
        if (parent.getId().getModuleId().equals(from)) {
            return path;
        }
        return this.findPath(from, parent, path);
    }

    private void updateDataFrom(IvyNode node, String rootModuleConf, boolean real) {
        this.callers.updateFrom(node.callers, rootModuleConf, real);
        if (real) {
            this.usage.updateDataFrom(node.getAllUsages(), rootModuleConf);
        } else {
            IvyNodeUsage mergedUsage = this.mergedUsages.get(node.getId());
            if (mergedUsage == null) {
                mergedUsage = new IvyNodeUsage(node);
                this.mergedUsages.put(node.getId(), mergedUsage);
            }
            mergedUsage.updateDataFrom(node.getAllUsages(), rootModuleConf);
        }
        this.updateConfsToFetch(node.fetchedConfigurations);
        this.updateConfsToFetch(node.confsToFetch);
    }

    private Collection<IvyNodeUsage> getAllUsages() {
        ArrayList<IvyNodeUsage> usages = new ArrayList<IvyNodeUsage>();
        usages.add(this.usage);
        usages.addAll(this.mergedUsages.values());
        return usages;
    }

    public Artifact[] getAllArtifacts() {
        HashSet<Artifact> ret = new HashSet<Artifact>();
        for (String rootModuleConf : this.getRootModuleConfigurationsSet()) {
            ret.addAll(Arrays.asList(this.getArtifacts(rootModuleConf)));
        }
        return ret.toArray(new Artifact[ret.size()]);
    }

    public Artifact[] getSelectedArtifacts(Filter<Artifact> artifactFilter) {
        Collection<Object> ret = new HashSet();
        for (String rootModuleConf : this.getRootModuleConfigurationsSet()) {
            if (this.isEvicted(rootModuleConf) || this.isBlacklisted(rootModuleConf)) continue;
            ret.addAll(Arrays.asList(this.getArtifacts(rootModuleConf)));
        }
        ret = FilterHelper.filter(ret, artifactFilter);
        return ret.toArray(new Artifact[ret.size()]);
    }

    public Artifact[] getArtifacts(String rootModuleConf) {
        String[] confs = this.getConfigurations(rootModuleConf);
        if (confs == null || confs.length == 0) {
            return new Artifact[0];
        }
        if (this.md == null) {
            throw new IllegalStateException("impossible to get artifacts when data has not been loaded. IvyNode = " + this);
        }
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        Set<DependencyArtifactDescriptor> dependencyArtifacts = this.usage.getDependencyArtifactsSet(rootModuleConf);
        if (this.md.isDefault() && dependencyArtifacts != null && !dependencyArtifacts.isEmpty()) {
            this.addArtifactsFromOwnUsage(artifacts, dependencyArtifacts);
            this.addArtifactsFromMergedUsage(rootModuleConf, artifacts);
        } else {
            LinkedHashSet includes = new LinkedHashSet();
            this.addAllIfNotNull(includes, this.usage.getDependencyIncludesSet(rootModuleConf));
            for (IvyNodeUsage ivyNodeUsage : this.mergedUsages.values()) {
                this.addAllIfNotNull(includes, ivyNodeUsage.getDependencyIncludesSet(rootModuleConf));
            }
            if ((dependencyArtifacts == null || dependencyArtifacts.isEmpty()) && includes.isEmpty()) {
                for (String conf : confs) {
                    artifacts.addAll(Arrays.asList(this.md.getArtifacts(conf)));
                }
            } else {
                HashMap<ArtifactId, Artifact> allArtifacts = new HashMap<ArtifactId, Artifact>();
                for (String conf : confs) {
                    for (Artifact art : this.md.getArtifacts(conf)) {
                        allArtifacts.put(art.getId().getArtifactId(), art);
                    }
                }
                if (dependencyArtifacts != null) {
                    this.addArtifactsFromOwnUsage(artifacts, dependencyArtifacts);
                }
                this.addArtifactsFromMergedUsage(rootModuleConf, artifacts);
                Iterator iterator = includes.iterator();
                while (iterator.hasNext()) {
                    IncludeRule dad = (IncludeRule)iterator.next();
                    Collection<Artifact> arts = IvyNode.findArtifactsMatching(dad, allArtifacts);
                    if (arts.isEmpty()) {
                        Message.error("a required artifact is not listed by module descriptor: " + dad.getId());
                        iterator.remove();
                        continue;
                    }
                    Message.debug(this + " in " + rootModuleConf + ": including " + arts);
                    artifacts.addAll(arts);
                }
            }
        }
        Iterator iter = artifacts.iterator();
        HashSet<ArtifactRevisionId> artifactRevisionsSeen = new HashSet<ArtifactRevisionId>();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            boolean excluded = this.callers.doesCallersExclude(rootModuleConf, artifact);
            if (excluded) {
                Message.debug(this + " in " + rootModuleConf + ": excluding " + artifact);
                iter.remove();
            }
            if (artifactRevisionsSeen.add(artifact.getId())) continue;
            Message.debug(this + " in " + rootModuleConf + ": skipping duplicate " + artifact);
            iter.remove();
        }
        return artifacts.toArray(new Artifact[artifacts.size()]);
    }

    private void addArtifactsFromOwnUsage(Set<Artifact> artifacts, Set<DependencyArtifactDescriptor> dependencyArtifacts) {
        for (DependencyArtifactDescriptor dad : dependencyArtifacts) {
            artifacts.add(new MDArtifact(this.md, dad.getName(), dad.getType(), dad.getExt(), dad.getUrl(), dad.getQualifiedExtraAttributes()));
        }
    }

    private void addArtifactsFromMergedUsage(String rootModuleConf, Set<Artifact> artifacts) {
        for (IvyNodeUsage usage : this.mergedUsages.values()) {
            Set<DependencyArtifactDescriptor> mergedDependencyArtifacts = usage.getDependencyArtifactsSet(rootModuleConf);
            if (mergedDependencyArtifacts == null) continue;
            for (DependencyArtifactDescriptor dad : mergedDependencyArtifacts) {
                HashMap<String, String> extraAttributes = new HashMap<String, String>(dad.getQualifiedExtraAttributes());
                MDArtifact artifact = new MDArtifact(this.md, dad.getName(), dad.getType(), dad.getExt(), dad.getUrl(), extraAttributes);
                if (artifacts.contains(artifact)) continue;
                extraAttributes.put("ivy:merged", dad.getDependencyDescriptor().getParentRevisionId() + " -> " + usage.getNode().getId());
                artifacts.add(artifact);
            }
        }
    }

    private static Collection<Artifact> findArtifactsMatching(IncludeRule rule, Map<ArtifactId, Artifact> allArtifacts) {
        ArrayList<Artifact> ret = new ArrayList<Artifact>();
        for (Map.Entry<ArtifactId, Artifact> entry : allArtifacts.entrySet()) {
            if (!MatcherHelper.matches(rule.getMatcher(), rule.getId(), entry.getKey())) continue;
            ret.add(entry.getValue());
        }
        return ret;
    }

    public boolean hasProblem() {
        return this.problem != null;
    }

    public Exception getProblem() {
        return this.problem;
    }

    public String getProblemMessage() {
        return StringUtils.getErrorMessage(this.problem);
    }

    public boolean isDownloaded() {
        return this.downloaded;
    }

    public boolean isSearched() {
        return this.searched;
    }

    public boolean isLoaded() {
        return this.md != null;
    }

    public boolean isFetched(String conf) {
        return this.fetchedConfigurations.contains(conf);
    }

    public IvyNode findNode(ModuleRevisionId mrid) {
        return this.data.getNode(mrid);
    }

    boolean isRoot() {
        return this.root == this;
    }

    public IvyNode getRoot() {
        return this.root;
    }

    public ConflictManager getConflictManager(ModuleId mid) {
        if (this.md == null) {
            throw new IllegalStateException("impossible to get conflict manager when data has not been loaded. IvyNode = " + this);
        }
        ConflictManager cm = this.md.getConflictManager(mid);
        return cm == null ? this.settings.getConflictManager(mid) : cm;
    }

    public IvyNode getRealNode() {
        IvyNode real = this.data.getNode(this.getId());
        return real != null ? real : this;
    }

    public ModuleRevisionId getId() {
        return this.id;
    }

    public ModuleId getModuleId() {
        return this.id.getModuleId();
    }

    public ModuleDescriptor getDescriptor() {
        return this.md;
    }

    public ResolveData getData() {
        return this.data;
    }

    public ResolvedModuleRevision getModuleRevision() {
        return this.module;
    }

    public long getPublication() {
        if (this.module != null) {
            return this.module.getPublicationDate().getTime();
        }
        return 0L;
    }

    public long getLastModified() {
        if (this.md != null) {
            return this.md.getLastModified();
        }
        return 0L;
    }

    public ModuleRevisionId getResolvedId() {
        if (this.md != null && this.md.getResolvedModuleRevisionId().getRevision() != null) {
            return this.md.getResolvedModuleRevisionId();
        }
        if (this.module != null) {
            return this.module.getId();
        }
        return this.getId();
    }

    public void clean() {
        this.confsToFetch.clear();
    }

    boolean canExclude(String rootModuleConf) {
        for (IvyNodeCallers.Caller caller : this.getCallers(rootModuleConf)) {
            if (!caller.canExclude()) continue;
            return true;
        }
        return false;
    }

    private IvyNode getDirectCallerFor(ModuleId from) {
        return this.callers.getDirectCallerFor(from);
    }

    public IvyNodeCallers.Caller[] getCallers(String rootModuleConf) {
        return this.callers.getCallers(rootModuleConf);
    }

    public Collection<ModuleId> getAllCallersModuleIds() {
        return this.callers.getAllCallersModuleIds();
    }

    public IvyNodeCallers.Caller[] getAllCallers() {
        return this.callers.getAllCallers();
    }

    public IvyNodeCallers.Caller[] getAllRealCallers() {
        return this.callers.getAllRealCallers();
    }

    public void addCaller(String rootModuleConf, IvyNode callerNode, String callerConf, String requestedConf, String[] dependencyConfs, DependencyDescriptor dd) {
        this.callers.addCaller(rootModuleConf, callerNode, callerConf, requestedConf, dependencyConfs, dd);
        boolean isCircular = this.callers.getAllCallersModuleIds().contains(this.getId().getModuleId());
        if (isCircular) {
            IvyContext.getContext().getCircularDependencyStrategy().handleCircularDependency(this.toMrids(this.findPath(this.getId().getModuleId()), this));
        }
    }

    public boolean doesCallersExclude(String rootModuleConf, Artifact artifact, Deque<IvyNode> callersStack) {
        return this.callers.doesCallersExclude(rootModuleConf, artifact, callersStack);
    }

    @Deprecated
    public boolean doesCallersExclude(String rootModuleConf, Artifact artifact, Stack<ModuleRevisionId> callersStack) {
        ArrayDeque<IvyNode> callersDeque = new ArrayDeque<IvyNode>();
        for (ModuleRevisionId mrid : callersStack) {
            for (IvyNodeCallers.Caller caller : this.getCallers(rootModuleConf)) {
                if (!caller.getModuleRevisionId().equals(mrid)) continue;
                callersDeque.add(this.data.getNode(mrid));
            }
        }
        return this.callers.doesCallersExclude(rootModuleConf, artifact, callersDeque);
    }

    private ModuleRevisionId[] toMrids(Collection<IvyNode> path, IvyNode depNode) {
        ModuleRevisionId[] ret = new ModuleRevisionId[path.size() + 1];
        int i = 0;
        for (IvyNode node : path) {
            ret[i++] = node.getId();
        }
        ret[ret.length - 1] = depNode.getId();
        return ret;
    }

    public Set<IvyNode> getResolvedNodes(ModuleId moduleId, String rootModuleConf) {
        return this.eviction.getResolvedNodes(moduleId, rootModuleConf);
    }

    public Collection<ModuleRevisionId> getResolvedRevisions(ModuleId moduleId, String rootModuleConf) {
        return this.eviction.getResolvedRevisions(moduleId, rootModuleConf);
    }

    public void markEvicted(IvyNodeEviction.EvictionData evictionData) {
        this.eviction.markEvicted(evictionData);
        String rootModuleConf = evictionData.getRootModuleConf();
        if (evictionData.getSelected() != null) {
            for (IvyNode selected : evictionData.getSelected()) {
                selected.updateDataFrom(this, rootModuleConf, false);
            }
        }
    }

    public Collection<ConflictManager> getAllEvictingConflictManagers() {
        return this.eviction.getAllEvictingConflictManagers();
    }

    public Collection<IvyNode> getAllEvictingNodes() {
        return this.eviction.getAllEvictingNodes();
    }

    public Collection<String> getAllEvictingNodesDetails() {
        return this.eviction.getAllEvictingNodesDetails();
    }

    public String[] getEvictedConfs() {
        return this.eviction.getEvictedConfs();
    }

    public IvyNodeEviction.EvictionData getEvictedData(String rootModuleConf) {
        return this.eviction.getEvictedData(rootModuleConf);
    }

    public Collection<IvyNode> getEvictedNodes(ModuleId mid, String rootModuleConf) {
        return this.eviction.getEvictedNodes(mid, rootModuleConf);
    }

    public Collection<ModuleRevisionId> getEvictedRevisions(ModuleId mid, String rootModuleConf) {
        return this.eviction.getEvictedRevisions(mid, rootModuleConf);
    }

    public IvyNodeEviction.EvictionData getEvictionDataInRoot(String rootModuleConf, IvyNode ancestor) {
        return this.eviction.getEvictionDataInRoot(rootModuleConf, ancestor);
    }

    public boolean isCompletelyEvicted() {
        return this.eviction.isCompletelyEvicted();
    }

    public boolean isEvicted(String rootModuleConf) {
        return this.eviction.isEvicted(rootModuleConf);
    }

    public void markEvicted(String rootModuleConf, IvyNode node, ConflictManager conflictManager, Collection<IvyNode> resolved) {
        IvyNodeEviction.EvictionData evictionData = new IvyNodeEviction.EvictionData(rootModuleConf, node, conflictManager, resolved);
        this.markEvicted(evictionData);
    }

    public void setEvictedNodes(ModuleId moduleId, String rootModuleConf, Collection<IvyNode> evicted) {
        this.eviction.setEvictedNodes(moduleId, rootModuleConf, evicted);
    }

    public void setResolvedNodes(ModuleId moduleId, String rootModuleConf, Collection<IvyNode> resolved) {
        this.eviction.setResolvedNodes(moduleId, rootModuleConf, resolved);
    }

    public String toString() {
        return this.getResolvedId().toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IvyNode)) {
            return false;
        }
        IvyNode node = (IvyNode)obj;
        return node.getId().equals(this.getId());
    }

    @Override
    public int compareTo(IvyNode that) {
        return this.getModuleId().compareTo(that.getModuleId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public Collection<IvyNode> getPendingConflicts(String rootModuleConf, ModuleId mid) {
        return this.eviction.getPendingConflicts(rootModuleConf, mid);
    }

    public void setPendingConflicts(ModuleId moduleId, String rootModuleConf, Collection<IvyNode> conflicts) {
        this.eviction.setPendingConflicts(moduleId, rootModuleConf, conflicts);
    }

    public void blacklist(IvyNodeBlacklist bdata) {
        if (this.data.getSettings().logResolvedRevision()) {
            Message.info("BLACKLISTING " + bdata);
        } else {
            Message.verbose("BLACKLISTING " + bdata);
        }
        Stack<IvyNode> callerStack = new Stack<IvyNode>();
        callerStack.push(this);
        this.clearEvictionDataInAllCallers(bdata.getRootModuleConf(), callerStack);
        this.usage.blacklist(bdata);
        this.data.blacklist(this);
    }

    private void clearEvictionDataInAllCallers(String rootModuleConf, Stack<IvyNode> callerStack) {
        for (IvyNodeCallers.Caller caller : callerStack.peek().getCallers(rootModuleConf)) {
            IvyNode callerNode = this.findNode(caller.getModuleRevisionId());
            if (callerNode == null) continue;
            callerNode.eviction = new IvyNodeEviction(callerNode);
            if (callerStack.contains(callerNode)) continue;
            callerStack.push(callerNode);
            this.clearEvictionDataInAllCallers(rootModuleConf, callerStack);
            callerStack.pop();
        }
    }

    public boolean isBlacklisted(String rootModuleConf) {
        return this.usage.isBlacklisted(rootModuleConf);
    }

    public boolean isCompletelyBlacklisted() {
        if (this.isRoot()) {
            return false;
        }
        for (String rootModuleConfiguration : this.getRootModuleConfigurations()) {
            if (this.isBlacklisted(rootModuleConfiguration)) continue;
            return false;
        }
        return true;
    }

    public IvyNodeBlacklist getBlacklistData(String rootModuleConf) {
        return this.usage.getBlacklistData(rootModuleConf);
    }

    public IvyNodeUsage getMainUsage() {
        return this.usage;
    }

    public boolean hasAnyMergedUsageWithTransitiveDependency(String rootModuleConf) {
        if (this.mergedUsages == null) {
            return false;
        }
        for (IvyNodeUsage usage : this.mergedUsages.values()) {
            if (!usage.hasTransitiveDepender(rootModuleConf)) continue;
            return true;
        }
        return false;
    }
}

