/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.Log;
import com.perforce.p4java.client.IClient;
import com.perforce.p4java.client.IClientSummary;
import com.perforce.p4java.common.base.P4JavaExceptions;
import com.perforce.p4java.common.base.P4ResultMapUtils;
import com.perforce.p4java.core.file.DiffType;
import com.perforce.p4java.core.file.IFileAnnotation;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.file.FileAnnotation;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.server.GetFileAnnotationsOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.delegator.IFileAnnotateDelegator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class FileAnnotateDelegator
extends BaseDelegator
implements IFileAnnotateDelegator {
    public FileAnnotateDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public List<IFileAnnotation> getFileAnnotations(List<IFileSpec> fileSpecs, @Nonnull DiffType diffType, boolean allResults, boolean useChangeNumbers, boolean followBranches) throws ConnectionException, RequestException, AccessException {
        P4JavaExceptions.throwRequestExceptionIfConditionFails(Objects.isNull((Object)diffType) || diffType.isWsOption(), "Bad whitespace option in getFileAnnotations", new Object[0]);
        try {
            GetFileAnnotationsOptions getFileAnnotationsOptions = new GetFileAnnotationsOptions().setAllResults(allResults).setUseChangeNumbers(useChangeNumbers).setFollowBranches(followBranches).setWsOpts(diffType);
            return this.getFileAnnotations(fileSpecs, getFileAnnotationsOptions);
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IFileAnnotation> getFileAnnotations(List<IFileSpec> fileSpecs, GetFileAnnotationsOptions opts) throws P4JavaException {
        ArrayList<IFileAnnotation> returnList = new ArrayList<IFileAnnotation>();
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.ANNOTATE, Parameters.processParameters(opts, fileSpecs, this.server), null);
        if (Objects.nonNull(resultMaps)) {
            String depotFile = null;
            for (Map<String, Object> map : resultMaps) {
                if (!Objects.nonNull(map)) continue;
                String errStr = ResultMapParser.getErrorStr(map);
                P4JavaExceptions.throwRequestExceptionIfConditionFails(StringUtils.isBlank(errStr), P4ResultMapUtils.parseCode0ErrorString(map), errStr, new Object[0]);
                if (FileAnnotateDelegator.isNewDepotFile(map)) {
                    depotFile = P4ResultMapUtils.parseString(map, "depotFile");
                    continue;
                }
                returnList.addAll(FileAnnotateDelegator.pickupDataAnnotationAndBuildFileAnnotation(depotFile, this.server.getCurrentClient(), map));
            }
        }
        return returnList;
    }

    private static void bindAssociatedContributingIntegrationsToFileAnnotation(@Nonnull Map<String, Object> map, @Nonnull FileAnnotation dataAnnotation) {
        int order = 0;
        while (map.containsKey("depotFile" + order)) {
            try {
                dataAnnotation.addIntegrationAnnotation(new FileAnnotation(order, P4ResultMapUtils.parseString(map, "depotFile" + order), P4ResultMapUtils.parseInt(map, "upper" + order), P4ResultMapUtils.parseInt(map, "lower" + order)));
            }
            catch (Throwable thr) {
                Log.error("bad conversion in getFileAnnotations", new Object[0]);
                Log.exception(thr);
            }
            ++order;
        }
    }

    private static boolean isNewDepotFile(Map<String, Object> map) {
        return map.containsKey("depotFile");
    }

    private static List<IFileAnnotation> pickupDataAnnotationAndBuildFileAnnotation(String depotFile, IClient currentClient, Map<String, Object> map) {
        ArrayList<IFileAnnotation> returnList = new ArrayList<IFileAnnotation>();
        IClientSummary.ClientLineEnd lineEnd = null;
        if (Objects.nonNull(currentClient)) {
            lineEnd = currentClient.getLineEnd();
        }
        FileAnnotation dataAnnotation = new FileAnnotation(map, depotFile, lineEnd);
        returnList.add(dataAnnotation);
        FileAnnotateDelegator.bindAssociatedContributingIntegrationsToFileAnnotation(map, dataAnnotation);
        return returnList;
    }
}

